/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline;

import com.github.rvesse.airline.ArgsRequiredWrongMain;
import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.HelpOption;
import com.github.rvesse.airline.MutuallyExclusiveOptions;
import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.args.Args1;
import com.github.rvesse.airline.args.Args1CustomParser;
import com.github.rvesse.airline.args.Args2;
import com.github.rvesse.airline.args.ArgsAllowedValues;
import com.github.rvesse.airline.args.ArgsArityString;
import com.github.rvesse.airline.args.ArgsBooleanArity;
import com.github.rvesse.airline.args.ArgsBooleanArity0;
import com.github.rvesse.airline.args.ArgsEnum;
import com.github.rvesse.airline.args.ArgsInherited;
import com.github.rvesse.airline.args.ArgsMultipleUnparsed;
import com.github.rvesse.airline.args.ArgsOutOfMemory;
import com.github.rvesse.airline.args.ArgsPrivate;
import com.github.rvesse.airline.args.ArgsRequired;
import com.github.rvesse.airline.args.ArgsRequiredInheritedUnrestricted;
import com.github.rvesse.airline.args.ArgsSingleChar;
import com.github.rvesse.airline.args.ArgsSingleCharCustomParser;
import com.github.rvesse.airline.args.Arity1;
import com.github.rvesse.airline.args.OptionsRequired;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.command.CommandAdd;
import com.github.rvesse.airline.command.CommandCommit;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.github.rvesse.airline.parser.errors.ParseOptionGroupException;
import com.github.rvesse.airline.parser.options.GreedyClassicGetOptParser;
import com.github.rvesse.airline.parser.options.OptionParser;
import com.github.rvesse.airline.parser.options.StandardOptionParser;
import com.github.rvesse.airline.utils.predicates.parser.CommandFinder;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestSingleCommand {
    private static final List<String> V = Arrays.asList("a", "b", "c", "d");

    @Test
    public void simpleArgs() throws ParseException {
        Args1 args = (Args1)SingleCommand.singleCommand(Args1.class).parse(new String[]{"-debug", "-log", "2", "-float", "1.2", "-double", "1.3", "-bigdecimal", "1.4", "-groups", "unit", "a", "b", "c"});
        Assert.assertTrue((boolean)args.debug);
        Assert.assertEquals((int)args.verbose, (int)2);
        Assert.assertEquals((String)args.groups, (String)"unit");
        Assert.assertEquals(args.parameters, Arrays.asList("a", "b", "c"));
        Assert.assertEquals((float)args.floa, (float)1.2f, (float)0.1f);
        Assert.assertEquals((double)args.doub, (double)1.3f, (double)0.1f);
        Assert.assertEquals((Object)args.bigd, (Object)new BigDecimal("1.4"));
    }

    @Test
    public void simpleArgsCustomParserExplicit() throws ParseException {
        ParserMetadata parser = new ParserBuilder().withOptionAbbreviation().build();
        Args1 args = (Args1)SingleCommand.singleCommand(Args1.class, (ParserMetadata)parser).parse(new String[]{"-de", "-log", "2", "-fl", "1.2", "-do", "1.3", "-bigd", "1.4", "-gr", "unit", "a", "b", "c"});
        Assert.assertTrue((boolean)args.debug);
        Assert.assertEquals((int)args.verbose, (int)2);
        Assert.assertEquals((String)args.groups, (String)"unit");
        Assert.assertEquals(args.parameters, Arrays.asList("a", "b", "c"));
        Assert.assertEquals((float)args.floa, (float)1.2f, (float)0.1f);
        Assert.assertEquals((double)args.doub, (double)1.3f, (double)0.1f);
        Assert.assertEquals((Object)args.bigd, (Object)new BigDecimal("1.4"));
    }

    @Test
    public void simpleArgsCustomParserAnnotation() throws ParseException {
        Args1CustomParser args = (Args1CustomParser)SingleCommand.singleCommand(Args1CustomParser.class).parse(new String[]{"-de", "-log", "2", "-fl", "1.2", "-do", "1.3", "-bigd", "1.4", "-gr", "unit", "a", "b", "c"});
        Assert.assertTrue((boolean)args.debug);
        Assert.assertEquals((int)args.verbose, (int)2);
        Assert.assertEquals((String)args.groups, (String)"unit");
        Assert.assertEquals((Collection)args.parameters, Arrays.asList("a", "b", "c"));
        Assert.assertEquals((float)args.floa, (float)1.2f, (float)0.1f);
        Assert.assertEquals((double)args.doub, (double)1.3f, (double)0.1f);
        Assert.assertEquals((Object)args.bigd, (Object)new BigDecimal("1.4"));
    }

    @Test
    public void equalsArgs() throws ParseException {
        Args1 args = (Args1)SingleCommand.singleCommand(Args1.class).parse(new String[]{"-debug", "-log=2", "-float=1.2", "-double=1.3", "-bigdecimal=1.4", "-groups=unit", "a", "b", "c"});
        Assert.assertTrue((boolean)args.debug);
        Assert.assertEquals((int)args.verbose, (int)2);
        Assert.assertEquals((String)args.groups, (String)"unit");
        Assert.assertEquals(args.parameters, Arrays.asList("a", "b", "c"));
        Assert.assertEquals((float)args.floa, (float)1.2f, (float)0.1f);
        Assert.assertEquals((double)args.doub, (double)1.3f, (double)0.1f);
        Assert.assertEquals((Object)args.bigd, (Object)new BigDecimal("1.4"));
    }

    @Test
    public void classicGetoptArgs1() throws ParseException {
        ArgsSingleChar args = (ArgsSingleChar)SingleCommand.singleCommand(ArgsSingleChar.class).parse(new String[]{"-lg", "-dsm", "-pa-p", "-2", "-f-x", "--Dfoo"});
        Assert.assertTrue((boolean)args.l);
        Assert.assertTrue((boolean)args.g);
        Assert.assertTrue((boolean)args.d);
        Assert.assertEquals((String)args.s, (String)"m");
        Assert.assertEquals((String)args.p, (String)"a-p");
        Assert.assertFalse((boolean)args.n);
        Assert.assertTrue((boolean)args.two);
        Assert.assertEquals((String)args.f, (String)"-x");
        Assert.assertFalse((boolean)args.z);
        Assert.assertEquals((String)args.dir, null);
        Assert.assertEquals(args.parameters, Arrays.asList("--Dfoo"));
    }

    @Test
    public void classicGetoptArgs2() throws ParseException {
        ParserMetadata parser = new ParserBuilder().withOptionParsers(new OptionParser[]{new GreedyClassicGetOptParser(), new StandardOptionParser()}).build();
        ArgsSingleCharCustomParser args = (ArgsSingleCharCustomParser)SingleCommand.singleCommand(ArgsSingleCharCustomParser.class, (ParserMetadata)parser).parse(new String[]{"-lg", "-dsn", "-pa-p", "-2f", "-z", "--Dfoo"});
        Assert.assertTrue((boolean)args.l);
        Assert.assertTrue((boolean)args.g);
        Assert.assertTrue((boolean)args.d);
        Assert.assertEquals((String)args.s, (String)"n");
        Assert.assertEquals((String)args.p, (String)"a-p");
        Assert.assertFalse((boolean)args.n);
        Assert.assertTrue((boolean)args.two);
        Assert.assertEquals((String)args.f, (String)"-z");
        Assert.assertFalse((boolean)args.z);
        Assert.assertEquals((String)args.dir, null);
        Assert.assertEquals((Collection)args.parameters, Arrays.asList("--Dfoo"));
    }

    @Test
    public void classicGetoptFailure1() throws ParseException {
        ArgsSingleChar args = (ArgsSingleChar)SingleCommand.singleCommand(ArgsSingleChar.class).parse(new String[]{"-lgX"});
        Assert.assertFalse((boolean)args.l);
        Assert.assertFalse((boolean)args.g);
        Assert.assertEquals(args.parameters, Arrays.asList("-lgX"));
    }

    @Test
    public void classicGetoptArgsFailure2() throws ParseException {
        String[] inputs = new String[]{"-lg", "-dsn", "-pa-p", "-2f", "--Dfoo"};
        ArgsSingleCharCustomParser args = (ArgsSingleCharCustomParser)SingleCommand.singleCommand(ArgsSingleCharCustomParser.class).parse(inputs);
        for (String input : inputs) {
            Assert.assertTrue((boolean)args.parameters.contains(input), (String)String.format("Expected %s to be treated as an argument", input));
        }
    }

    @Test
    public void classicGetoptArgsFailure3() throws ParseException {
        String[] inputs = new String[]{"-lg", "-dsn", "-pa-p", "-2f", "--Dfoo"};
        ParserMetadata parser = new ParserBuilder().withOptionParser((OptionParser)new StandardOptionParser()).build();
        ArgsSingleChar args = (ArgsSingleChar)SingleCommand.singleCommand(ArgsSingleChar.class, (ParserMetadata)parser).parse(inputs);
        for (String input : inputs) {
            Assert.assertTrue((boolean)args.parameters.contains(input), (String)String.format("Expected %s to be treated as an argument", input));
        }
    }

    @Test
    public void repeatedArgs() {
        SingleCommand parser = SingleCommand.singleCommand(Args1.class);
        CommandMetadata command = (CommandMetadata)CollectionUtils.find(Collections.singletonList(parser.getCommandMetadata()), (Predicate)new CommandFinder("Args1"));
        Assert.assertEquals((int)command.getAllOptions().size(), (int)8);
    }

    private void multipleNames(String option) {
        Args1 args = (Args1)SingleCommand.singleCommand(Args1.class).parse(new String[]{option, "2"});
        Assert.assertEquals((int)args.verbose, (int)2);
    }

    @Test
    public void multipleNames1() {
        this.multipleNames("-log");
    }

    @Test
    public void multipleNames2() {
        this.multipleNames("-verbose");
    }

    @Test
    public void arityString() {
        ArgsArityString args = (ArgsArityString)SingleCommand.singleCommand(ArgsArityString.class).parse(new String[]{"-pairs", "pair0", "pair1", "rest"});
        Assert.assertEquals((int)args.pairs.size(), (int)2);
        Assert.assertEquals((String)args.pairs.get(0), (String)"pair0");
        Assert.assertEquals((String)args.pairs.get(1), (String)"pair1");
        Assert.assertEquals((int)args.rest.size(), (int)1);
        Assert.assertEquals((String)args.rest.get(0), (String)"rest");
    }

    @Test(expectedExceptions={ParseException.class})
    public void arity2Fail() {
        SingleCommand.singleCommand(ArgsArityString.class).parse(new String[]{"-pairs", "pair0"});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void multipleUnparsedFail() {
        SingleCommand.singleCommand(ArgsMultipleUnparsed.class).parse(new String[0]);
    }

    @Test
    public void privateArgs() {
        ArgsPrivate args = (ArgsPrivate)SingleCommand.singleCommand(ArgsPrivate.class).parse(new String[]{"-verbose", "3"});
        Assert.assertEquals((int)args.getVerbose(), (int)3);
    }

    private void argsBoolean1(String[] params, Boolean expected) {
        ArgsBooleanArity args = (ArgsBooleanArity)SingleCommand.singleCommand(ArgsBooleanArity.class).parse(params);
        Assert.assertEquals((Object)args.debug, (Object)expected);
    }

    private void argsBoolean0(String[] params, Boolean expected) {
        ArgsBooleanArity0 args = (ArgsBooleanArity0)SingleCommand.singleCommand(ArgsBooleanArity0.class).parse(params);
        Assert.assertEquals((Object)args.debug, (Object)expected);
    }

    @Test
    public void booleanArity1() {
        this.argsBoolean1(new String[0], Boolean.FALSE);
        this.argsBoolean1(new String[]{"-debug", "true"}, Boolean.TRUE);
    }

    @Test
    public void booleanArity0() {
        this.argsBoolean0(new String[0], Boolean.FALSE);
        this.argsBoolean0(new String[]{"-debug"}, Boolean.TRUE);
    }

    @Test(expectedExceptions={ParseException.class})
    public void badParameterShouldThrowParameter1Exception() {
        SingleCommand.singleCommand(Args1.class).parse(new String[]{"-log", "foo"});
    }

    @Test(expectedExceptions={ParseException.class})
    public void badParameterShouldThrowParameter2Exception() {
        SingleCommand.singleCommand(Args1.class).parse(new String[]{"-long", "foo"});
    }

    @Test
    public void allowedValues1() {
        ArgsAllowedValues a = (ArgsAllowedValues)SingleCommand.singleCommand(ArgsAllowedValues.class).parse(new String[]{"-mode", "a"});
        Assert.assertEquals((String)a.mode, (String)"a");
        a = (ArgsAllowedValues)SingleCommand.singleCommand(ArgsAllowedValues.class).parse(new String[]{"-mode", "b"});
        Assert.assertEquals((String)a.mode, (String)"b");
        a = (ArgsAllowedValues)SingleCommand.singleCommand(ArgsAllowedValues.class).parse(new String[]{"-mode", "c"});
        Assert.assertEquals((String)a.mode, (String)"c");
    }

    @Test
    public void allowedValues2() {
        ArgsAllowedValues a = (ArgsAllowedValues)SingleCommand.singleCommand(ArgsAllowedValues.class).parse(new String[]{"-mode=a"});
        Assert.assertEquals((String)a.mode, (String)"a");
        a = (ArgsAllowedValues)SingleCommand.singleCommand(ArgsAllowedValues.class).parse(new String[]{"-mode=b"});
        Assert.assertEquals((String)a.mode, (String)"b");
        a = (ArgsAllowedValues)SingleCommand.singleCommand(ArgsAllowedValues.class).parse(new String[]{"-mode=c"});
        Assert.assertEquals((String)a.mode, (String)"c");
    }

    @Test(expectedExceptions={ParseException.class})
    public void allowedValuesShouldThrowIfNotAllowed1() {
        SingleCommand.singleCommand(ArgsAllowedValues.class).parse(new String[]{"-mode", "d"});
    }

    @Test(expectedExceptions={ParseException.class})
    public void allowedValuesShouldThrowIfNotAllowed2() {
        SingleCommand.singleCommand(ArgsAllowedValues.class).parse(new String[]{"-mode=d"});
    }

    @Test
    public void listParameters() {
        Args2 a = (Args2)SingleCommand.singleCommand(Args2.class).parse(new String[]{"-log", "2", "-groups", "unit", "a", "b", "c", "-host", "host2"});
        Assert.assertEquals((int)a.verbose, (int)2);
        Assert.assertEquals((String)a.groups, (String)"unit");
        Assert.assertEquals(a.hosts, Arrays.asList("host2"));
        Assert.assertEquals(a.parameters, Arrays.asList("a", "b", "c"));
    }

    @Test
    public void inheritance() {
        ArgsInherited args = (ArgsInherited)SingleCommand.singleCommand(ArgsInherited.class).parse(new String[]{"-log", "3", "-child", "2"});
        Assert.assertEquals((int)args.child, (int)2);
        Assert.assertEquals((int)args.log, (int)3);
    }

    @Test
    public void negativeNumber() {
        Args1 a = (Args1)SingleCommand.singleCommand(Args1.class).parse(new String[]{"-verbose", "-3"});
        Assert.assertEquals((int)a.verbose, (int)-3);
    }

    @Test(expectedExceptions={ParseException.class})
    public void requiredMainParameters() {
        SingleCommand.singleCommand(ArgsRequired.class).parse(new String[0]);
    }

    @Test
    public void notRequiredMainParameters() {
        SingleCommand.singleCommand(ArgsRequiredInheritedUnrestricted.class).parse(new String[0]);
    }

    @Test(expectedExceptions={ParseException.class}, expectedExceptionsMessageRegExp=".*option.*missing.*")
    public void requiredOptions() {
        SingleCommand.singleCommand(OptionsRequired.class).parse(new String[0]);
    }

    @Test
    public void ignoresOptionalOptions() {
        SingleCommand.singleCommand(OptionsRequired.class).parse(new String[]{"--required", "foo"});
    }

    private void verifyCommandOrdering(String[] commandNames, Class<?> ... commands) {
        CliBuilder builder = Cli.builder((String)"foo");
        for (Class<?> command : commands) {
            builder = builder.withCommand(command);
        }
        Cli parser = builder.build();
        List commandParsers = parser.getMetadata().getDefaultGroupCommands();
        Assert.assertEquals((int)commandParsers.size(), (int)commands.length);
        int i = 0;
        for (CommandMetadata commandParser : commandParsers) {
            Assert.assertEquals((String)commandParser.getName(), (String)commandNames[i++]);
        }
    }

    @Test
    public void commandsShouldBeShownInOrderOfInsertion() {
        this.verifyCommandOrdering(new String[]{"add", "commit"}, CommandAdd.class, CommandCommit.class);
        this.verifyCommandOrdering(new String[]{"commit", "add"}, CommandCommit.class, CommandAdd.class);
    }

    @DataProvider
    public static Object[][] f() {
        return new Integer[][]{{3, 5, 1}, {3, 8, 1}, {3, 12, 2}, {8, 12, 2}, {9, 10, 1}};
    }

    @Test(expectedExceptions={ParseException.class})
    public void arity1Fail() {
        SingleCommand.singleCommand(Arity1.class).parse(new String[]{"-inspect"});
    }

    @Test
    public void arity1Success1() {
        Arity1 arguments = (Arity1)SingleCommand.singleCommand(Arity1.class).parse(new String[]{"-inspect", "true"});
        Assert.assertTrue((boolean)arguments.inspect);
    }

    @Test
    public void arity1Success2() {
        Arity1 arguments = (Arity1)SingleCommand.singleCommand(Arity1.class).parse(new String[]{"-inspect", "false"});
        Assert.assertFalse((boolean)arguments.inspect);
    }

    @Test(expectedExceptions={ParseException.class}, description="Verify that the main parameter's type is checked to be a List")
    public void wrongMainTypeShouldThrow() {
        SingleCommand.singleCommand(ArgsRequiredWrongMain.class).parse(new String[]{"f2"});
    }

    @Test(description="This used to run out of memory")
    public void oom() {
        SingleCommand.singleCommand(ArgsOutOfMemory.class).parse(new String[0]);
    }

    @Test
    public void getParametersShouldNotNpe() {
        SingleCommand.singleCommand(Args1.class).parse(new String[0]);
    }

    @DataProvider
    public Object[][] variable() {
        return new Object[][]{{0, V.subList(0, 0), V}, {1, V.subList(0, 1), V.subList(1, 4)}, {2, V.subList(0, 2), V.subList(2, 4)}, {3, V.subList(0, 3), V.subList(3, 4)}, {4, V.subList(0, 4), V.subList(4, 4)}};
    }

    @Test
    public void enumArgs() {
        ArgsEnum args = (ArgsEnum)SingleCommand.singleCommand(ArgsEnum.class).parse(new String[]{"-choice", "ONE"});
        Assert.assertEquals((Object)((Object)args.choice), (Object)((Object)ArgsEnum.ChoiceType.ONE));
    }

    @Test(expectedExceptions={ParseException.class})
    public void enumArgsFail() {
        SingleCommand.singleCommand(ArgsEnum.class).parse(new String[]{"A"});
    }

    @Test(expectedExceptions={ParseException.class})
    public void shouldThrowIfUnknownOption() {
        @Command(name="A")
        class A {
            @Option(name={"-long"})
            public long l;

            A() {
            }
        }
        SingleCommand.singleCommand(A.class).parse(new String[]{"32"});
    }

    @Test
    public void testSingleCommandHelpOption() {
        CommandTest commandTest = (CommandTest)SingleCommand.singleCommand(CommandTest.class).parse(new String[]{"-h", "-i", "foo"});
        Assert.assertTrue((boolean)commandTest.helpOption.showHelpIfRequested());
    }

    @Test(expectedExceptions={ParseOptionGroupException.class}, description="Verify that mutually exclusive options are found")
    public void testMutuallyExclusiveOptions() {
        SingleCommand.singleCommand(MutuallyExclusiveOptions.class).parse(new String[]{"-verbose", "-quiet"});
    }

    @Test(description="Verify that mutually exclusive options are present in the thrown ParseOptionGroupException")
    public void testMutuallyExclusiveOptionsAreDescribedInException() {
        try {
            SingleCommand command = SingleCommand.singleCommand(MutuallyExclusiveOptions.class);
            command.parse(new String[]{"-verbose", "-quiet"});
            Assert.assertFalse((boolean)true);
        }
        catch (ParseOptionGroupException expected) {
            String msg = expected.getMessage();
            Assert.assertTrue((boolean)msg.contains("Only one of the following options may be specified but 2 were found"));
            Assert.assertTrue((boolean)msg.contains("-all"));
            Assert.assertTrue((boolean)msg.contains("-quiet"));
            Assert.assertTrue((boolean)msg.contains("-verbose"));
            Assert.assertTrue((expected.getOptions().size() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((int)expected.getOptions().size(), (int)3);
        }
    }

    @Command(name="test", description="TestCommand")
    public static class CommandTest {
        @Inject
        public HelpOption<CommandTest> helpOption;
        @Arguments(description="Patterns of files to be added")
        public List<String> patterns;
        @Option(name={"-i"}, description="Interactive add mode")
        public Boolean interactive = false;
    }
}

