/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.args.overrides;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.TestingUtil;
import com.github.rvesse.airline.args.overrides.ArgsMergeAddition;
import com.github.rvesse.airline.args.overrides.ArgsMergeChangeRestrictions;
import com.github.rvesse.airline.args.overrides.ArgsMergeInheritRestrictions;
import com.github.rvesse.airline.args.overrides.ArgsMergeInvalidTypeChange;
import com.github.rvesse.airline.args.overrides.ArgsMergeNameChange;
import com.github.rvesse.airline.args.overrides.ArgsMergeNarrowingTypeChange;
import com.github.rvesse.airline.args.overrides.ArgsMergeOverride;
import com.github.rvesse.airline.args.overrides.ArgsMergeParent;
import com.github.rvesse.airline.args.overrides.ArgsMergeSealed;
import com.github.rvesse.airline.args.overrides.ArgsMergeSealedOverride;
import com.github.rvesse.airline.args.overrides.ArgsMergeTypeParent;
import com.github.rvesse.airline.args.overrides.ArgsMergeUndeclaredOverride;
import com.github.rvesse.airline.args.overrides.ArgsMergeWideningTypeChange;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOverrides {
    private OptionMetadata findByName(CommandMetadata metadata, String name) {
        for (OptionMetadata opData : metadata.getAllOptions()) {
            if (!opData.getOptions().contains(name)) continue;
            return opData;
        }
        return null;
    }

    @Test
    public void merging_additive() {
        SingleCommand<ArgsMergeAddition> parser = TestingUtil.singleCommandParser(ArgsMergeAddition.class);
        CommandMetadata metadata = parser.getCommandMetadata();
        OptionMetadata verboseOption = this.findByName(metadata, "-v");
        Assert.assertNotNull((Object)verboseOption);
        Assert.assertFalse((boolean)verboseOption.isHidden());
        OptionMetadata hiddenOption = this.findByName(metadata, "--hidden");
        Assert.assertNotNull((Object)hiddenOption);
        Assert.assertTrue((boolean)hiddenOption.isHidden());
        ArgumentsMetadata argsData = metadata.getArguments();
        Assert.assertNotNull((Object)argsData);
    }

    @Test
    public void merging_declared_override() {
        SingleCommand<ArgsMergeOverride> parser = TestingUtil.singleCommandParser(ArgsMergeOverride.class);
        CommandMetadata metadata = parser.getCommandMetadata();
        OptionMetadata verboseOption = this.findByName(metadata, "-v");
        Assert.assertNotNull((Object)verboseOption);
        Assert.assertFalse((boolean)verboseOption.isHidden());
        OptionMetadata hiddenOption = this.findByName(metadata, "--hidden");
        Assert.assertNotNull((Object)hiddenOption);
        Assert.assertTrue((boolean)hiddenOption.isOverride());
        Assert.assertFalse((boolean)hiddenOption.isHidden());
        Assert.assertFalse((boolean)hiddenOption.isSealed());
        ArgumentsMetadata argsData = metadata.getArguments();
        Assert.assertNotNull((Object)argsData);
        ArgsMergeOverride cmd = (ArgsMergeOverride)parser.parse(new String[]{"--hidden"});
        Assert.assertTrue((boolean)cmd.hidden);
        Assert.assertTrue((boolean)((ArgsMergeParent)cmd).hidden);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*must explicitly specify override.*")
    public void merging_undeclared_override() {
        SingleCommand<ArgsMergeUndeclaredOverride> parser = TestingUtil.singleCommandParser(ArgsMergeUndeclaredOverride.class);
        parser.getCommandMetadata();
    }

    @Test
    public void merging_sealed() {
        SingleCommand<ArgsMergeSealed> parser = TestingUtil.singleCommandParser(ArgsMergeSealed.class);
        CommandMetadata metadata = parser.getCommandMetadata();
        OptionMetadata verboseOption = this.findByName(metadata, "-v");
        Assert.assertNotNull((Object)verboseOption);
        Assert.assertFalse((boolean)verboseOption.isHidden());
        OptionMetadata hiddenOption = this.findByName(metadata, "--hidden");
        Assert.assertNotNull((Object)hiddenOption);
        Assert.assertTrue((boolean)hiddenOption.isOverride());
        Assert.assertFalse((boolean)hiddenOption.isHidden());
        Assert.assertTrue((boolean)hiddenOption.isSealed());
        ArgsMergeSealed cmd = (ArgsMergeSealed)parser.parse(new String[]{"--hidden"});
        Assert.assertTrue((boolean)cmd.hidden);
        Assert.assertTrue((boolean)((ArgsMergeParent)cmd).hidden);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*sealed.*")
    public void merging_sealed_override() {
        SingleCommand<ArgsMergeSealedOverride> parser = TestingUtil.singleCommandParser(ArgsMergeSealedOverride.class);
        parser.getCommandMetadata();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*overlapping.*")
    public void merging_overlapping_names() {
        SingleCommand<ArgsMergeNameChange> parser = TestingUtil.singleCommandParser(ArgsMergeNameChange.class);
        parser.getCommandMetadata();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Cannot change the Java type.*")
    public void merging_invalid_type_change() {
        SingleCommand<ArgsMergeInvalidTypeChange> parser = TestingUtil.singleCommandParser(ArgsMergeInvalidTypeChange.class);
        parser.getCommandMetadata();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp=".*widening type change.*")
    public void merging_widening_type_change() {
        SingleCommand<ArgsMergeWideningTypeChange> parser = TestingUtil.singleCommandParser(ArgsMergeWideningTypeChange.class);
        parser.getCommandMetadata();
    }

    @Test
    public void merging_narrowing_type_change() {
        SingleCommand<ArgsMergeNarrowingTypeChange> parser = TestingUtil.singleCommandParser(ArgsMergeNarrowingTypeChange.class);
        CommandMetadata metadata = parser.getCommandMetadata();
        OptionMetadata testOption = this.findByName(metadata, "--test");
        Assert.assertNotNull((Object)testOption);
        Assert.assertEquals((int)testOption.getArity(), (int)1);
        Assert.assertEquals((Object)testOption.getJavaType(), ArgsMergeTypeParent.C.class);
        ArgsMergeNarrowingTypeChange cmd = (ArgsMergeNarrowingTypeChange)parser.parse(new String[]{"--test", "12345"});
        Assert.assertEquals((long)cmd.test.value, (long)12345L);
        Assert.assertEquals((long)((ArgsMergeTypeParent)cmd).test.value, (long)12345L);
        Assert.assertEquals(cmd.test.getClass(), ArgsMergeTypeParent.C.class);
        Assert.assertEquals(((ArgsMergeTypeParent)cmd).test.getClass(), ArgsMergeTypeParent.C.class);
        Assert.assertTrue((boolean)cmd.test.getClass().equals(((ArgsMergeTypeParent)cmd).test.getClass()));
    }

    @Test
    public void merging_inherits_restrictions() {
        SingleCommand<ArgsMergeInheritRestrictions> parser = TestingUtil.singleCommandParser(ArgsMergeInheritRestrictions.class);
        CommandMetadata metadata = parser.getCommandMetadata();
        OptionMetadata testOption = this.findByName(metadata, "--required");
        Assert.assertNotNull((Object)testOption);
        Assert.assertTrue((boolean)testOption.isRequired());
    }

    @Test
    public void merging_inherits_changing_restrictions() {
        SingleCommand<ArgsMergeChangeRestrictions> parser = TestingUtil.singleCommandParser(ArgsMergeChangeRestrictions.class);
        CommandMetadata metadata = parser.getCommandMetadata();
        OptionMetadata testOption = this.findByName(metadata, "--required");
        Assert.assertNotNull((Object)testOption);
        Assert.assertFalse((boolean)testOption.isRequired());
    }
}

