/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.command;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.TestingUtil;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.command.CommandAdd;
import com.github.rvesse.airline.command.CommandCommit;
import com.github.rvesse.airline.command.CommandCommits;
import com.github.rvesse.airline.command.CommandHighArityOption;
import com.github.rvesse.airline.command.CommandRemote;
import com.github.rvesse.airline.command.CommandRemotes;
import com.github.rvesse.airline.command.CommandRemove;
import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.help.sections.common.DiscussionSection;
import com.github.rvesse.airline.help.sections.common.ExamplesSection;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.parser.errors.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCommand {
    @Test
    public void namedCommandTest1() {
        Cli parser = Cli.builder((String)"git").withCommand(CommandAdd.class).withCommand(CommandCommit.class).build();
        Object command = parser.parse(new String[]{"add", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandAdd));
        CommandAdd add = (CommandAdd)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals(add.patterns, Arrays.asList("A.java"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void shouldComplainIfNoAnnotations() {
        TestingUtil.singleCommandParser(String.class);
    }

    @Test
    public void commandTest2() {
        Cli parser = Cli.builder((String)"git").withCommand(CommandAdd.class).withCommand(CommandCommit.class).build();
        parser.parse(new String[]{"-v", "commit", "--amend", "--author", "cbeust", "A.java", "B.java"});
        Object command = parser.parse(new String[]{"-v", "commit", "--amend", "--author", "cbeust", "A.java", "B.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandCommit));
        CommandCommit commit = (CommandCommit)command;
        Assert.assertTrue((boolean)commit.commandMain.verbose);
        Assert.assertTrue((boolean)commit.amend);
        Assert.assertEquals((String)commit.author, (String)"cbeust");
        Assert.assertEquals(commit.files, Arrays.asList("A.java", "B.java"));
    }

    private HelpSection findHelpSection(Collection<HelpSection> sections, Class<? extends HelpSection> cls) {
        for (HelpSection section : sections) {
            if (!section.getClass().equals(cls)) continue;
            return section;
        }
        return null;
    }

    @Test
    public void testExample() {
        Cli parser = Cli.builder((String)"git").withCommand(CommandRemove.class).build();
        List commandParsers = parser.getMetadata().getDefaultGroupCommands();
        Assert.assertEquals((int)1, (int)commandParsers.size());
        CommandMetadata aMeta = (CommandMetadata)commandParsers.get(0);
        Assert.assertEquals((String)"remove", (String)aMeta.getName());
        HelpSection section = this.findHelpSection(aMeta.getHelpSections(), ExamplesSection.class);
        Assert.assertNotNull((Object)section);
        Assert.assertEquals((Object)section.getFormat(), (Object)HelpFormat.EXAMPLES);
        Assert.assertEquals((int)section.numContentBlocks(), (int)2);
        Assert.assertEquals((int)section.getContentBlock(0).length, (int)1);
        Assert.assertEquals((int)section.getContentBlock(1).length, (int)1);
        Assert.assertEquals((String)section.getContentBlock(0)[0], (String)"$ git remove -i myfile.java");
        Assert.assertEquals((String)section.getContentBlock(1)[0], (String)"This is a usage example");
    }

    @Test
    public void testDiscussion() {
        Cli parser = Cli.builder((String)"git").withCommand(CommandRemove.class).build();
        List commandParsers = parser.getMetadata().getDefaultGroupCommands();
        Assert.assertEquals((int)1, (int)commandParsers.size());
        CommandMetadata aMeta = (CommandMetadata)commandParsers.get(0);
        Assert.assertEquals((String)"remove", (String)aMeta.getName());
        HelpSection section = this.findHelpSection(aMeta.getHelpSections(), DiscussionSection.class);
        Assert.assertNotNull((Object)section);
        Assert.assertEquals((Object)section.getFormat(), (Object)HelpFormat.PROSE);
        Assert.assertEquals((int)section.numContentBlocks(), (int)1);
        Assert.assertEquals((int)section.getContentBlock(0).length, (int)1);
        Assert.assertEquals((String)section.getContentBlock(0)[0], (String)"More details about how this removes files from the index.");
    }

    @Test
    public void testDefaultCommandInGroup() {
        Cli parser = Cli.builder((String)"git").withCommand(CommandAdd.class).withCommand(CommandCommit.class).withDefaultCommand(CommandAdd.class).build();
        Object command = parser.parse(new String[]{"-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandAdd));
        CommandAdd add = (CommandAdd)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals(add.patterns, Arrays.asList("A.java"));
    }

    @Test
    public void testCommandWithArgsSeparator() {
        Cli parser = Cli.builder((String)"git").withCommand(CommandHighArityOption.class).build();
        Object command = parser.parse(new String[]{"-v", "cmd", "--option", "val1", "val2", "val3", "val4", "--", "arg1", "arg2", "arg3"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandHighArityOption));
        CommandHighArityOption cmdHighArity = (CommandHighArityOption)command;
        Assert.assertTrue((boolean)cmdHighArity.commandMain.verbose);
        Assert.assertEquals(cmdHighArity.option, Arrays.asList("val1", "val2", "val3", "val4"));
        Assert.assertEquals(cmdHighArity.args, Arrays.asList("arg1", "arg2", "arg3"));
    }

    @Test
    public void testCommandHighArityOptionNoSeparator() {
        Cli parser = Cli.builder((String)"git").withCommand(CommandHighArityOption.class).build();
        Object command = parser.parse(new String[]{"-v", "cmd", "--option", "val1", "val2", "val3", "val4", "--option2", "val5", "arg1", "arg2", "arg3"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandHighArityOption));
        CommandHighArityOption cmdHighArity = (CommandHighArityOption)command;
        Assert.assertTrue((boolean)cmdHighArity.commandMain.verbose);
        Assert.assertEquals(cmdHighArity.option, Arrays.asList("val1", "val2", "val3", "val4"));
        Assert.assertEquals((String)cmdHighArity.option2, (String)"val5");
        Assert.assertEquals(cmdHighArity.args, Arrays.asList("arg1", "arg2", "arg3"));
    }

    @Test
    public void abbreviatedCommands01() {
        CliBuilder builder = Cli.builder((String)"git").withCommand(CommandAdd.class).withCommand(CommandCommit.class).withDefaultCommand(CommandAdd.class);
        builder.withParser().withCommandAbbreviation();
        Cli parser = builder.build();
        Object command = parser.parse(new String[]{"ad", "-i", "A.java"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandAdd));
        CommandAdd add = (CommandAdd)command;
        Assert.assertEquals((boolean)add.interactive, (boolean)true);
        Assert.assertEquals(add.patterns, Arrays.asList("A.java"));
    }

    @Test(expectedExceptions={ParseException.class})
    public void abbreviatedCommands02() {
        CliBuilder builder = Cli.builder((String)"git").withCommand(CommandRemove.class).withCommand(CommandRemote.class);
        builder.withParser().withCommandAbbreviation();
        Cli parser = builder.build();
        parser.parse(new String[]{"rem"});
    }

    @Test
    public void abbreviatedCommands03() {
        CliBuilder builder = Cli.builder((String)"git").withCommand(CommandRemove.class).withCommand(CommandRemote.class);
        builder.withParser().withCommandAbbreviation();
        Cli parser = builder.build();
        Object command = parser.parse(new String[]{"remot"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandRemote));
    }

    @Test
    public void abbreviatedCommands04() {
        CliBuilder builder = Cli.builder((String)"git").withCommand(CommandRemove.class).withCommand(CommandRemote.class);
        builder.withParser().withCommandAbbreviation();
        Cli parser = builder.build();
        Object command = parser.parse(new String[]{"remov"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandRemove));
    }

    @Test
    public void abbreviatedCommands05() {
        CliBuilder builder = Cli.builder((String)"git").withCommand(CommandRemotes.class).withCommand(CommandRemote.class);
        builder.withParser().withCommandAbbreviation();
        Cli parser = builder.build();
        Object command = parser.parse(new String[]{"remote"});
        Assert.assertNotNull((Object)command, (String)"command is null");
        Assert.assertTrue((boolean)(command instanceof CommandRemote));
    }

    @Test
    public void abbreviatedOptions01() {
        CliBuilder builder = Cli.builder((String)"git").withCommand(CommandCommit.class);
        builder.withParser().withOptionAbbreviation();
        Cli parser = builder.build();
        Object command = parser.parse(new String[]{"commit", "--am"});
        Assert.assertNotNull((Object)command);
        Assert.assertTrue((boolean)(command instanceof CommandCommit));
        CommandCommit commit = (CommandCommit)command;
        Assert.assertTrue((boolean)commit.amend);
    }

    @Test
    public void abbreviatedOptions02() {
        CliBuilder builder = Cli.builder((String)"git").withCommand(CommandCommit.class);
        builder.withParser().withOptionAbbreviation();
        Cli parser = builder.build();
        Object command = parser.parse(new String[]{"commit", "--a"});
        Assert.assertTrue((boolean)(command instanceof CommandCommit));
        CommandCommit commit = (CommandCommit)command;
        Assert.assertFalse((boolean)commit.amend);
        Assert.assertNull((Object)commit.author);
        Assert.assertTrue((boolean)commit.files.contains("--a"));
    }

    @Test
    public void abbreviatedOptions03() {
        CliBuilder builder = Cli.builder((String)"git").withCommand(CommandCommits.class);
        builder.withParser().withOptionAbbreviation();
        Cli parser = builder.build();
        Object command = parser.parse(new String[]{"commits", "--author", "test"});
        Assert.assertNotNull((Object)command);
        Assert.assertTrue((boolean)(command instanceof CommandCommits));
        CommandCommits commit = (CommandCommits)command;
        Assert.assertEquals((String)commit.author, (String)"test");
    }

    @Test
    public void abbreviatedOptions04() {
        CliBuilder builder = Cli.builder((String)"git").withCommand(CommandCommits.class);
        builder.withParser().withOptionAbbreviation();
        Cli parser = builder.build();
        Object command = parser.parse(new String[]{"commits", "--author", "test"});
        Assert.assertNotNull((Object)command);
        Assert.assertTrue((boolean)(command instanceof CommandCommits));
        CommandCommits commit = (CommandCommits)command;
        Assert.assertEquals((String)commit.author, (String)"test");
    }

    @Test
    public void abbreviatedOptions05() {
        CliBuilder builder = Cli.builder((String)"git").withCommand(CommandCommits.class);
        builder.withParser().withOptionAbbreviation();
        Cli parser = builder.build();
        Object command = parser.parse(new String[]{"commits", "--authors", "test"});
        Assert.assertNotNull((Object)command);
        Assert.assertTrue((boolean)(command instanceof CommandCommits));
        CommandCommits commit = (CommandCommits)command;
        Assert.assertTrue((boolean)commit.authors.contains("test"));
    }
}

