/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.DefaultOption;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.parser.errors.ParseArgumentsUnexpectedException;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingValueException;
import com.github.rvesse.airline.parser.errors.ParseOptionUnexpectedException;
import com.github.rvesse.airline.parser.options.AbstractNameValueOptionParser;
import com.github.rvesse.airline.parser.options.ClassicGetOptParser;
import com.github.rvesse.airline.parser.options.GreedyMaybeListValueOptionParser;
import com.github.rvesse.airline.parser.options.ListValueOptionParser;
import com.github.rvesse.airline.parser.options.LongGetOptParser;
import com.github.rvesse.airline.parser.options.MaybeListValueOptionParser;
import com.github.rvesse.airline.parser.options.MaybePairValueOptionParser;
import com.github.rvesse.airline.parser.options.OptionParser;
import com.github.rvesse.airline.parser.options.StandardOptionParser;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOptionParsing {
    private <T> T testParsing(Cli<T> parser, String ... args) {
        return (T)parser.parse(args);
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void option_parsing_default_01() {
        Cli<OptionParsing> parser = this.createDefaultParser(OptionParsing.class);
        this.testParsing(parser, "OptionParsing1", "-c");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void option_parsing_default_02() {
        Cli<OptionParsing> parser = this.createDefaultParser(OptionParsing.class);
        this.testParsing(parser, "OptionParsing1", "-c", "one");
    }

    @Test
    public void option_parsing_default_03() {
        Cli<OptionParsing> parser = this.createDefaultParser(OptionParsing.class);
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
    }

    private final <T> Cli<T> createDefaultParser(Class<? extends T> cls) {
        CliBuilder builder = Cli.builder((String)"test").withCommand(cls);
        builder.withParser().withDefaultOptionParsers();
        return builder.build();
    }

    @Test
    public void option_parsing_standard_01() {
        Cli<OptionParsing> parser = this.createStandardParser(OptionParsing.class);
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-a", "--beta", "foo");
        Assert.assertTrue((boolean)cmd.alpha);
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void option_parsing_standard_02() {
        Cli<OptionParsing> parser = this.createStandardParser(OptionParsing.class);
        this.testParsing(parser, "OptionParsing1", "-a", "--beta");
    }

    private <T> Cli<T> createStandardParser(Class<? extends T> cls) {
        CliBuilder builder = Cli.builder((String)"test").withCommand(cls);
        builder.withParser().withOptionParser((OptionParser)new StandardOptionParser());
        return builder.build();
    }

    @Test
    public void option_parsing_classic_getopt_01() {
        Cli<OptionParsing> parser = this.createClassicGetOptParser(OptionParsing.class);
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-abfoo");
        Assert.assertTrue((boolean)cmd.alpha);
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_classic_getopt_02() {
        Cli<OptionParsing> parser = this.createClassicGetOptParser(OptionParsing.class);
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-bfooa");
        Assert.assertFalse((boolean)cmd.alpha);
        Assert.assertEquals((String)cmd.beta, (String)"fooa");
    }

    @Test
    public void option_parsing_classic_getopt_03() {
        Cli<OptionParsing> parser = this.createClassicGetOptParser(OptionParsing.class);
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-b", "foo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class})
    public void option_parsing_classic_getopt_04() {
        Cli<OptionParsing> parser = this.createClassicGetOptParser(OptionParsing.class);
        this.testParsing(parser, "OptionParsing1", "-ac");
    }

    @Test(expectedExceptions={ParseArgumentsUnexpectedException.class})
    public void option_parsing_classic_getopt_05() {
        Cli<OptionParsing> parser = this.createClassicGetOptParser(OptionParsing.class);
        this.testParsing(parser, "OptionParsing1", "-c");
    }

    private <T> Cli<T> createClassicGetOptParser(Class<? extends T> cls) {
        CliBuilder builder = Cli.builder((String)"test").withCommand(cls);
        builder.withParser().withOptionParser((OptionParser)new ClassicGetOptParser());
        return builder.build();
    }

    @Test
    public void option_parsing_long_getopt_01() {
        Cli<OptionParsing> parser = this.createLongGetOptParser(OptionParsing.class);
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-b=foo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_long_getopt_02() {
        Cli<OptionParsing> parser = this.createLongGetOptParser(OptionParsing.class);
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "--beta=foo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test(expectedExceptions={ParseArgumentsUnexpectedException.class})
    public void option_parsing_long_getopt_03() {
        Cli<OptionParsing> parser = this.createLongGetOptParser(OptionParsing.class);
        this.testParsing(parser, "OptionParsing1", "--beta", "foo");
    }

    @Test(expectedExceptions={ParseArgumentsUnexpectedException.class})
    public void option_parsing_long_getopt_04() {
        Cli<OptionParsing> parser = this.createLongGetOptParser(OptionParsing.class);
        this.testParsing(parser, "OptionParsing1", "--charlie=foo");
    }

    private <T> Cli<T> createLongGetOptParser(Class<? extends T> cls) {
        CliBuilder builder = Cli.builder((String)"test").withCommand(cls);
        builder.withParser().withOptionParser((OptionParser)new LongGetOptParser());
        return builder.build();
    }

    @Test
    public void option_parsing_key_value_01() {
        Cli<OptionParsing> parser = this.createKeyValueParser(OptionParsing.class, ':');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-b:foo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_key_value_02() {
        Cli<OptionParsing> parser = this.createKeyValueParser(OptionParsing.class, ':');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "--beta:foo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_key_value_03() {
        Cli<OptionParsing> parser = this.createKeyValueParser(OptionParsing.class, ';');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-b;foo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_key_value_04() {
        Cli<OptionParsing> parser = this.createKeyValueParser(OptionParsing.class, ';');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "--beta;foo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test(expectedExceptions={ParseArgumentsUnexpectedException.class})
    public void option_parsing_key_value_05() {
        Cli<OptionParsing> parser = this.createKeyValueParser(OptionParsing.class, ':');
        this.testParsing(parser, "OptionParsing1", "--beta", "foo");
    }

    private <T> Cli<T> createKeyValueParser(Class<? extends T> cls, char separator) {
        CliBuilder builder = Cli.builder((String)"test").withCommand(cls);
        builder.withParser().withOptionParser(new KeyValueOptionParser(separator));
        return builder.build();
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class}, expectedExceptionsMessageRegExp="Required values.*")
    public void option_parsing_list_value_bad_01() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class}, expectedExceptionsMessageRegExp="Too few.*")
    public void option_parsing_list_value_bad_02() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_list_value_bad_03() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one,two,three");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class}, expectedExceptionsMessageRegExp="Too few.*")
    public void option_parsing_list_value_bad_04() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-cone");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_list_value_bad_05() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-cone,two,three");
    }

    @Test
    public void option_parsing_list_value_01() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-b", "foo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_list_value_02() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-bfoo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_list_value_03() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one,two");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
    }

    @Test
    public void option_parsing_list_value_04() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-cone,two");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
    }

    @Test
    public void option_parsing_list_value_05() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-b", "foo,bar");
        Assert.assertEquals((String)cmd.beta, (String)"bar");
    }

    @Test
    public void option_parsing_list_value_06() {
        Cli<OptionParsing> parser = this.createListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-cone,two,three,four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
        Assert.assertEquals((String)cmd.charlie.get(2), (String)"three");
        Assert.assertEquals((String)cmd.charlie.get(3), (String)"four");
    }

    private <T> Cli<T> createListValueParser(Class<? extends T> cls, char listSeparator) {
        CliBuilder builder = Cli.builder((String)"test").withCommand(cls);
        builder.withParser().withOptionParser((OptionParser)new ListValueOptionParser(listSeparator));
        return builder.build();
    }

    private <T> Cli<T> createMaybeListValueParser(Class<? extends T> cls, char listSeparator) {
        CliBuilder builder = Cli.builder((String)"test").withCommand(cls);
        builder.withParser().withOptionParser((OptionParser)new MaybeListValueOptionParser(listSeparator));
        return builder.build();
    }

    private <T> Cli<T> createGreedyMaybeListValueParser(Class<? extends T> cls, char listSeparator) {
        CliBuilder builder = Cli.builder((String)"test").withCommand(cls);
        builder.withParser().withOptionParser((OptionParser)new GreedyMaybeListValueOptionParser(listSeparator));
        return builder.build();
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class}, expectedExceptionsMessageRegExp="Required values.*")
    public void option_parsing_maybe_list_value_bad_01() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class}, expectedExceptionsMessageRegExp="Too few.*")
    public void option_parsing_maybe_list_value_bad_02() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_maybe_list_value_bad_03() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one,two,three");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class}, expectedExceptionsMessageRegExp="Too few.*")
    public void option_parsing_maybe_list_value_bad_04() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-cone");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_maybe_list_value_bad_05() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-cone,two,three");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_maybe_list_value_bad_06() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "three");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_maybe_list_value_bad_07() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "three", "-a");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_maybe_list_value_bad_08() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "three", "-afoo");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_maybe_list_value_bad_09() {
        Cli<OptionAndArgumentParsing> parser = this.createMaybeListValueParser(OptionAndArgumentParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one", "two,three", "--", "foo");
    }

    @Test
    public void option_parsing_maybe_list_value_01() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-b", "foo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_maybe_list_value_02() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-bfoo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_maybe_list_value_03() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one,two");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
    }

    @Test
    public void option_parsing_maybe_list_value_04() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-cone,two");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
    }

    @Test
    public void option_parsing_maybe_list_value_05() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-b", "foo,bar");
        Assert.assertEquals((String)cmd.beta, (String)"bar");
    }

    @Test
    public void option_parsing_maybe_list_value_06() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-cone,two,three,four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
        Assert.assertEquals((String)cmd.charlie.get(2), (String)"three");
        Assert.assertEquals((String)cmd.charlie.get(3), (String)"four");
    }

    @Test
    public void option_parsing_maybe_list_value_07() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-cone", "two", "three,four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
        Assert.assertEquals((String)cmd.charlie.get(2), (String)"three");
        Assert.assertEquals((String)cmd.charlie.get(3), (String)"four");
    }

    @Test
    public void option_parsing_maybe_list_value_08() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one,two", "three,four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
        Assert.assertEquals((String)cmd.charlie.get(2), (String)"three");
        Assert.assertEquals((String)cmd.charlie.get(3), (String)"four");
    }

    @Test
    public void option_parsing_maybe_list_value_09() {
        Cli<OptionParsing> parser = this.createMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one,two", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
        Assert.assertEquals((String)cmd.charlie.get(2), (String)"three");
        Assert.assertEquals((String)cmd.charlie.get(3), (String)"four");
    }

    @Test
    public void option_parsing_maybe_list_value_10() {
        Cli<OptionAndArgumentParsing> parser = this.createMaybeListValueParser(OptionAndArgumentParsing.class, ',');
        OptionAndArgumentParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one,two", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((int)cmd.args.size(), (int)2);
        Assert.assertEquals((String)cmd.args.get(0), (String)"three");
        Assert.assertEquals((String)cmd.args.get(1), (String)"four");
    }

    @Test
    public void option_parsing_maybe_list_value_11() {
        Cli<OptionAndArgumentParsing> parser = this.createMaybeListValueParser(OptionAndArgumentParsing.class, ',');
        OptionAndArgumentParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two,three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((String)((String)cmd.charlie.get(2)), (String)"three");
        Assert.assertEquals((String)((String)cmd.charlie.get(3)), (String)"four");
    }

    @Test
    public void option_parsing_maybe_list_value_12() {
        Cli<OptionAndArgumentParsing> parser = this.createMaybeListValueParser(OptionAndArgumentParsing.class, ',');
        OptionAndArgumentParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((int)cmd.args.size(), (int)2);
        Assert.assertEquals((String)cmd.args.get(0), (String)"three");
        Assert.assertEquals((String)cmd.args.get(1), (String)"four");
    }

    @Test
    public void option_parsing_maybe_list_value_13() {
        Cli<OptionAndArgumentParsing> parser = this.createMaybeListValueParser(OptionAndArgumentParsing.class, ',');
        OptionAndArgumentParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "--", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((int)cmd.args.size(), (int)2);
        Assert.assertEquals((String)cmd.args.get(0), (String)"three");
        Assert.assertEquals((String)cmd.args.get(1), (String)"four");
    }

    @Test
    public void option_parsing_maybe_list_value_14() {
        Cli<OptionAndDefaultParsing> parser = this.createMaybeListValueParser(OptionAndDefaultParsing.class, ',');
        OptionAndDefaultParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((String)cmd.delta, (String)"four");
    }

    @Test
    public void option_parsing_maybe_list_value_15() {
        Cli<OptionAndDefaultParsing> parser = this.createMaybeListValueParser(OptionAndDefaultParsing.class, ',');
        OptionAndDefaultParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "-b", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((String)cmd.beta, (String)"three");
        Assert.assertEquals((String)cmd.delta, (String)"four");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class}, expectedExceptionsMessageRegExp="Required values.*")
    public void option_parsing_greedy_maybe_list_value_bad_01() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class}, expectedExceptionsMessageRegExp="Too few.*")
    public void option_parsing_greedy_maybe_list_value_bad_02() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_greedy_maybe_list_value_bad_03() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one,two,three");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class}, expectedExceptionsMessageRegExp="Too few.*")
    public void option_parsing_greedy_maybe_list_value_bad_04() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-cone");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_greedy_maybe_list_value_bad_05() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-cone,two,three");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_greedy_maybe_list_value_bad_06() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "three");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_greedy_maybe_list_value_bad_07() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "three", "-a");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_greedy_maybe_list_value_bad_08() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "three", "-afoo");
    }

    @Test(expectedExceptions={ParseOptionUnexpectedException.class}, expectedExceptionsMessageRegExp="Too many.*")
    public void option_parsing_greedy_maybe_list_value_bad_09() {
        Cli<OptionAndArgumentParsing> parser = this.createGreedyMaybeListValueParser(OptionAndArgumentParsing.class, ',');
        this.testParsing(parser, "OptionParsing1", "-c", "one", "two,three", "--", "foo");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_01() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-b", "foo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_02() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-bfoo");
        Assert.assertEquals((String)cmd.beta, (String)"foo");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_03() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one,two");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_04() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-cone,two");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_05() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-b", "foo,bar");
        Assert.assertEquals((String)cmd.beta, (String)"bar");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_06() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-cone,two,three,four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
        Assert.assertEquals((String)cmd.charlie.get(2), (String)"three");
        Assert.assertEquals((String)cmd.charlie.get(3), (String)"four");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_07() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-cone", "two", "three,four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
        Assert.assertEquals((String)cmd.charlie.get(2), (String)"three");
        Assert.assertEquals((String)cmd.charlie.get(3), (String)"four");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_08() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one,two", "three,four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
        Assert.assertEquals((String)cmd.charlie.get(2), (String)"three");
        Assert.assertEquals((String)cmd.charlie.get(3), (String)"four");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_09() {
        Cli<OptionParsing> parser = this.createGreedyMaybeListValueParser(OptionParsing.class, ',');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one,two", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"one");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"two");
        Assert.assertEquals((String)cmd.charlie.get(2), (String)"three");
        Assert.assertEquals((String)cmd.charlie.get(3), (String)"four");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_10() {
        Cli<OptionAndArgumentParsing> parser = this.createGreedyMaybeListValueParser(OptionAndArgumentParsing.class, ',');
        OptionAndArgumentParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one,two", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((String)((String)cmd.charlie.get(2)), (String)"three");
        Assert.assertEquals((String)((String)cmd.charlie.get(3)), (String)"four");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_11() {
        Cli<OptionAndArgumentParsing> parser = this.createGreedyMaybeListValueParser(OptionAndArgumentParsing.class, ',');
        OptionAndArgumentParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two,three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((String)((String)cmd.charlie.get(2)), (String)"three");
        Assert.assertEquals((String)((String)cmd.charlie.get(3)), (String)"four");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_12() {
        Cli<OptionAndArgumentParsing> parser = this.createGreedyMaybeListValueParser(OptionAndArgumentParsing.class, ',');
        OptionAndArgumentParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((String)((String)cmd.charlie.get(2)), (String)"three");
        Assert.assertEquals((String)((String)cmd.charlie.get(3)), (String)"four");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_13() {
        Cli<OptionAndArgumentParsing> parser = this.createGreedyMaybeListValueParser(OptionAndArgumentParsing.class, ',');
        OptionAndArgumentParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "--", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((int)cmd.args.size(), (int)2);
        Assert.assertEquals((String)cmd.args.get(0), (String)"three");
        Assert.assertEquals((String)cmd.args.get(1), (String)"four");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_14() {
        Cli<OptionAndDefaultParsing> parser = this.createGreedyMaybeListValueParser(OptionAndDefaultParsing.class, ',');
        OptionAndDefaultParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)4);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((String)((String)cmd.charlie.get(2)), (String)"three");
        Assert.assertEquals((String)((String)cmd.charlie.get(3)), (String)"four");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_15() {
        Cli<OptionAndDefaultParsing> parser = this.createGreedyMaybeListValueParser(OptionAndDefaultParsing.class, ',');
        OptionAndDefaultParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "-b", "three", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((String)cmd.beta, (String)"four");
    }

    @Test
    public void option_parsing_greedy_maybe_list_value_16() {
        Cli<OptionAndDefaultParsing> parser = this.createGreedyMaybeListValueParser(OptionAndDefaultParsing.class, ',');
        OptionAndDefaultParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "one", "two", "-b", "three", "-d", "four");
        Assert.assertEquals((int)cmd.charlie.size(), (int)2);
        Assert.assertEquals((String)((String)cmd.charlie.get(0)), (String)"one");
        Assert.assertEquals((String)((String)cmd.charlie.get(1)), (String)"two");
        Assert.assertEquals((String)cmd.beta, (String)"three");
        Assert.assertEquals((String)cmd.delta, (String)"four");
    }

    @Test
    public void option_parsing_maybe_pair_value_01() {
        Cli<OptionParsing> parser = this.createMaybePairValueParser(OptionParsing.class, '=');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "foo", "bar");
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"foo");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"bar");
    }

    @Test
    public void option_parsing_maybe_pair_value_02() {
        Cli<OptionParsing> parser = this.createMaybePairValueParser(OptionParsing.class, '=');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-c", "foo=bar");
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"foo");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"bar");
    }

    @Test
    public void option_parsing_maybe_pair_value_03() {
        Cli<OptionParsing> parser = this.createMaybePairValueParser(OptionParsing.class, '=');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-cfoo", "bar");
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"foo");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"bar");
    }

    @Test
    public void option_parsing_maybe_pair_value_04() {
        Cli<OptionParsing> parser = this.createMaybePairValueParser(OptionParsing.class, '=');
        OptionParsing cmd = this.testParsing(parser, "OptionParsing1", "-cfoo=bar");
        Assert.assertEquals((String)cmd.charlie.get(0), (String)"foo");
        Assert.assertEquals((String)cmd.charlie.get(1), (String)"bar");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void option_parsing_maybe_pair_value_bad_01() {
        Cli<OptionParsing> parser = this.createMaybePairValueParser(OptionParsing.class, '=');
        this.testParsing(parser, "OptionParsing1", "-c", "foo");
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void option_parsing_maybe_pair_value_bad_02() {
        Cli<OptionParsing> parser = this.createMaybePairValueParser(OptionParsing.class, '=');
        this.testParsing(parser, "OptionParsing1", "-cfoo");
    }

    private <T> Cli<T> createMaybePairValueParser(Class<? extends T> cls, char pairSeparator) {
        CliBuilder builder = Cli.builder((String)"test").withCommand(cls);
        builder.withParser().withOptionParser((OptionParser)new MaybePairValueOptionParser(pairSeparator));
        return builder.build();
    }

    public static class KeyValueOptionParser<T>
    extends AbstractNameValueOptionParser<T> {
        public KeyValueOptionParser(char separator) {
            super(separator);
        }
    }

    @Command(name="OptionParsing1")
    public static class OptionAndDefaultParsing
    extends OptionParsing {
        @Option(name={"-d", "--delta"}, arity=1)
        @DefaultOption
        String delta;
    }

    @Command(name="OptionParsing1")
    public static class OptionAndArgumentParsing
    extends OptionParsing {
        @Arguments
        List<String> args;
    }

    @Command(name="OptionParsing1")
    public static class OptionParsing {
        @Option(name={"-a", "--alpha"})
        boolean alpha;
        @Option(name={"-b", "--beta"}, arity=1)
        String beta;
        @Option(name={"-c", "--charlie"}, arity=2)
        List<String> charlie = new ArrayList<String>();
    }
}

