/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.aliases;

import com.github.rvesse.airline.parser.aliases.AliasArgumentsParser;
import com.github.rvesse.airline.parser.errors.ParseException;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAliasArgumentsParser {
    private static List<String> parse(String value) {
        return AliasArgumentsParser.parse((String)value);
    }

    @Test
    public void alias_arguments_01() {
        List<String> args = TestAliasArgumentsParser.parse("foo bar");
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)args.get(0), (String)"foo");
        Assert.assertEquals((String)args.get(1), (String)"bar");
    }

    @Test
    public void alias_arguments_02() {
        List<String> args = TestAliasArgumentsParser.parse("\"foo\" bar");
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)args.get(0), (String)"foo");
        Assert.assertEquals((String)args.get(1), (String)"bar");
    }

    @Test
    public void alias_arguments_03() {
        List<String> args = TestAliasArgumentsParser.parse("foo \"bar\"");
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)args.get(0), (String)"foo");
        Assert.assertEquals((String)args.get(1), (String)"bar");
    }

    @Test
    public void alias_arguments_04() {
        List<String> args = TestAliasArgumentsParser.parse("\"foo\" \"bar\"");
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)args.get(0), (String)"foo");
        Assert.assertEquals((String)args.get(1), (String)"bar");
    }

    @Test
    public void alias_arguments_whitespace_escapes_01() {
        List<String> args = TestAliasArgumentsParser.parse("foo\\ bar");
        Assert.assertEquals((int)args.size(), (int)1);
        Assert.assertEquals((String)args.get(0), (String)"foo bar");
    }

    @Test
    public void alias_arguments_whitespace_escapes_02() {
        List<String> args = TestAliasArgumentsParser.parse("foo\\ \\ \\ bar");
        Assert.assertEquals((int)args.size(), (int)1);
        Assert.assertEquals((String)args.get(0), (String)"foo   bar");
    }

    @Test
    public void alias_arguments_whitespace_escapes_03() {
        List<String> args = TestAliasArgumentsParser.parse("foo bar\\");
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)args.get(0), (String)"foo");
        Assert.assertEquals((String)args.get(1), (String)"bar\\");
    }

    @Test
    public void alias_arguments_whitespace_escapes_04() {
        List<String> args = TestAliasArgumentsParser.parse("foo bar\\ ");
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)args.get(0), (String)"foo");
        Assert.assertEquals((String)args.get(1), (String)"bar ");
    }

    @Test
    public void alias_arguments_quote_escapes_01() {
        List<String> args = TestAliasArgumentsParser.parse("\"foo\\\" bar\"");
        Assert.assertEquals((int)args.size(), (int)1);
        Assert.assertEquals((String)args.get(0), (String)"foo\" bar");
    }

    @Test
    public void alias_arguments_quote_escapes_02() {
        List<String> args = TestAliasArgumentsParser.parse("\"foo\\\"\\\"bar\"");
        Assert.assertEquals((int)args.size(), (int)1);
        Assert.assertEquals((String)args.get(0), (String)"foo\"\"bar");
    }

    @Test(expectedExceptions={ParseException.class})
    public void alias_arguments_bad_01() {
        TestAliasArgumentsParser.parse("\"foo bar");
    }
}

