/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.errors.handlers;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.args.ArgsRequired;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.github.rvesse.airline.parser.errors.handlers.CollectAll;
import com.github.rvesse.airline.parser.errors.handlers.FailAll;
import com.github.rvesse.airline.parser.errors.handlers.FailFast;
import com.github.rvesse.airline.parser.errors.handlers.ParserErrorHandler;
import com.github.rvesse.airline.restrictions.Some;
import com.github.rvesse.airline.restrictions.Strings;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestErrorHandlers {
    private <T> ParserMetadata<T> prepareParser(ParserErrorHandler handler) {
        return new ParserBuilder().withErrorHandler(handler).build();
    }

    @Test(expectedExceptions={ParseException.class})
    public void errorHandlerFailFast() {
        SingleCommand.singleCommand(ArgsRequired.class, this.prepareParser((ParserErrorHandler)new FailFast())).parse(new String[0]);
    }

    @Test
    public void errorHandlerCollectAll() {
        ParseResult result = SingleCommand.singleCommand(ArgsRequired.class, this.prepareParser((ParserErrorHandler)new CollectAll())).parseWithResult(new String[0]);
        Assert.assertFalse((boolean)result.wasSuccessful());
        Assert.assertEquals((int)result.getErrors().size(), (int)1);
        Assert.assertNotNull((Object)result.getCommand());
    }

    @Test
    public void errorHandlerCollectAllDuplicates() {
        ParseResult result = SingleCommand.singleCommand(Some.class, this.prepareParser((ParserErrorHandler)new CollectAll())).parseWithResult(new String[0]);
        Assert.assertFalse((boolean)result.wasSuccessful());
        Assert.assertEquals((int)result.getErrors().size(), (int)1);
        Assert.assertNotNull((Object)result.getCommand());
        Throwable e = (Throwable)result.getErrors().iterator().next();
        Assert.assertEquals((int)e.getSuppressed().length, (int)2);
    }

    @Test
    public void errorHandlerFailAll() {
        try {
            SingleCommand.singleCommand(Strings.class, this.prepareParser((ParserErrorHandler)new FailAll())).parseWithResult(new String[]{"--not-empty", "", "--not-blank", "  "});
        }
        catch (ParseException e) {
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
        }
    }

    @Test
    public void errorHandlerCollectAllHelp01() {
        ParseResult result = SingleCommand.singleCommand(Strings.class, this.prepareParser((ParserErrorHandler)new CollectAll())).parseWithResult(new String[]{"--not-empty", "", "--not-blank", "  "});
        Assert.assertFalse((boolean)result.wasSuccessful());
        Assert.assertEquals((int)result.getErrors().size(), (int)2);
        Assert.assertNotNull((Object)result.getCommand());
        Strings cmd = (Strings)result.getCommand();
        Assert.assertTrue((boolean)cmd.helpOption.showHelpIfErrors(result));
    }

    @Test
    public void errorHandlerCollectAllHelp02() {
        ParseResult result = SingleCommand.singleCommand(Strings.class, this.prepareParser((ParserErrorHandler)new CollectAll())).parseWithResult(new String[]{"--not-empty", "foo", "--not-blank", "non-blank"});
        Assert.assertTrue((boolean)result.wasSuccessful());
        Assert.assertEquals((int)result.getErrors().size(), (int)0);
        Assert.assertNotNull((Object)result.getCommand());
        Strings cmd = (Strings)result.getCommand();
        Assert.assertFalse((boolean)cmd.helpOption.showHelpIfErrors(result));
    }
}

