/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions;

import com.github.rvesse.airline.HelpOption;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.annotations.restrictions.EndsWith;
import com.github.rvesse.airline.annotations.restrictions.ExactLength;
import com.github.rvesse.airline.annotations.restrictions.MaxLength;
import com.github.rvesse.airline.annotations.restrictions.MinLength;
import com.github.rvesse.airline.annotations.restrictions.NoOptionLikeValues;
import com.github.rvesse.airline.annotations.restrictions.NotBlank;
import com.github.rvesse.airline.annotations.restrictions.NotEmpty;
import com.github.rvesse.airline.annotations.restrictions.Pattern;
import com.github.rvesse.airline.annotations.restrictions.StartsWith;
import com.github.rvesse.airline.annotations.restrictions.ranges.LengthRange;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

@Command(name="strings")
public class Strings {
    @Option(name={"--not-empty"})
    @NotEmpty
    public String notEmpty;
    @Option(name={"--not-blank"})
    @NotBlank
    public String notBlank;
    @Option(name={"--min"})
    @MinLength(length=4)
    public String minLength;
    @Option(name={"--max"})
    @MaxLength(length=4)
    public String maxLength;
    @Option(name={"--tel"})
    @Pattern(pattern="(\\+1-)?\\d{3}-\\d{3}-\\d{4}", description="Must provide a telephone number in standard US format e.g. +1-800-123-4567")
    public String tel;
    @Option(name={"--other"})
    @Pattern(pattern="foo|bar|foobar", flags=2)
    public String other;
    @Option(name={"--exact"})
    @ExactLength(length=5)
    public String exact;
    @Option(name={"--range"})
    @LengthRange(min=4, max=6)
    public String range;
    @Option(name={"--range-exact"})
    @LengthRange(min=4, max=4)
    public String rangeExact;
    @Option(name={"--images"})
    @EndsWith(suffixes={".jpg", ".png", ".gif"})
    public List<String> images = new ArrayList<String>();
    @Option(name={"--images-ci"})
    @EndsWith(ignoreCase=true, suffixes={".jpg", ".png", ".gif"})
    public List<String> imagesCaseInsensitive = new ArrayList<String>();
    @Option(name={"--urls"})
    @StartsWith(prefixes={"http", "https", "ftp"})
    public List<String> urls = new ArrayList<String>();
    @Option(name={"--urls-ci"})
    @StartsWith(ignoreCase=true, prefixes={"http", "https", "ftp"})
    public List<String> urlsCaseInsensitive = new ArrayList<String>();
    @Option(name={"--not-option-like"})
    @NoOptionLikeValues
    public List<String> notOptionLike = new ArrayList<String>();
    @Option(name={"--not-option-like-long"})
    @NoOptionLikeValues(optionPrefixes={"--"})
    public List<String> notOptionLikeLong = new ArrayList<String>();
    @Arguments
    @NoOptionLikeValues
    public List<String> args = new ArrayList<String>();
    @Inject
    public HelpOption<Strings> helpOption = new HelpOption();
}

