/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.parser.errors.ParseOptionIllegalValueException;
import com.github.rvesse.airline.restrictions.Allowable;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAllowedValues {
    @Test
    public void allowed_raw_01() {
        String[] allowed = new String[]{"foo", "bar", "faz"};
        SingleCommand parser = SingleCommand.singleCommand(Allowable.class);
        for (String value : allowed) {
            Allowable cmd = (Allowable)parser.parse(new String[]{"--raw", value});
            Assert.assertEquals((String)cmd.raw, (String)value);
        }
    }

    @Test(expectedExceptions={ParseOptionIllegalValueException.class})
    public void allowed_raw_02() {
        SingleCommand parser = SingleCommand.singleCommand(Allowable.class);
        parser.parse(new String[]{"--raw", "other"});
    }

    @Test
    public void allowed_raw_03() {
        String[] allowed = new String[]{"foo", "bar", "faz"};
        SingleCommand parser = SingleCommand.singleCommand(Allowable.class);
        for (String value : allowed) {
            try {
                parser.parse(new String[]{"--raw", value.toUpperCase(Locale.ROOT)});
                Assert.fail((String)"Expected values to be case sensitive");
            }
            catch (ParseOptionIllegalValueException parseOptionIllegalValueException) {
                // empty catch block
            }
        }
    }

    @Test
    public void allowed_raw_04() {
        String[] allowed = new String[]{"upper", "LOWER", "mIXEDcASE", "UPPER", "UPPer", "loweR", "mIXeDcAsE"};
        SingleCommand parser = SingleCommand.singleCommand(Allowable.class);
        for (String value : allowed) {
            Allowable cmd = (Allowable)parser.parse(new String[]{"--case", value});
            Assert.assertEquals((String)cmd.caseInsensitive, (String)value);
        }
    }

    @Test
    public void allowed_typed_01() {
        String[] allowed = new String[]{"1", "2.0", "0.3E1"};
        SingleCommand parser = SingleCommand.singleCommand(Allowable.class);
        for (String value : allowed) {
            Allowable cmd = (Allowable)parser.parse(new String[]{"--typed", value});
            Assert.assertEquals((Object)cmd.typed, (Object)Double.parseDouble(value));
        }
    }

    @Test
    public void allowed_enum_01() {
        SingleCommand parser = SingleCommand.singleCommand(Allowable.class);
        for (TimeUnit unit : TimeUnit.values()) {
            Allowable cmd = (Allowable)parser.parse(new String[]{"--enum", unit.name()});
            Assert.assertEquals((Object)((Object)cmd.enumTyped), (Object)((Object)unit));
        }
    }
}

