/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.Paths;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPathRestriction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void path_restriction_must_exist_01() throws IOException {
        File f = new File("target/paths.txt");
        try {
            try (FileWriter writer = new FileWriter(f);){
                writer.append("test");
                writer.close();
            }
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            Paths cmd = (Paths)parser.parse(new String[]{"--path", f.getPath()});
            Assert.assertEquals((String)cmd.pathMustExist, (String)f.getPath());
            cmd = (Paths)parser.parse(new String[]{"--file", f.getPath()});
            Assert.assertEquals((String)cmd.fileMustExit, (String)f.getPath());
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void path_restriction_must_exist_02() throws IOException {
        File f = new File("target/paths.txt");
        try {
            try (FileWriter writer = new FileWriter(f);){
                writer.append("test");
                writer.close();
            }
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            parser.parse(new String[]{"--directory", f.getPath()});
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void path_restriction_must_exist_03() throws IOException {
        File f = new File("target/paths.txt");
        SingleCommand parser = SingleCommand.singleCommand(Paths.class);
        parser.parse(new String[]{"--path", f.getPath()});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void path_restriction_must_exist_04() throws IOException {
        File f = new File("target/paths.txt");
        SingleCommand parser = SingleCommand.singleCommand(Paths.class);
        parser.parse(new String[]{"--file", f.getPath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void path_restriction_readable_01() throws IOException {
        File f = new File("target/paths.txt");
        try {
            try (FileWriter writer = new FileWriter(f);){
                writer.append("test");
                writer.close();
            }
            f.setReadable(true);
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            Paths cmd = (Paths)parser.parse(new String[]{"--readable", f.getPath()});
            Assert.assertEquals((String)cmd.readable, (String)f.getPath());
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void path_restriction_readable_02() throws IOException {
        File f = new File("target/paths.txt");
        try {
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            Assert.assertFalse((boolean)f.exists());
            Paths cmd = (Paths)parser.parse(new String[]{"--readable", f.getPath()});
            Assert.assertEquals((String)cmd.readable, (String)f.getPath());
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void path_restriction_readable_03() throws IOException {
        File f = new File("target/paths.txt");
        try {
            try (FileWriter writer = new FileWriter(f);){
                writer.append("test");
                writer.close();
            }
            f.setReadable(false);
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            parser.parse(new String[]{"--readable", f.getPath()});
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void path_restriction_writable_01() throws IOException {
        File f = new File("target/paths.txt");
        try {
            try (FileWriter writer = new FileWriter(f);){
                writer.append("test");
                writer.close();
            }
            f.setWritable(true);
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            Paths cmd = (Paths)parser.parse(new String[]{"--writable", f.getPath()});
            Assert.assertEquals((String)cmd.writable, (String)f.getPath());
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void path_restriction_writable_02() throws IOException {
        File f = new File("target/paths.txt");
        try {
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            Assert.assertFalse((boolean)f.exists());
            Paths cmd = (Paths)parser.parse(new String[]{"--writable", f.getPath()});
            Assert.assertEquals((String)cmd.writable, (String)f.getPath());
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void path_restriction_writeable_03() throws IOException {
        File f = new File("target/paths.txt");
        try {
            try (FileWriter writer = new FileWriter(f);){
                writer.append("test");
                writer.close();
            }
            f.setWritable(false);
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            parser.parse(new String[]{"--writable", f.getPath()});
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void path_restriction_executable_01() throws IOException {
        File f = new File("target/paths.txt");
        try {
            try (FileWriter writer = new FileWriter(f);){
                writer.append("test");
                writer.close();
            }
            f.setExecutable(true);
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            Paths cmd = (Paths)parser.parse(new String[]{"--executable", f.getPath()});
            Assert.assertEquals((String)cmd.executable, (String)f.getPath());
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void path_restriction_executable_02() throws IOException {
        File f = new File("target/paths.txt");
        try {
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            Assert.assertFalse((boolean)f.exists());
            Paths cmd = (Paths)parser.parse(new String[]{"--executable", f.getPath()});
            Assert.assertEquals((String)cmd.executable, (String)f.getPath());
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void path_restriction_executable_03() throws IOException {
        File f = new File("target/paths.txt");
        try {
            try (FileWriter writer = new FileWriter(f);){
                writer.append("test");
                writer.close();
            }
            f.setExecutable(false);
            SingleCommand parser = SingleCommand.singleCommand(Paths.class);
            parser.parse(new String[]{"--executable", f.getPath()});
        }
        finally {
            if (f.exists()) {
                f.delete();
            }
        }
    }

    @Test
    public void path_restriction_help() throws IOException {
        SingleCommand parser = SingleCommand.singleCommand(Paths.class);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Help.help((CommandMetadata)parser.getCommandMetadata(), (OutputStream)output);
        String usage = new String(output.toByteArray(), StandardCharsets.UTF_8);
        usage = usage.replace('\n', ' ');
        usage = usage.replaceAll("(\\s)\\s+", "$1");
        Assert.assertTrue((boolean)usage.contains("must be a path"));
        Assert.assertTrue((boolean)usage.contains("must be a path to a file"));
        Assert.assertTrue((boolean)usage.contains("must be a path to a directory"));
        Assert.assertTrue((boolean)usage.contains("must be readable"));
        Assert.assertTrue((boolean)usage.contains("must be readable and writable"));
        Assert.assertTrue((boolean)usage.contains("must be executable"));
        Assert.assertTrue((boolean)usage.contains("must exist"));
    }
}

