/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.TestingUtil;
import com.github.rvesse.airline.parser.errors.ParseOptionGroupException;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingException;
import com.github.rvesse.airline.restrictions.If;
import com.github.rvesse.airline.restrictions.One;
import com.github.rvesse.airline.restrictions.OptionallyOne;
import com.github.rvesse.airline.restrictions.Some;
import org.testng.annotations.Test;

public class TestRequired {
    @Test
    public void require_some_good() {
        SingleCommand<Some> parser = TestingUtil.singleCommandParser(Some.class);
        parser.parse(new String[]{"-a", "test"});
        parser.parse(new String[]{"-b", "test"});
        parser.parse(new String[]{"-c", "test"});
        parser.parse(new String[]{"-a", "test", "-b", "test2"});
        parser.parse(new String[]{"-a", "test", "-a", "test2"});
        parser.parse(new String[]{"-a", "test", "-c", "test2"});
        parser.parse(new String[]{"-b", "test", "-c", "test2"});
        parser.parse(new String[]{"-a", "test", "-b", "test2", "-c", "test3"});
        parser.parse(new String[]{"-a", "test", "-b", "test2", "-c", "test3", "-a", "test4", "-c", "test5"});
    }

    @Test(expectedExceptions={ParseOptionGroupException.class})
    public void require_some_bad_none() {
        SingleCommand<Some> parser = TestingUtil.singleCommandParser(Some.class);
        parser.parse(new String[0]);
    }

    @Test
    public void require_one_good() {
        SingleCommand<One> parser = TestingUtil.singleCommandParser(One.class);
        parser.parse(new String[]{"-a", "test"});
        parser.parse(new String[]{"-b", "test"});
        parser.parse(new String[]{"-c", "test"});
        parser.parse(new String[]{"-a", "test", "-a", "test2"});
        parser.parse(new String[]{"-b", "test", "-b", "test2"});
        parser.parse(new String[]{"-c", "test", "-c", "test2", "-c", "test3", "-c", "test4", "-c", "test5"});
    }

    @Test(expectedExceptions={ParseOptionGroupException.class})
    public void require_one_bad_none() {
        SingleCommand<One> parser = TestingUtil.singleCommandParser(One.class);
        parser.parse(new String[0]);
    }

    @Test(expectedExceptions={ParseOptionGroupException.class})
    public void require_one_bad_multiple_01() {
        SingleCommand<One> parser = TestingUtil.singleCommandParser(One.class);
        parser.parse(new String[]{"-a", "test", "-b", "test2"});
    }

    @Test(expectedExceptions={ParseOptionGroupException.class})
    public void require_one_bad_multiple_02() {
        SingleCommand<One> parser = TestingUtil.singleCommandParser(One.class);
        parser.parse(new String[]{"-a", "test", "-c", "test2"});
    }

    @Test(expectedExceptions={ParseOptionGroupException.class})
    public void require_one_bad_multiple_03() {
        SingleCommand<One> parser = TestingUtil.singleCommandParser(One.class);
        parser.parse(new String[]{"-b", "test", "-c", "test2"});
    }

    @Test
    public void required_if_good_unneeded_missing() {
        SingleCommand<If> parser = TestingUtil.singleCommandParser(If.class);
        parser.parse(new String[0]);
    }

    @Test
    public void required_if_good_unneeded_present() {
        SingleCommand<If> parser = TestingUtil.singleCommandParser(If.class);
        parser.parse(new String[]{"-b", "test"});
    }

    @Test
    public void required_if_good_needed() {
        SingleCommand<If> parser = TestingUtil.singleCommandParser(If.class);
        parser.parse(new String[]{"-a", "test", "-b", "test2"});
        parser.parse(new String[]{"--alpha", "test", "-b", "test2"});
        parser.parse(new String[]{"-a", "test", "--bravo", "test2"});
        parser.parse(new String[]{"--alpha", "test", "--bravo", "test2"});
    }

    @Test(expectedExceptions={ParseOptionMissingException.class})
    public void required_if_bad_needed() {
        SingleCommand<If> parser = TestingUtil.singleCommandParser(If.class);
        parser.parse(new String[]{"-a", "test"});
    }

    @Test
    public void mutually_exclusive_with_good() {
        SingleCommand<OptionallyOne> parser = TestingUtil.singleCommandParser(OptionallyOne.class);
        parser.parse(new String[]{"-a", "test"});
        parser.parse(new String[]{"-b", "test"});
        parser.parse(new String[]{"-c", "test"});
        parser.parse(new String[]{"-a", "test", "-a", "test2"});
        parser.parse(new String[]{"-b", "test", "-b", "test2"});
        parser.parse(new String[]{"-c", "test", "-c", "test2", "-c", "test3", "-c", "test4", "-c", "test5"});
    }

    @Test
    public void mutually_exclusive_with_none() {
        SingleCommand<OptionallyOne> parser = TestingUtil.singleCommandParser(OptionallyOne.class);
        parser.parse(new String[0]);
    }

    @Test(expectedExceptions={ParseOptionGroupException.class})
    public void mutually_exclusive_with_multiple_01() {
        SingleCommand<OptionallyOne> parser = TestingUtil.singleCommandParser(OptionallyOne.class);
        parser.parse(new String[]{"-a", "test", "-b", "test2"});
    }

    @Test(expectedExceptions={ParseOptionGroupException.class})
    public void mutually_exclusive_with_multiple_02() {
        SingleCommand<OptionallyOne> parser = TestingUtil.singleCommandParser(OptionallyOne.class);
        parser.parse(new String[]{"-a", "test", "-c", "test2"});
    }

    @Test(expectedExceptions={ParseOptionGroupException.class})
    public void mutually_exclusive_with_multiple_03() {
        SingleCommand<OptionallyOne> parser = TestingUtil.singleCommandParser(OptionallyOne.class);
        parser.parse(new String[]{"-b", "test", "-c", "test2"});
    }
}

