/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.factories;

import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.factories.ArgumentsRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.GlobalRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.OptionRestrictionFactory;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;

public class RestrictionRegistry {
    private static final Map<Class<? extends Annotation>, OptionRestrictionFactory> OPTION_RESTRICTION_FACTORIES = new HashMap<Class<? extends Annotation>, OptionRestrictionFactory>();
    private static final Map<Class<? extends Annotation>, ArgumentsRestrictionFactory> ARGUMENT_RESTRICTION_FACTORIES = new HashMap<Class<? extends Annotation>, ArgumentsRestrictionFactory>();
    private static final Map<Class<? extends Annotation>, GlobalRestrictionFactory> GLOBAL_RESTRICTION_FACTORIES = new HashMap<Class<? extends Annotation>, GlobalRestrictionFactory>();
    private static volatile boolean init = false;

    static <T> void loadRestrictions(Class<T> cls, Function<T, List<Class<? extends Annotation>>> annotationsSelector, Map<Class<? extends Annotation>, T> registry) {
        try {
            ServiceLoader<T> factories = ServiceLoader.load(cls);
            for (T factory : factories) {
                for (Class<? extends Annotation> annotationClass : annotationsSelector.apply(factory)) {
                    registry.put(annotationClass, factory);
                }
            }
        }
        catch (Throwable e) {
            System.err.println("Failed to load " + cls.getSimpleName() + ": " + e.getMessage());
        }
    }

    static synchronized void init() {
        if (init) {
            return;
        }
        RestrictionRegistry.loadRestrictions(OptionRestrictionFactory.class, x -> x.supportedOptionAnnotations(), OPTION_RESTRICTION_FACTORIES);
        RestrictionRegistry.loadRestrictions(ArgumentsRestrictionFactory.class, x -> x.supportedArgumentsAnnotations(), ARGUMENT_RESTRICTION_FACTORIES);
        RestrictionRegistry.loadRestrictions(GlobalRestrictionFactory.class, x -> x.supportedGlobalAnnotations(), GLOBAL_RESTRICTION_FACTORIES);
        init = true;
    }

    public static synchronized void reset() {
        init = false;
        OPTION_RESTRICTION_FACTORIES.clear();
        ARGUMENT_RESTRICTION_FACTORIES.clear();
        GLOBAL_RESTRICTION_FACTORIES.clear();
        RestrictionRegistry.init();
    }

    public static Set<Class<? extends Annotation>> getOptionRestrictionAnnotationClasses() {
        return OPTION_RESTRICTION_FACTORIES.keySet();
    }

    public static void addOptionRestriction(Class<? extends Annotation> cls, OptionRestrictionFactory factory) {
        if (cls == null) {
            throw new NullPointerException("cls cannot be null");
        }
        OPTION_RESTRICTION_FACTORIES.put(cls, factory);
    }

    public static <T extends Annotation> OptionRestriction getOptionRestriction(Class<? extends Annotation> cls, T annotation) {
        OptionRestrictionFactory factory = OPTION_RESTRICTION_FACTORIES.get(cls);
        if (factory != null) {
            return factory.createOptionRestriction(annotation);
        }
        return null;
    }

    public static void addArgumentsRestriction(Class<? extends Annotation> cls, ArgumentsRestrictionFactory factory) {
        if (cls == null) {
            throw new NullPointerException("cls cannot be null");
        }
        ARGUMENT_RESTRICTION_FACTORIES.put(cls, factory);
    }

    public static Set<Class<? extends Annotation>> getArgumentsRestrictionAnnotationClasses() {
        return ARGUMENT_RESTRICTION_FACTORIES.keySet();
    }

    public static <T extends Annotation> ArgumentsRestriction getArgumentsRestriction(Class<? extends Annotation> cls, T annotation) {
        ArgumentsRestrictionFactory factory = ARGUMENT_RESTRICTION_FACTORIES.get(cls);
        if (factory != null) {
            return factory.createArgumentsRestriction(annotation);
        }
        return null;
    }

    public static Set<Class<? extends Annotation>> getGlobalRestrictionAnnotationClasses() {
        return GLOBAL_RESTRICTION_FACTORIES.keySet();
    }

    public static void addGlobalRestriction(Class<? extends Annotation> cls, GlobalRestrictionFactory factory) {
        if (cls == null) {
            throw new NullPointerException("cls cannot be null");
        }
        GLOBAL_RESTRICTION_FACTORIES.put(cls, factory);
    }

    public static <T extends Annotation> GlobalRestriction getGlobalRestriction(Class<? extends Annotation> cls, T annotation) {
        GlobalRestrictionFactory factory = GLOBAL_RESTRICTION_FACTORIES.get(cls);
        if (factory != null) {
            return factory.createGlobalRestriction(annotation);
        }
        return null;
    }

    static {
        RestrictionRegistry.init();
    }
}

