/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.factories;

import com.github.rvesse.airline.annotations.restrictions.NoOptionLikeValues;
import com.github.rvesse.airline.annotations.restrictions.Unrestricted;
import com.github.rvesse.airline.annotations.restrictions.global.CommandRequired;
import com.github.rvesse.airline.annotations.restrictions.global.NoMissingOptionValues;
import com.github.rvesse.airline.annotations.restrictions.global.NoUnexpectedArguments;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.restrictions.None;
import com.github.rvesse.airline.restrictions.common.NoOptionLikeValuesRestriction;
import com.github.rvesse.airline.restrictions.factories.GlobalRestrictionFactory;
import com.github.rvesse.airline.restrictions.global.CommandRequiredRestriction;
import com.github.rvesse.airline.restrictions.global.NoMissingOptionValuesRestriction;
import com.github.rvesse.airline.restrictions.global.NoUnexpectedArgumentsRestriction;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class StandardGlobalRestrictionsFactory
implements GlobalRestrictionFactory {
    @Override
    public GlobalRestriction createGlobalRestriction(Annotation annotation) {
        if (annotation instanceof Unrestricted) {
            return new None();
        }
        if (annotation instanceof CommandRequired) {
            return new CommandRequiredRestriction();
        }
        if (annotation instanceof NoMissingOptionValues) {
            return new NoMissingOptionValuesRestriction();
        }
        if (annotation instanceof NoUnexpectedArguments) {
            return new NoUnexpectedArgumentsRestriction();
        }
        if (annotation instanceof NoOptionLikeValues) {
            return new NoOptionLikeValuesRestriction(((NoOptionLikeValues)annotation).optionPrefixes());
        }
        return null;
    }

    @Override
    public List<Class<? extends Annotation>> supportedGlobalAnnotations() {
        ArrayList<Class<? extends Annotation>> supported = new ArrayList<Class<? extends Annotation>>();
        supported.add(Unrestricted.class);
        supported.add(CommandRequired.class);
        supported.add(NoMissingOptionValues.class);
        supported.add(NoUnexpectedArguments.class);
        supported.add(NoOptionLikeValues.class);
        return supported;
    }
}

