/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help;

import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface UsageHelper {
    public static final Comparator<HelpHint> DEFAULT_HINT_COMPARATOR = Comparator.comparing(Object::getClass, Comparator.comparing(Class::getName)).thenComparing(Function.identity(), Comparator.comparingInt(System::identityHashCode));
    public static final Comparator<OptionMetadata> DEFAULT_OPTION_COMPARATOR = Comparator.comparing(o -> o.getOptions().iterator().next().replaceFirst("^-+", ""), String.CASE_INSENSITIVE_ORDER.thenComparing(Comparator.reverseOrder()).thenComparingInt(System::identityHashCode));
    public static final Comparator<CommandMetadata> DEFAULT_COMMAND_COMPARATOR = Comparator.comparing(CommandMetadata::getName, String.CASE_INSENSITIVE_ORDER).thenComparing(CommandMetadata::getName, Comparator.reverseOrder()).thenComparing(Function.identity(), Comparator.comparingInt(System::identityHashCode));
    public static final Comparator<CommandGroupMetadata> DEFAULT_COMMAND_GROUP_COMPARATOR = Comparator.comparing(CommandGroupMetadata::getName, String::compareToIgnoreCase).thenComparing(CommandGroupMetadata::getName, Comparator.reverseOrder()).thenComparing(Function.identity(), Comparator.comparingInt(System::identityHashCode));
    public static final Comparator<Map.Entry<Integer, String>> DEFAULT_EXIT_CODE_COMPARATOR = Comparator.comparingInt(Map.Entry::getKey).thenComparing(Map.Entry::getValue).thenComparing(Function.identity(), Comparator.comparingInt(System::identityHashCode));

    public static String[] toGroupNames(List<CommandGroupMetadata> groupPath) {
        return (String[])groupPath.stream().map(CommandGroupMetadata::getName).toArray(String[]::new);
    }
}

