/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.common;

import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class AbstractUsageGenerator {
    public static final int DEFAULT_COLUMNS = 79;
    private final Comparator<? super HelpHint> hintComparator;
    private final Comparator<? super OptionMetadata> optionComparator;
    private final Comparator<? super CommandMetadata> commandComparator;
    private final boolean includeHidden;

    public AbstractUsageGenerator() {
        this(UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, false);
    }

    public AbstractUsageGenerator(Comparator<? super HelpHint> hintComparator, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, boolean includeHidden) {
        this.hintComparator = hintComparator;
        this.optionComparator = optionComparator;
        this.commandComparator = commandComparator;
        this.includeHidden = includeHidden;
    }

    protected boolean includeHidden() {
        return this.includeHidden;
    }

    protected final Comparator<? super OptionMetadata> getOptionComparator() {
        return this.optionComparator;
    }

    protected final Comparator<? super CommandMetadata> getCommandComparator() {
        return this.commandComparator;
    }

    protected List<OptionMetadata> sortOptions(List<OptionMetadata> options) {
        if (this.optionComparator == null) {
            return options;
        }
        return options.stream().sorted(this.optionComparator).collect(Collectors.toList());
    }

    protected List<HelpHint> sortOptionRestrictions(List<OptionRestriction> restrictions) {
        Stream<HelpHint> hints = restrictions.stream().filter(HelpHint.class::isInstance).map(HelpHint.class::cast);
        if (this.hintComparator == null) {
            return hints.collect(Collectors.toList());
        }
        return hints.sorted(this.hintComparator).collect(Collectors.toList());
    }

    protected List<HelpHint> sortArgumentsRestrictions(List<ArgumentsRestriction> restrictions) {
        Stream<HelpHint> hints = restrictions.stream().filter(HelpHint.class::isInstance).map(HelpHint.class::cast);
        if (this.hintComparator == null) {
            return hints.collect(Collectors.toList());
        }
        return hints.sorted(this.hintComparator).collect(Collectors.toList());
    }

    protected List<CommandMetadata> sortCommands(List<CommandMetadata> commands) {
        if (this.commandComparator == null) {
            return commands;
        }
        return commands.stream().sorted(this.commandComparator).collect(Collectors.toList());
    }

    protected final String htmlize(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return "";
        }
        return value.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br/>");
    }

    protected String toDefaultCommand(String command) {
        if (StringUtils.isEmpty((CharSequence)command)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        stringBuilder.append(command);
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    protected List<String> toSynopsisUsage(List<OptionMetadata> options) {
        Predicate<OptionMetadata> noHidden = o -> o.isHidden() && !this.includeHidden;
        return options.stream().filter(noHidden.negate()).map(this::toUsage).collect(Collectors.toList());
    }

    protected String toUsage(ArgumentsMetadata arguments) {
        boolean required = arguments.isRequired();
        StringBuilder stringBuilder = new StringBuilder();
        if (!required) {
            stringBuilder.append("[ ");
        }
        stringBuilder.append(this.toDescription(arguments));
        if (arguments.isMultiValued()) {
            stringBuilder.append("...");
        }
        if (!required) {
            stringBuilder.append(" ]");
        }
        return stringBuilder.toString();
    }

    protected String toUsage(OptionMetadata option) {
        Set<String> options = option.getOptions();
        boolean required = option.isRequired();
        StringBuilder stringBuilder = new StringBuilder();
        if (!required) {
            stringBuilder.append("[ ");
        }
        if (options.size() > 1) {
            stringBuilder.append('{');
        }
        boolean first = true;
        for (String name : options) {
            if (!first) {
                stringBuilder.append(" | ");
            } else {
                first = false;
            }
            stringBuilder.append(name);
        }
        if (options.size() > 1) {
            stringBuilder.append('}');
        }
        if (option.getArity() > 0) {
            for (int i = 0; i < option.getArity(); ++i) {
                stringBuilder.append(" <").append(option.getTitle(i)).append('>');
            }
        }
        if (option.isMultiValued()) {
            stringBuilder.append("...");
        }
        if (!required) {
            stringBuilder.append(" ]");
        }
        return stringBuilder.toString();
    }

    protected String toDescription(ArgumentsMetadata arguments) {
        List<String> descriptionTitles = arguments.getTitle();
        StringBuilder stringBuilder = new StringBuilder();
        for (String title : descriptionTitles) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("<");
            stringBuilder.append(title);
            stringBuilder.append(">");
        }
        return stringBuilder.toString();
    }

    protected String toDescription(OptionMetadata option) {
        Set<String> options = option.getOptions();
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        for (String name : options) {
            if (!first) {
                stringBuilder.append(", ");
            } else {
                first = false;
            }
            stringBuilder.append(name);
            if (option.getArity() <= 0) continue;
            for (int i = 0; i < option.getArity(); ++i) {
                stringBuilder.append(" <").append(option.getTitle(i)).append('>');
            }
        }
        return stringBuilder.toString();
    }
}

