/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.model;

import com.github.rvesse.airline.Accessor;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.types.DefaultTypeConverterProvider;
import com.github.rvesse.airline.types.TypeConverterProvider;
import com.github.rvesse.airline.utils.AirlineUtils;
import com.github.rvesse.airline.utils.predicates.restrictions.IsRequiredArgumentFinder;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;

public class ArgumentsMetadata {
    private final List<String> titles;
    private final String description;
    private final Set<Accessor> accessors;
    private final List<ArgumentsRestriction> restrictions;
    private final TypeConverterProvider provider;

    public ArgumentsMetadata(Iterable<String> titles, String description, Iterable<ArgumentsRestriction> restrictions, TypeConverterProvider typeConverterProvider, Iterable<Field> path) {
        if (titles == null) {
            throw new NullPointerException("title cannot be null");
        }
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        if (!path.iterator().hasNext()) {
            throw new IllegalArgumentException("path cannot be empty");
        }
        this.titles = List.copyOf(IteratorUtils.toList(titles.iterator()));
        this.description = description;
        this.restrictions = restrictions != null ? AirlineUtils.unmodifiableListCopy(restrictions) : Collections.emptyList();
        this.provider = typeConverterProvider != null ? typeConverterProvider : new DefaultTypeConverterProvider();
        this.accessors = SetUtils.unmodifiableSet(Collections.singleton(new Accessor(path)));
    }

    public ArgumentsMetadata(Iterable<ArgumentsMetadata> arguments) {
        if (arguments == null) {
            throw new NullPointerException("arguments cannot be null");
        }
        if (!arguments.iterator().hasNext()) {
            throw new IllegalArgumentException("arguments cannot be empty");
        }
        ArgumentsMetadata first = arguments.iterator().next();
        this.titles = first.titles;
        this.description = first.description;
        this.restrictions = first.restrictions;
        this.provider = first.provider;
        HashSet<Accessor> accessors = new HashSet<Accessor>();
        for (ArgumentsMetadata other : arguments) {
            if (!first.equals(other)) {
                throw new IllegalArgumentException(String.format("Conflicting arguments definitions: %s, %s", first, other));
            }
            accessors.addAll(other.getAccessors());
        }
        this.accessors = SetUtils.unmodifiableSet(accessors);
    }

    public List<String> getTitle() {
        return this.titles;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return CollectionUtils.exists(this.restrictions, (Predicate)new IsRequiredArgumentFinder());
    }

    public Set<Accessor> getAccessors() {
        return this.accessors;
    }

    public boolean isMultiValued() {
        return this.accessors.iterator().next().isMultiValued();
    }

    public Class<?> getJavaType() {
        return this.accessors.iterator().next().getJavaType();
    }

    public List<ArgumentsRestriction> getRestrictions() {
        return this.restrictions;
    }

    public TypeConverterProvider getTypeConverterProvider() {
        return this.provider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArgumentsMetadata that = (ArgumentsMetadata)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return this.titles.equals(that.titles);
    }

    public int hashCode() {
        int result = this.titles.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArgumentsMetadata");
        sb.append("{title='").append(StringUtils.join(this.titles, (char)',')).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", accessors=").append(this.accessors);
        sb.append('}');
        return sb.toString();
    }
}

