/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.model;

import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CommandGroupMetadata {
    private final String name;
    private final String description;
    private final boolean hidden;
    private final List<OptionMetadata> options;
    private final CommandMetadata defaultCommand;
    private final List<CommandMetadata> commands;
    private final List<CommandGroupMetadata> subGroups;
    private CommandGroupMetadata parentGroup;

    public CommandGroupMetadata(String name, String description, boolean hidden, Iterable<OptionMetadata> options, Iterable<CommandGroupMetadata> subGroups, CommandMetadata defaultCommand, Iterable<CommandMetadata> commands) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Group name may not be null/empty");
        }
        if (StringUtils.containsWhitespace((CharSequence)name)) {
            throw new IllegalArgumentException("Group name may not contain whitespace");
        }
        this.name = name;
        this.description = description;
        this.hidden = hidden;
        this.options = AirlineUtils.unmodifiableListCopy(options);
        this.subGroups = AirlineUtils.listCopy(subGroups);
        this.defaultCommand = defaultCommand;
        this.commands = AirlineUtils.listCopy(commands);
        if (this.defaultCommand != null && !this.commands.contains(this.defaultCommand)) {
            this.commands.add(this.defaultCommand);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<OptionMetadata> getOptions() {
        return this.options;
    }

    public CommandMetadata getDefaultCommand() {
        return this.defaultCommand;
    }

    public List<CommandMetadata> getCommands() {
        return Collections.unmodifiableList(this.commands);
    }

    public void addCommand(CommandMetadata command) {
        if (!this.commands.contains(command)) {
            this.commands.add(command);
        }
    }

    public List<CommandGroupMetadata> getSubGroups() {
        return Collections.unmodifiableList(this.subGroups);
    }

    public void addSubGroup(CommandGroupMetadata subGroup) {
        if (!this.subGroups.contains(subGroup)) {
            this.subGroups.add(subGroup);
        }
    }

    public void setParent(CommandGroupMetadata parent) {
        if (this.parentGroup != null && this.parentGroup != parent) {
            throw new IllegalStateException("Parent group is already set");
        }
        this.parentGroup = parent;
    }

    public CommandGroupMetadata getParent() {
        return this.parentGroup;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CommandGroupMetadata");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", hidden=").append(this.hidden);
        sb.append(", options=").append(this.options);
        sb.append(", defaultCommand=").append(this.defaultCommand);
        sb.append(", commands=").append(this.commands);
        sb.append('}');
        return sb.toString();
    }
}

