/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.model;

import com.github.rvesse.airline.Accessor;
import com.github.rvesse.airline.annotations.Group;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CommandMetadata {
    private final String name;
    private final String description;
    private final boolean hidden;
    private final List<OptionMetadata> globalOptions;
    private final List<OptionMetadata> groupOptions;
    private final List<OptionMetadata> commandOptions;
    private final OptionMetadata defaultOption;
    private final ArgumentsMetadata arguments;
    private final List<Accessor> metadataInjections;
    private final Class<?> type;
    private final List<String> groupNames;
    private final List<Group> groups;
    private final List<HelpSection> sections;

    public CommandMetadata(String name, String description, boolean hidden, Iterable<OptionMetadata> globalOptions, Iterable<OptionMetadata> groupOptions, Iterable<OptionMetadata> commandOptions, OptionMetadata defaultOption, ArgumentsMetadata arguments, Iterable<Accessor> metadataInjections, Class<?> type, List<String> groupNames, List<Group> groups, List<HelpSection> sections) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Command name may not be null/empty");
        }
        if (StringUtils.containsWhitespace((CharSequence)name)) {
            throw new IllegalArgumentException("Command name may not contain whitespace");
        }
        this.name = name;
        this.description = description;
        this.hidden = hidden;
        this.globalOptions = AirlineUtils.unmodifiableListCopy(globalOptions);
        this.groupOptions = AirlineUtils.unmodifiableListCopy(groupOptions);
        this.commandOptions = AirlineUtils.unmodifiableListCopy(commandOptions);
        this.defaultOption = defaultOption;
        this.arguments = arguments;
        if (this.defaultOption != null && this.arguments != null) {
            throw new IllegalArgumentException("Command cannot declare both @Arguments and @DefaultOption");
        }
        this.metadataInjections = AirlineUtils.unmodifiableListCopy(metadataInjections);
        this.type = type;
        this.groupNames = groupNames;
        this.groups = groups;
        this.sections = AirlineUtils.unmodifiableListCopy(sections);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public List<OptionMetadata> getAllOptions() {
        ArrayList<OptionMetadata> allOptions = new ArrayList<OptionMetadata>();
        allOptions.addAll(this.globalOptions);
        allOptions.addAll(this.groupOptions);
        allOptions.addAll(this.commandOptions);
        return List.copyOf(allOptions);
    }

    public List<HelpSection> getHelpSections() {
        return this.sections;
    }

    public List<OptionMetadata> getGlobalOptions() {
        return this.globalOptions;
    }

    public List<OptionMetadata> getGroupOptions() {
        return this.groupOptions;
    }

    public List<OptionMetadata> getCommandOptions() {
        return this.commandOptions;
    }

    public OptionMetadata getDefaultOption() {
        return this.defaultOption;
    }

    public ArgumentsMetadata getArguments() {
        return this.arguments;
    }

    public List<Accessor> getMetadataInjections() {
        return this.metadataInjections;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CommandMetadata {").append('\n');
        sb.append(" name='").append(this.name).append('\'').append('\n');
        sb.append(" , description='").append(this.description).append('\'').append('\n');
        sb.append(" , sections=").append(this.sections).append('\n');
        sb.append(" , globalOptions=").append(this.globalOptions).append('\n');
        sb.append(" , groupOptions=").append(this.groupOptions).append('\n');
        sb.append(" , commandOptions=").append(this.commandOptions).append('\n');
        sb.append(" , arguments=").append(this.arguments).append('\n');
        sb.append(" , metadataInjections=").append(this.metadataInjections).append('\n');
        sb.append(" , type=").append(this.type).append('\n');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CommandMetadata)) {
            return false;
        }
        CommandMetadata cmd = (CommandMetadata)other;
        return StringUtils.equals((CharSequence)this.name, (CharSequence)cmd.name) && this.type.equals(cmd.type);
    }
}

