/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.types;

import com.github.rvesse.airline.parser.errors.ParseOptionConversionException;
import com.github.rvesse.airline.types.ConvertResult;
import com.github.rvesse.airline.types.DefaultTypeConverterProvider;
import com.github.rvesse.airline.types.TypeConverter;
import com.github.rvesse.airline.types.numerics.DefaultNumericConverter;
import com.github.rvesse.airline.types.numerics.NumericTypeConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;

public class DefaultTypeConverter
extends DefaultTypeConverterProvider
implements TypeConverter {
    private NumericTypeConverter numericConverter;

    public DefaultTypeConverter() {
        this(null);
    }

    public DefaultTypeConverter(NumericTypeConverter numericConverter) {
        this.numericConverter = numericConverter != null ? numericConverter : new DefaultNumericConverter();
    }

    @Override
    public Object convert(String name, Class<?> type, String value) {
        DefaultTypeConverter.checkArguments(name, type, value);
        ConvertResult result = this.tryConvertBasicTypes(name, type, value);
        if (result.wasSuccessful()) {
            return result.getConvertedValue();
        }
        result = this.tryConvertFromString(name, type, value);
        if (result.wasSuccessful()) {
            return result.getConvertedValue();
        }
        result = this.tryConvertFromValueOf(name, type, value);
        if (result.wasSuccessful()) {
            return result.getConvertedValue();
        }
        result = this.tryConvertStringConstructor(name, type, value);
        if (result.wasSuccessful()) {
            return result.getConvertedValue();
        }
        throw new ParseOptionConversionException(name, value, type.getSimpleName());
    }

    public static void checkArguments(String name, Class<?> type, String value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
    }

    protected final ConvertResult tryConvertStringConstructor(String name, Class<?> type, String value) {
        ConvertResult result = this.tryConvertConstructor(name, type, value, String.class);
        if (result.wasSuccessful()) {
            return result;
        }
        return this.tryConvertConstructor(name, type, value, CharSequence.class);
    }

    protected final <T> ConvertResult tryConvertConstructor(String name, Class<?> type, String value, Class<T> parameterType) {
        try {
            Constructor<?> constructor = type.getConstructor(parameterType);
            return new ConvertResult(constructor.newInstance(value));
        }
        catch (Throwable throwable) {
            return ConvertResult.FAILURE;
        }
    }

    protected final ConvertResult tryConvertFromValueOf(String name, Class<?> type, String value) {
        return this.tryConvertStringMethod(name, type, value, "valueOf");
    }

    protected final ConvertResult tryConvertFromString(String name, Class<?> type, String value) {
        return this.tryConvertStringMethod(name, type, value, "fromString");
    }

    protected final ConvertResult tryConvertStringMethod(String name, Class<?> type, String value, String methodName) {
        ConvertResult result = this.tryConvertStringMethod(type, value, methodName, String.class);
        if (result.wasSuccessful()) {
            return result;
        }
        return this.tryConvertStringMethod(type, value, methodName, CharSequence.class);
    }

    protected final ConvertResult tryConvertStringMethod(Class<?> type, String value, String methodName, Class<?> parameterType) {
        try {
            Method method = type.getMethod(methodName, parameterType);
            if (method.getReturnType().isAssignableFrom(type)) {
                return new ConvertResult(method.invoke(null, value));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ConvertResult.FAILURE;
    }

    protected final ConvertResult tryConvertBasicTypes(String name, Class<?> type, String value) {
        try {
            if (String.class.isAssignableFrom(type)) {
                return new ConvertResult(value);
            }
            if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                return new ConvertResult(Boolean.valueOf(value));
            }
            if (Path.class.isAssignableFrom(type)) {
                return new ConvertResult(Paths.get(value, new String[0]));
            }
            if (this.numericConverter != null) {
                return this.numericConverter.tryConvertNumerics(name, type, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ConvertResult.FAILURE;
    }

    @Override
    public void setNumericConverter(NumericTypeConverter converter) {
        this.numericConverter = converter;
        if (this.numericConverter == null) {
            this.numericConverter = new DefaultNumericConverter();
        }
    }
}

