/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;

public class AirlineUtils {
    public static <T> T first(Iterable<T> iterable) {
        return AirlineUtils.first(iterable.iterator(), null);
    }

    public static <T> T first(Iterator<T> iterator) {
        return AirlineUtils.first(iterator, null);
    }

    public static <T> T first(Iterable<T> iterable, T defaultValue) {
        return AirlineUtils.first(iterable.iterator(), defaultValue);
    }

    public static <T> T first(Iterator<T> iter, T defaultValue) {
        if (iter.hasNext()) {
            return iter.next();
        }
        return defaultValue;
    }

    public static <T> T last(Iterable<T> iterable) {
        return AirlineUtils.last(iterable.iterator(), null);
    }

    public static <T> T last(Iterator<T> iterator) {
        return AirlineUtils.last(iterator, null);
    }

    public static <T> T last(Iterable<T> iterable, T defaultValue) {
        return AirlineUtils.last(iterable.iterator(), defaultValue);
    }

    public static <T> T last(Iterator<T> iter, T defaultValue) {
        T value = defaultValue;
        while (iter.hasNext()) {
            value = iter.next();
        }
        return value;
    }

    public static <K, V> Map<K, V> singletonMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <T> Set<T> intersection(Set<T> a, Set<T> b) {
        HashSet<T> intersection = new HashSet<T>();
        for (T item : a) {
            if (!b.contains(item)) continue;
            intersection.add(item);
        }
        return intersection;
    }

    public static <T> List<T> listCopy(Collection<T> collection) {
        if (collection == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> listCopy(Iterable<T> iterable) {
        if (iterable == null) {
            return new ArrayList();
        }
        return IteratorUtils.toList(iterable.iterator());
    }

    public static <T> List<T> unmodifiableListCopy(Collection<T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        return List.copyOf(collection);
    }

    public static <T> List<T> unmodifiableListCopy(Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return List.copyOf(IteratorUtils.toList(iterable.iterator()));
    }

    public static <T> List<T> unmodifiableListCopy(T[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        return List.copyOf(Arrays.asList(array));
    }

    public static <K, V> Map<K, V> unmodifiableMapCopy(Map<K, V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    public static <T> Set<T> unmodifiableSetCopy(Iterable<T> iterable) {
        if (iterable == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        Iterator<T> iter = iterable.iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return Collections.unmodifiableSet(set);
    }

    public static <T> Set<T> unmodifiableSetCopy(Set<T> set) {
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new LinkedHashSet<T>(set));
    }

    public static <T> T find(Iterable<T> collection, Predicate<T> predicate, T defaultValue) {
        if (collection == null) {
            return defaultValue;
        }
        Object value = CollectionUtils.find(collection, predicate);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public static String toRangeString(Object min, boolean minInclusive, Object max, boolean maxInclusive) {
        StringBuilder builder = new StringBuilder();
        if (min != null) {
            if (max != null) {
                builder.append(min);
                builder.append(minInclusive ? " <=" : " <");
                builder.append(" value ");
            } else {
                builder.append("value ");
                builder.append(minInclusive ? ">= " : ">");
                builder.append(min);
            }
        }
        if (max != null) {
            builder.append(maxInclusive ? "<= " : "< ");
            builder.append(max);
        }
        return builder.toString();
    }

    public static String toOrdinal(int value) {
        StringBuilder builder = new StringBuilder();
        builder.append(Integer.toString(value));
        block0 : switch (value % 100) {
            case 11: 
            case 12: 
            case 13: {
                builder.append("th");
                break;
            }
            default: {
                switch (value % 10) {
                    case 1: {
                        builder.append("st");
                        break block0;
                    }
                    case 2: {
                        builder.append("nd");
                        break block0;
                    }
                    case 3: {
                        builder.append("rd");
                        break block0;
                    }
                }
                builder.append("th");
            }
        }
        return builder.toString();
    }
}

