/*
 * Decompiled with CFR 0.152.
 */
package com.github.ryanholdren.resourcegzipper;

import com.github.ryanholdren.resourcegzipper.CompressionLevel;
import com.github.ryanholdren.resourcegzipper.GZIPOutputStreamWithCustomCompressionLevel;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.meteogroup.jbrotli.Brotli;
import org.meteogroup.jbrotli.io.BrotliOutputStream;
import org.meteogroup.jbrotli.libloader.BrotliLibraryLoader;

public abstract class AbstractResourceCompressingMojo
extends AbstractMojo {
    @Parameter(property="filter", defaultValue="\\.(cs|j)s$")
    private String filter;
    @Parameter(property="compression", defaultValue="SMALLEST")
    private CompressionLevel compression;
    private Log log;
    private static final String[] TEXT_FILE_EXTENSION;

    public void setLog(Log log) {
        this.log = log;
    }

    protected abstract String getPathToResourceDirectory();

    private Path getResourceDirectory() throws MojoExecutionException {
        String pathToDirectory = this.getPathToResourceDirectory();
        if (pathToDirectory == null) {
            throw new MojoExecutionException("No resource directory was not specified!");
        }
        Path directory = Paths.get(pathToDirectory, new String[0]);
        if (Files.notExists(directory, new LinkOption[0])) {
            throw new MojoExecutionException("The specified resource directory, '" + directory + "', does not exist!");
        }
        if (Files.isDirectory(directory, new LinkOption[0])) {
            return directory;
        }
        throw new MojoExecutionException("The specified resource directory, '" + directory + "', is not a directory at all!");
    }

    public void execute() throws MojoExecutionException {
        Path directory = this.getResourceDirectory();
        Predicate<Path> predicate = this.getFilter();
        try (Stream<Path> resources = Files.walk(directory, new FileVisitOption[0]);){
            ((Stream)resources.filter(predicate).parallel()).forEach(resource -> {
                this.compressWithGZip((Path)resource);
                this.compressWithBrotli((Path)resource);
            });
        }
        catch (Exception exception) {
            throw new MojoExecutionException("Could not walk the specified resource directory, '" + directory + "'!", exception);
        }
    }

    private void compressWithGZip(Path resource) {
        new Compressor(){

            @Override
            protected String getFileExtension() {
                return "gz";
            }

            @Override
            protected String getNameOfCompressionAlgorithm() {
                return "GZip";
            }

            @Override
            protected OutputStream compressedOutputStream(OutputStream stream) throws IOException {
                return new GZIPOutputStreamWithCustomCompressionLevel(stream, AbstractResourceCompressingMojo.this.getDeflaterLevel());
            }
        }.compress(resource);
    }

    private int getDeflaterLevel() {
        switch (this.compression) {
            case FASTEST: {
                return 0;
            }
            case BAlANCED: {
                return 5;
            }
            case SMALLEST: {
                return 9;
            }
        }
        throw new IllegalStateException();
    }

    private void compressWithBrotli(final Path resource) {
        new Compressor(){

            @Override
            protected String getFileExtension() {
                return "br";
            }

            @Override
            protected String getNameOfCompressionAlgorithm() {
                return "Brotli";
            }

            @Override
            protected OutputStream compressedOutputStream(OutputStream stream) throws IOException {
                Brotli.Mode mode = this.isText(resource) ? Brotli.Mode.TEXT : (this.isFont(resource) ? Brotli.Mode.FONT : Brotli.Mode.GENERIC);
                Brotli.Parameter parameter = new Brotli.Parameter(mode, AbstractResourceCompressingMojo.this.getBrotliLevel(), 22, 0);
                return new BrotliOutputStream(stream, parameter);
            }

            private boolean isText(Path resource2) {
                for (String extension : TEXT_FILE_EXTENSION) {
                    if (!resource2.endsWith(extension)) continue;
                    return true;
                }
                return false;
            }

            private boolean isFont(Path resource2) {
                return resource2.endsWith(".woff");
            }
        }.compress(resource);
    }

    public int getBrotliLevel() {
        switch (this.compression) {
            case FASTEST: {
                return 0;
            }
            case BAlANCED: {
                return 6;
            }
            case SMALLEST: {
                return 11;
            }
        }
        throw new IllegalStateException();
    }

    private Predicate<Path> getFilter() {
        Pattern pattern = Pattern.compile(this.filter);
        return resource -> {
            Matcher matcher = pattern.matcher(resource.toString());
            return matcher.find();
        };
    }

    static {
        BrotliLibraryLoader.loadBrotli();
        TEXT_FILE_EXTENSION = new String[]{".js", ".css", ".svg"};
    }

    private abstract class Compressor {
        private Compressor() {
        }

        protected abstract String getFileExtension();

        protected abstract String getNameOfCompressionAlgorithm();

        protected abstract OutputStream compressedOutputStream(OutputStream var1) throws IOException;

        public void compress(Path resource) {
            Path compressedResource = Paths.get(resource.toString() + '.' + this.getFileExtension(), new String[0]);
            try {
                if (Files.exists(compressedResource, new LinkOption[0])) {
                    Instant lastModified = Files.getLastModifiedTime(resource, new LinkOption[0]).toInstant();
                    Instant lastCompressed = Files.getLastModifiedTime(compressedResource, new LinkOption[0]).toInstant();
                    if (lastCompressed.isAfter(lastModified)) {
                        AbstractResourceCompressingMojo.this.log.info((CharSequence)("Skipped compressing resource file with " + this.getNameOfCompressionAlgorithm() + " because it has not been modified: '" + resource + "'."));
                        return;
                    }
                }
                byte[] contents = Files.readAllBytes(resource);
                try (OutputStream output = this.compressedOutputStream(new FileOutputStream(compressedResource.toFile()));){
                    output.write(contents);
                    AbstractResourceCompressingMojo.this.log.info((CharSequence)("Compressed resource file with " + this.getNameOfCompressionAlgorithm() + ": '" + resource + "'."));
                }
            }
            catch (Exception exception) {
                try {
                    Files.deleteIfExists(compressedResource);
                }
                catch (Exception suppressed) {
                    exception.addSuppressed(suppressed);
                }
                AbstractResourceCompressingMojo.this.log.error((CharSequence)("Unexpected error while compressing resource file with " + this.getNameOfCompressionAlgorithm() + ": '" + resource + "'."), (Throwable)exception);
            }
        }
    }
}

