/*
 * Decompiled with CFR 0.152.
 */
package org.s1ck.gdl.model.predicates;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.s1ck.gdl.model.GraphElement;
import org.s1ck.gdl.model.comparables.Literal;
import org.s1ck.gdl.model.comparables.PropertySelector;
import org.s1ck.gdl.model.predicates.expressions.Comparison;
import org.s1ck.gdl.utils.Comparator;

public interface Predicate
extends Serializable {
    public static List<Predicate> fromGraphElement(GraphElement element, String defaultLabel) {
        Comparison predicate;
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (element.getLabel() != null && !element.getLabel().equals(defaultLabel)) {
            predicate = new Comparison(new PropertySelector(element.getVariable(), "__label__"), Comparator.EQ, new Literal(element.getLabel()));
            predicates.add(predicate);
        }
        if (element.getProperties() != null) {
            for (Map.Entry<String, Object> entry : element.getProperties().entrySet()) {
                predicate = new Comparison(new PropertySelector(element.getVariable(), entry.getKey()), Comparator.EQ, new Literal(entry.getValue()));
                predicates.add(predicate);
            }
        }
        return predicates;
    }

    public Predicate[] getArguments();

    public Set<String> getVariables();
}

