/*
 * Copyright 2017 The GDL Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.s1ck.gdl.model.comparables;

/**
 * Used to compare elements (by id)
 */
public class ElementSelector implements ComparableExpression {

  /**
   * Variable which identifies the element
   */
  private String variable;

  /**
   * Creates a new element selector
   *
   * @param variable the variables that represents the element
   */
  public ElementSelector(String variable) {
    this.variable = variable;
  }

  /**
   * Returns the variable which references the element
   * @return variable name
   */
  @Override
  public String getVariable() {
    return this.variable;
  }

  @Override
  public String toString() {
    return variable;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    ElementSelector that = (ElementSelector) o;

    return variable != null ? variable.equals(that.variable) : that.variable == null;

  }

  @Override
  public int hashCode() {
    return variable != null ? variable.hashCode() : 0;
  }
}
