/*
 * Decompiled with CFR 0.152.
 */
package org.s1ck.gdl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.s1ck.gdl.GDLLexer;
import org.s1ck.gdl.GDLLoader;
import org.s1ck.gdl.GDLParser;
import org.s1ck.gdl.model.Edge;
import org.s1ck.gdl.model.Graph;
import org.s1ck.gdl.model.Vertex;
import org.s1ck.gdl.model.predicates.Predicate;

public class GDLHandler {
    private GDLLoader loader;

    private GDLHandler(GDLLoader loader) {
        this.loader = loader;
    }

    public void append(String asciiString) {
        if (asciiString == null) {
            throw new IllegalArgumentException("AsciiString must not be null");
        }
        ANTLRInputStream antlrInputStream = new ANTLRInputStream(asciiString);
        GDLLexer lexer = new GDLLexer((CharStream)antlrInputStream);
        GDLParser parser = new GDLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        new ParseTreeWalker().walk((ParseTreeListener)this.loader, (ParseTree)parser.database());
    }

    public Collection<Graph> getGraphs() {
        return this.loader.getGraphs();
    }

    public Collection<Vertex> getVertices() {
        return this.loader.getVertices();
    }

    public Collection<Edge> getEdges() {
        return this.loader.getEdges();
    }

    public Optional<Predicate> getPredicates() {
        return this.loader.getPredicates();
    }

    public Map<String, Graph> getGraphCache() {
        return this.loader.getGraphCache();
    }

    public Map<String, Graph> getGraphCache(boolean includeUserDefined, boolean includeAutoGenerated) {
        return this.loader.getGraphCache(includeUserDefined, includeAutoGenerated);
    }

    public Map<String, Vertex> getVertexCache() {
        return this.loader.getVertexCache();
    }

    public Map<String, Vertex> getVertexCache(boolean includeUserDefined, boolean includeAutoGenerated) {
        return this.loader.getVertexCache(includeUserDefined, includeAutoGenerated);
    }

    public Map<String, Edge> getEdgeCache() {
        return this.loader.getEdgeCache();
    }

    public Map<String, Edge> getEdgeCache(boolean includeUserDefined, boolean includeAutoGenerated) {
        return this.loader.getEdgeCache(includeUserDefined, includeAutoGenerated);
    }

    public static class Builder {
        private String graphLabel = "__GRAPH";
        private String vertexLabel = "__VERTEX";
        private String edgeLabel = "__EDGE";
        private ANTLRErrorStrategy errorStrategy = new DefaultErrorStrategy();

        public Builder setDefaultGraphLabel(String graphLabel) {
            this.graphLabel = graphLabel;
            return this;
        }

        public Builder setDefaultVertexLabel(String vertexLabel) {
            this.vertexLabel = vertexLabel;
            return this;
        }

        public Builder setDefaultEdgeLabel(String edgeLabel) {
            this.edgeLabel = edgeLabel;
            return this;
        }

        public Builder setErrorStrategy(ANTLRErrorStrategy errorStrategy) {
            this.errorStrategy = errorStrategy;
            return this;
        }

        public GDLHandler buildFromString(String asciiString) {
            ANTLRInputStream antlrInputStream = new ANTLRInputStream(asciiString);
            return this.build(antlrInputStream);
        }

        public GDLHandler buildFromStream(InputStream stream) throws IOException {
            ANTLRInputStream antlrInputStream = new ANTLRInputStream(stream);
            return this.build(antlrInputStream);
        }

        public GDLHandler buildFromFile(String fileName) throws IOException {
            ANTLRFileStream antlrInputStream = new ANTLRFileStream(fileName);
            return this.build((ANTLRInputStream)antlrInputStream);
        }

        private GDLHandler build(ANTLRInputStream antlrInputStream) {
            if (this.graphLabel == null) {
                throw new IllegalArgumentException("Graph label must not be null.");
            }
            if (this.vertexLabel == null) {
                throw new IllegalArgumentException("Vertex label must not be null.");
            }
            if (this.edgeLabel == null) {
                throw new IllegalArgumentException("Edge label must not be null.");
            }
            if (this.errorStrategy == null) {
                throw new IllegalArgumentException("Error handler must not be null.");
            }
            GDLLexer lexer = new GDLLexer((CharStream)antlrInputStream);
            GDLParser parser = new GDLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.setErrorHandler(this.errorStrategy);
            GDLLoader loader = new GDLLoader(this.graphLabel, this.vertexLabel, this.edgeLabel);
            new ParseTreeWalker().walk((ParseTreeListener)loader, (ParseTree)parser.database());
            return new GDLHandler(loader);
        }
    }
}

