/*
 * Decompiled with CFR 0.152.
 */
package org.s1ck.gdl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.s1ck.gdl.GDLBaseListener;
import org.s1ck.gdl.GDLParser;
import org.s1ck.gdl.exceptions.InvalidReferenceException;
import org.s1ck.gdl.model.Edge;
import org.s1ck.gdl.model.Graph;
import org.s1ck.gdl.model.GraphElement;
import org.s1ck.gdl.model.Vertex;
import org.s1ck.gdl.model.comparables.ComparableExpression;
import org.s1ck.gdl.model.comparables.ElementSelector;
import org.s1ck.gdl.model.comparables.Literal;
import org.s1ck.gdl.model.comparables.PropertySelector;
import org.s1ck.gdl.model.predicates.Predicate;
import org.s1ck.gdl.model.predicates.booleans.And;
import org.s1ck.gdl.model.predicates.booleans.Not;
import org.s1ck.gdl.model.predicates.booleans.Or;
import org.s1ck.gdl.model.predicates.booleans.Xor;
import org.s1ck.gdl.model.predicates.expressions.Comparison;
import org.s1ck.gdl.utils.Comparator;

class GDLLoader
extends GDLBaseListener {
    private final Map<String, Graph> userGraphCache;
    private final Map<String, Vertex> userVertexCache;
    private final Map<String, Edge> userEdgeCache;
    private final Map<String, Graph> autoGraphCache;
    private final Map<String, Vertex> autoVertexCache;
    private final Map<String, Edge> autoEdgeCache;
    private final Set<Graph> graphs;
    private final Set<Vertex> vertices;
    private final Set<Edge> edges;
    private Predicate predicates;
    private final String defaultGraphLabel;
    private final String defaultVertexLabel;
    private final String defaultEdgeLabel;
    private long nextGraphId = 0L;
    private long nextVertexId = 0L;
    private long nextEdgeId = 0L;
    private boolean inGraph = false;
    private long currentGraphId;
    private Vertex lastSeenVertex;
    private Edge lastSeenEdge;
    private Deque<Predicate> currentPredicates;
    private static final String ANONYMOUS_GRAPH_VARIABLE = "__g%d";
    private static final String ANONYMOUS_VERTEX_VARIABLE = "__v%d";
    private static final String ANONYMOUS_EDGE_VARIABLE = "__e%d";

    GDLLoader(String defaultGraphLabel, String defaultVertexLabel, String defaultEdgeLabel) {
        this.defaultGraphLabel = defaultGraphLabel;
        this.defaultVertexLabel = defaultVertexLabel;
        this.defaultEdgeLabel = defaultEdgeLabel;
        this.userGraphCache = new HashMap<String, Graph>();
        this.userVertexCache = new HashMap<String, Vertex>();
        this.userEdgeCache = new HashMap<String, Edge>();
        this.autoGraphCache = new HashMap<String, Graph>();
        this.autoVertexCache = new HashMap<String, Vertex>();
        this.autoEdgeCache = new HashMap<String, Edge>();
        this.graphs = new HashSet<Graph>();
        this.vertices = new HashSet<Vertex>();
        this.edges = new HashSet<Edge>();
        this.currentPredicates = new ArrayDeque<Predicate>();
    }

    public String getDefaultGraphLabel() {
        return this.defaultGraphLabel;
    }

    public String getDefaultVertexLabel() {
        return this.defaultVertexLabel;
    }

    public String getDefaultEdgeLabel() {
        return this.defaultEdgeLabel;
    }

    Collection<Graph> getGraphs() {
        return this.graphs;
    }

    Collection<Vertex> getVertices() {
        return this.vertices;
    }

    Collection<Edge> getEdges() {
        return this.edges;
    }

    Optional<Predicate> getPredicates() {
        return this.predicates != null ? Optional.of(this.predicates) : Optional.empty();
    }

    Map<String, Graph> getGraphCache() {
        return this.getGraphCache(true, false);
    }

    Map<String, Graph> getGraphCache(boolean includeUserDefined, boolean includeAutoGenerated) {
        return this.getCache(this.userGraphCache, this.autoGraphCache, includeUserDefined, includeAutoGenerated);
    }

    Map<String, Vertex> getVertexCache() {
        return this.getVertexCache(true, false);
    }

    Map<String, Vertex> getVertexCache(boolean includeUserDefined, boolean includeAutoGenerated) {
        return this.getCache(this.userVertexCache, this.autoVertexCache, includeUserDefined, includeAutoGenerated);
    }

    Map<String, Edge> getEdgeCache() {
        return this.getEdgeCache(true, false);
    }

    Map<String, Edge> getEdgeCache(boolean includeUserDefined, boolean includeAutoGenerated) {
        return this.getCache(this.userEdgeCache, this.autoEdgeCache, includeUserDefined, includeAutoGenerated);
    }

    @Override
    public void enterGraph(GDLParser.GraphContext graphContext) {
        Graph g;
        this.inGraph = true;
        String variable = this.getVariable(graphContext.header());
        if (variable != null && this.userGraphCache.containsKey(variable)) {
            g = this.userGraphCache.get(variable);
        } else {
            g = this.initNewGraph(graphContext);
            if (variable != null) {
                this.userGraphCache.put(variable, g);
            } else {
                variable = String.format(ANONYMOUS_GRAPH_VARIABLE, g.getId());
                this.autoGraphCache.put(variable, g);
            }
            g.setVariable(variable);
            this.graphs.add(g);
        }
        this.currentGraphId = g.getId();
    }

    @Override
    public void exitGraph(GDLParser.GraphContext ctx) {
        this.inGraph = false;
    }

    @Override
    public void exitQuery(GDLParser.QueryContext ctx) {
        for (Vertex v : this.vertices) {
            this.addPredicates(Predicate.fromGraphElement(v, this.getDefaultVertexLabel()));
        }
        for (Edge e : this.edges) {
            this.addPredicates(Predicate.fromGraphElement(e, this.getDefaultEdgeLabel()));
        }
    }

    @Override
    public void enterVertex(GDLParser.VertexContext vertexContext) {
        Vertex v;
        String variable = this.getVariable(vertexContext.header());
        if (variable != null && this.userVertexCache.containsKey(variable)) {
            v = this.userVertexCache.get(variable);
        } else {
            v = this.initNewVertex(vertexContext);
            if (variable != null) {
                this.userVertexCache.put(variable, v);
            } else {
                variable = String.format(ANONYMOUS_VERTEX_VARIABLE, v.getId());
                this.autoVertexCache.put(variable, v);
            }
            v.setVariable(variable);
            this.vertices.add(v);
        }
        this.updateGraphElement(v);
        this.setLastSeenVertex(v);
        this.updateLastSeenEdge(v);
    }

    @Override
    public void enterIncomingEdge(GDLParser.IncomingEdgeContext incomingEdgeContext) {
        this.processEdge(incomingEdgeContext.edgeBody(), true);
    }

    @Override
    public void enterOutgoingEdge(GDLParser.OutgoingEdgeContext outgoingEdgeContext) {
        this.processEdge(outgoingEdgeContext.edgeBody(), false);
    }

    @Override
    public void exitWhere(GDLParser.WhereContext ctx) {
        this.addPredicates(Collections.singletonList(this.currentPredicates.pop()));
    }

    @Override
    public void enterComparisonExpression(GDLParser.ComparisonExpressionContext ctx) {
        this.currentPredicates.add(this.buildComparison(ctx));
    }

    @Override
    public void exitNotExpression(GDLParser.NotExpressionContext ctx) {
        if (!ctx.NOT().isEmpty()) {
            Not not = new Not(this.currentPredicates.pop());
            this.currentPredicates.add(not);
        }
    }

    @Override
    public void exitAndExpression(GDLParser.AndExpressionContext ctx) {
        this.processConjunctionExpression(ctx.AND());
    }

    @Override
    public void exitOrExpression(GDLParser.OrExpressionContext ctx) {
        this.processConjunctionExpression(ctx.OR());
    }

    @Override
    public void exitXorExpression(GDLParser.XorExpressionContext ctx) {
        this.processConjunctionExpression(ctx.XOR());
    }

    private void processEdge(GDLParser.EdgeBodyContext edgeBodyContext, boolean isIncoming) {
        Edge e;
        String variable = null;
        if (edgeBodyContext != null) {
            variable = this.getVariable(edgeBodyContext.header());
        }
        if (variable != null && this.userEdgeCache.containsKey(variable)) {
            e = this.userEdgeCache.get(variable);
        } else {
            e = this.initNewEdge(edgeBodyContext, isIncoming);
            if (variable != null) {
                this.userEdgeCache.put(variable, e);
            } else {
                variable = String.format(ANONYMOUS_EDGE_VARIABLE, e.getId());
                this.autoEdgeCache.put(variable, e);
            }
            e.setVariable(variable);
            this.edges.add(e);
        }
        this.updateGraphElement(e);
        this.setLastSeenEdge(e);
    }

    private void processConjunctionExpression(List<TerminalNode> conjunctions) {
        for (int i = conjunctions.size() - 1; i >= 0; --i) {
            Predicate conjunctionReuse;
            Predicate rhs = this.currentPredicates.removeLast();
            Predicate lhs = this.currentPredicates.removeLast();
            switch (conjunctions.get(i).getText().toLowerCase()) {
                case "and": {
                    conjunctionReuse = new And(lhs, rhs);
                    break;
                }
                case "or": {
                    conjunctionReuse = new Or(lhs, rhs);
                    break;
                }
                default: {
                    conjunctionReuse = new Xor(lhs, rhs);
                }
            }
            this.currentPredicates.add(conjunctionReuse);
        }
    }

    private Graph initNewGraph(GDLParser.GraphContext graphContext) {
        Graph g = new Graph();
        g.setId(this.getNewGraphId());
        List<String> labels = this.getLabels(graphContext.header());
        g.setLabels(labels.isEmpty() ? Collections.singletonList(this.defaultGraphLabel) : labels);
        g.setProperties(this.getProperties(graphContext.properties()));
        return g;
    }

    private Vertex initNewVertex(GDLParser.VertexContext vertexContext) {
        Vertex v = new Vertex();
        v.setId(this.getNewVertexId());
        List<String> labels = this.getLabels(vertexContext.header());
        v.setLabels(labels.isEmpty() ? Collections.singletonList(this.defaultVertexLabel) : labels);
        v.setProperties(this.getProperties(vertexContext.properties()));
        return v;
    }

    private Edge initNewEdge(GDLParser.EdgeBodyContext edgeBodyContext, boolean isIncoming) {
        boolean hasBody = edgeBodyContext != null;
        Edge e = new Edge();
        e.setId(this.getNewEdgeId());
        e.setSourceVertexId(this.getSourceVertexId(isIncoming));
        e.setTargetVertexId(this.getTargetVertexId(isIncoming));
        if (hasBody) {
            List<String> labels = this.getLabels(edgeBodyContext.header());
            e.setLabels(labels.isEmpty() ? Collections.singletonList(this.defaultEdgeLabel) : labels);
            e.setProperties(this.getProperties(edgeBodyContext.properties()));
            int[] range = this.parseEdgeLengthContext(edgeBodyContext.edgeLength());
            e.setLowerBound(range[0]);
            e.setUpperBound(range[1]);
        } else {
            e.setLabel(this.defaultEdgeLabel);
        }
        return e;
    }

    private void updateGraphElement(GraphElement graphElement) {
        if (this.inGraph) {
            graphElement.addToGraph(this.getNextGraphId());
        }
    }

    private String getVariable(GDLParser.HeaderContext header) {
        if (header != null && header.Identifier() != null) {
            return header.Identifier().getText();
        }
        return null;
    }

    private List<String> getLabels(GDLParser.HeaderContext header) {
        if (header != null && header.label() != null) {
            return header.label().stream().map(RuleContext::getText).map(x -> x.substring(1)).collect(Collectors.toList());
        }
        return null;
    }

    private Map<String, Object> getProperties(GDLParser.PropertiesContext propertiesContext) {
        if (propertiesContext != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (GDLParser.PropertyContext property : propertiesContext.property()) {
                properties.put(property.Identifier().getText(), this.getPropertyValue(property.literal()));
            }
            return properties;
        }
        return Collections.emptyMap();
    }

    private Object getPropertyValue(GDLParser.LiteralContext literalContext) {
        if (literalContext.StringLiteral() != null) {
            return this.parseString(literalContext.StringLiteral().getText());
        }
        if (literalContext.BooleanLiteral() != null) {
            return Boolean.parseBoolean(literalContext.BooleanLiteral().getText());
        }
        if (literalContext.IntegerLiteral() != null) {
            String text = literalContext.IntegerLiteral().getText().toLowerCase();
            if (text.endsWith("l")) {
                return Long.parseLong(text.substring(0, text.length() - 1));
            }
            return Integer.parseInt(text);
        }
        if (literalContext.FloatingPointLiteral() != null) {
            String text = literalContext.FloatingPointLiteral().getText().toLowerCase();
            if (text.endsWith("f")) {
                return Float.valueOf(Float.parseFloat(text.substring(0, text.length() - 1)));
            }
            if (text.endsWith("d")) {
                return Double.parseDouble(text.substring(0, text.length() - 1));
            }
            return Float.valueOf(Float.parseFloat(text));
        }
        return null;
    }

    private int[] parseEdgeLengthContext(GDLParser.EdgeLengthContext lengthCtx) {
        int lowerBound = 0;
        int upperBound = 0;
        if (lengthCtx != null) {
            int children = lengthCtx.getChildCount();
            if (children == 4) {
                lowerBound = this.terminalNodeToInt(lengthCtx.IntegerLiteral(0));
                upperBound = this.terminalNodeToInt(lengthCtx.IntegerLiteral(1));
            } else if (children == 3) {
                upperBound = this.terminalNodeToInt(lengthCtx.IntegerLiteral(0));
            } else if (children == 2) {
                lowerBound = this.terminalNodeToInt(lengthCtx.IntegerLiteral(0));
            } else {
                lowerBound = 0;
                upperBound = 0;
            }
        } else {
            lowerBound = 1;
            upperBound = 1;
        }
        return new int[]{lowerBound, upperBound};
    }

    private Comparison buildComparison(GDLParser.ComparisonExpressionContext ctx) {
        ComparableExpression lhs = this.extractComparableExpression(ctx.comparisonElement(0));
        ComparableExpression rhs = this.extractComparableExpression(ctx.comparisonElement(1));
        Comparator comp = Comparator.fromString(ctx.ComparisonOP().getText());
        return new Comparison(lhs, comp, rhs);
    }

    private ComparableExpression extractComparableExpression(GDLParser.ComparisonElementContext element) {
        if (element.literal() != null) {
            return new Literal(this.getPropertyValue(element.literal()));
        }
        if (element.propertyLookup() != null) {
            return this.buildPropertySelector(element.propertyLookup());
        }
        return new ElementSelector(element.Identifier().getText());
    }

    private PropertySelector buildPropertySelector(GDLParser.PropertyLookupContext ctx) {
        GraphElement element;
        String identifier = ctx.Identifier(0).getText();
        String property = ctx.Identifier(1).getText();
        if (this.userVertexCache.containsKey(identifier)) {
            element = this.userVertexCache.get(identifier);
        } else if (this.userEdgeCache.containsKey(identifier)) {
            element = this.userEdgeCache.get(identifier);
        } else {
            throw new InvalidReferenceException(identifier);
        }
        return new PropertySelector(element.getVariable(), property);
    }

    private Long getNextGraphId() {
        return this.currentGraphId;
    }

    private Long getNewGraphId() {
        return this.nextGraphId++;
    }

    private Long getNewVertexId() {
        return this.nextVertexId++;
    }

    private Long getNewEdgeId() {
        return this.nextEdgeId++;
    }

    private <T> Map<String, T> getCache(Map<String, T> userCache, Map<String, T> autoCache, boolean includeUserDefined, boolean includeAutoGenerated) {
        HashMap<String, T> cache = new HashMap<String, T>();
        if (includeUserDefined) {
            cache.putAll(userCache);
        }
        if (includeAutoGenerated) {
            cache.putAll(autoCache);
        }
        return Collections.unmodifiableMap(cache);
    }

    private void addPredicates(List<Predicate> newPredicates) {
        for (Predicate newPredicate : newPredicates) {
            if (this.predicates == null) {
                this.predicates = newPredicate;
                continue;
            }
            this.predicates = new And(this.predicates, newPredicate);
        }
    }

    private void updateLastSeenEdge(Vertex v) {
        Edge lastSeenEdge = this.getLastSeenEdge();
        if (lastSeenEdge != null) {
            if (lastSeenEdge.getSourceVertexId() == null) {
                lastSeenEdge.setSourceVertexId(v.getId());
            } else if (lastSeenEdge.getTargetVertexId() == null) {
                lastSeenEdge.setTargetVertexId(v.getId());
            }
        }
    }

    private Vertex getLastSeenVertex() {
        return this.lastSeenVertex;
    }

    private void setLastSeenVertex(Vertex v) {
        this.lastSeenVertex = v;
    }

    private Edge getLastSeenEdge() {
        return this.lastSeenEdge;
    }

    private void setLastSeenEdge(Edge e) {
        this.lastSeenEdge = e;
    }

    private Long getSourceVertexId(boolean isIncoming) {
        return isIncoming ? null : Long.valueOf(this.getLastSeenVertex().getId());
    }

    private Long getTargetVertexId(boolean isIncoming) {
        return isIncoming ? Long.valueOf(this.getLastSeenVertex().getId()) : null;
    }

    private int terminalNodeToInt(TerminalNode node) {
        return Integer.parseInt(node.getText());
    }

    private String parseString(String in) {
        return in.replaceAll("^.|.$", "").replaceAll("\\\\\"", "\"").replaceAll("\\\\'", "'");
    }
}

