/*
 * Decompiled with CFR 0.152.
 */
package com.github.sabomichal.immutablexjc;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.xml.sax.ErrorHandler;

public final class PluginImpl
extends Plugin {
    private static final String UNSET_PREFIX = "unset";
    private static final String SET_PREFIX = "set";
    private static final String MESSAGE_PREFIX = "IMMUTABLE-XJC";
    private static final String OPTION_NAME = "immutable";
    private static final JType[] NO_ARGS = new JType[0];
    private static final String BUILDER_OPTION_NAME = "-imm-builder";
    private boolean success;
    private Options options;
    private boolean createBuilder;

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) {
        this.success = true;
        this.options = options;
        this.log(Level.INFO, "title", new Object[0]);
        for (ClassOutline clazz : model.getClasses()) {
            JType[] propertyTypes;
            if (this.addStandardConstructor(clazz) == null) {
                this.log(Level.WARNING, "couldNotAddStdCtor", clazz.implClass.binaryName());
            }
            if (this.addPropertyContructor(clazz, propertyTypes = this.getProperties(clazz)) == null) {
                this.log(Level.WARNING, "couldNotAddStdCtor", clazz.implClass.binaryName());
            }
            this.removeSetters(clazz);
            this.makeFinal(clazz);
            this.makePropertiesPrivate(clazz);
            this.makeCollectionsUnmodifiable(clazz);
            if (!this.createBuilder || this.addBuilderClass(clazz) != null) continue;
            this.log(Level.WARNING, "couldNotAddClassBuilder", clazz.implClass.binaryName());
        }
        this.options = null;
        return this.success;
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        String n = System.getProperty("line.separator", "\n");
        return new StringBuilder(1024).append("  -").append(OPTION_NAME).append("  :  ").append(PluginImpl.getMessage("usage", new Object[0])).append(n).append("  ").append(BUILDER_OPTION_NAME).append("       :  ").append(PluginImpl.getMessage("builderUsage", new Object[0])).append(n).toString();
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        if (args[i].startsWith(BUILDER_OPTION_NAME)) {
            this.createBuilder = true;
            return 1;
        }
        return 0;
    }

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(ResourceBundle.getBundle("com/github/sabomichal/immutablexjc/PluginImpl").getString(key), args);
    }

    private JDefinedClass addBuilderClass(ClassOutline clazz) {
        JDefinedClass builderClass = this.generateBuilderClass(clazz);
        if (builderClass == null) {
            return builderClass;
        }
        for (FieldOutline field : clazz.getDeclaredFields()) {
            this.addWithMethod(builderClass, field);
        }
        this.addNewBuilder(clazz, builderClass);
        this.addBuildMethod(clazz, builderClass);
        return builderClass;
    }

    private JMethod addBuildMethod(ClassOutline clazz, JDefinedClass builderClass) {
        JMethod method = builderClass.method(1, (JType)clazz.ref, "build");
        method.body()._return((JExpression)clazz.implClass.staticRef("this"));
        return method;
    }

    private void addNewBuilder(ClassOutline clazz, JDefinedClass builderClass) {
        JMethod method = clazz.implClass.method(17, (JType)builderClass, "newBuilder");
        method.body().directStatement("return (new " + clazz.implClass.fullName() + "()).new " + builderClass.name() + "();");
    }

    private Object addPropertyContructor(ClassOutline clazz, JType[] properties) {
        JMethod ctor = clazz.implClass.getConstructor(properties);
        if (ctor == null) {
            ctor = this.generatePropertyConstructor(clazz);
        } else {
            this.log(Level.WARNING, "standardCtorExists", clazz.implClass.binaryName());
        }
        return ctor;
    }

    private JMethod addStandardConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.getConstructor(NO_ARGS);
        if (ctor == null) {
            ctor = this.generateStandardConstructor(clazz);
        } else {
            this.log(Level.WARNING, "standardCtorExists", clazz.implClass.binaryName());
        }
        return ctor;
    }

    private JMethod addWithMethod(JDefinedClass builderClass, FieldOutline field) {
        String fieldName = field.getPropertyInfo().getName(false);
        JMethod method = builderClass.method(1, (JType)builderClass, "with" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1));
        this.generatePropertyAssignment(method, field, builderClass.outer());
        method.body()._return(JExpr.direct((String)"this"));
        return method;
    }

    private JDefinedClass generateBuilderClass(ClassOutline clazz) {
        JDefinedClass builderClass = null;
        try {
            builderClass = clazz.implClass._class(1, clazz.implClass.name() + "Builder");
            return builderClass;
        }
        catch (JClassAlreadyExistsException jClassAlreadyExistsException) {
            return builderClass;
        }
    }

    private void generateCollectionGetter(ClassOutline clazz, FieldOutline field, JMethod getter) {
        JMethod newMethod = clazz.implClass.method(getter.mods().getValue(), getter.type(), getter.name());
        JBlock block = newMethod.body();
        for (Object o : getter.body().getContents()) {
            if (!(o instanceof JStatement)) continue;
            if ("com.sun.codemodel.JReturn".equals(o.getClass().getName())) {
                block.directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
                block._return((JExpression)JExpr.cast((JType)getter.type(), (JExpression)clazz.implClass.owner().ref(Collections.class).staticInvoke("unmodifiableList").arg((JExpression)JExpr.ref((String)field.getPropertyInfo().getName(false)))));
                continue;
            }
            block.add((JStatement)o);
        }
    }

    private void generatePropertyAssignment(JMethod method, FieldOutline field) {
        JBlock block = method.body();
        String propertyName = field.getPropertyInfo().getName(false);
        JType javaType = this.getJavaType(field);
        method.param(javaType, propertyName);
        block.assign((JAssignmentTarget)JExpr.refthis((String)propertyName), (JExpression)JExpr.ref((String)propertyName));
    }

    private void generatePropertyAssignment(JMethod method, FieldOutline field, JClass outerClass) {
        JBlock block = method.body();
        String propertyName = field.getPropertyInfo().getName(false);
        JType javaType = this.getJavaType(field);
        method.param(javaType, propertyName);
        block.assign((JAssignmentTarget)outerClass.staticRef("this").ref(propertyName), (JExpression)JExpr.ref((String)propertyName));
    }

    private JMethod generatePropertyConstructor(ClassOutline clazz) {
        JMethod ctor = this.generateStandardConstructor(clazz);
        for (FieldOutline fieldOutline : clazz.getDeclaredFields()) {
            this.generatePropertyAssignment(ctor, fieldOutline);
        }
        return ctor;
    }

    private JMethod generateStandardConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.constructor(1);
        ctor.body().directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        ctor.body().invoke("super");
        ctor.javadoc().add((Object)("Creates a new {@code " + clazz.implClass.name() + "} instance."));
        return ctor;
    }

    private JType getJavaType(FieldOutline field) {
        JType javaType = null;
        if (field.getPropertyInfo().isCollection()) {
            javaType = field.getRawType();
            if (javaType.isArray()) {
                // empty if block
            }
        } else {
            CTypeInfo typeInfo = (CTypeInfo)field.getPropertyInfo().ref().iterator().next();
            javaType = typeInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
        }
        return javaType;
    }

    private JType[] getProperties(ClassOutline clazz) {
        JType[] propertyTypes = new JType[clazz.getDeclaredFields().length];
        int i = 0;
        for (FieldOutline fieldOutline : clazz.getDeclaredFields()) {
            propertyTypes[i++] = fieldOutline.getPropertyInfo().baseType;
        }
        return propertyTypes;
    }

    private JMethod getPropertyGetter(FieldOutline f) {
        JDefinedClass clazz = f.parent().implClass;
        String name = f.getPropertyInfo().getName(true);
        JMethod getter = clazz.getMethod("get" + name, NO_ARGS);
        if (getter == null) {
            getter = clazz.getMethod("is" + name, NO_ARGS);
        }
        return getter;
    }

    private void log(Level level, String key, Object ... args) {
        StringBuilder b = new StringBuilder(512).append("[").append(MESSAGE_PREFIX).append("] [").append(level.getLocalizedName()).append("] ").append(PluginImpl.getMessage(key, args));
        int logLevel = Level.WARNING.intValue();
        if (this.options != null && !this.options.quiet) {
            if (this.options.verbose) {
                logLevel = Level.INFO.intValue();
            }
            if (this.options.debugMode) {
                logLevel = Level.ALL.intValue();
            }
        }
        if (level.intValue() >= logLevel) {
            if (level.intValue() <= Level.INFO.intValue()) {
                System.out.println(b.toString());
            } else {
                System.err.println(b.toString());
            }
        }
    }

    private void makeCollectionsUnmodifiable(ClassOutline clazz) {
        for (FieldOutline field : clazz.getDeclaredFields()) {
            JMethod getter = this.getPropertyGetter(field);
            if (!field.getPropertyInfo().isCollection()) continue;
            clazz.implClass.methods().remove(getter);
            this.generateCollectionGetter(clazz, field, getter);
        }
    }

    private void makeFinal(ClassOutline clazz) {
        clazz.implClass.mods().setFinal(true);
    }

    private void makePropertiesPrivate(ClassOutline clazz) {
        for (JFieldVar field : clazz.implClass.fields().values()) {
            field.mods().setPrivate();
        }
    }

    private void removeSetters(ClassOutline clazz) {
        Collection methods = clazz.implClass.methods();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            JMethod method = (JMethod)it.next();
            String methodName = method.name();
            if (!methodName.startsWith(SET_PREFIX) && !methodName.startsWith(UNSET_PREFIX)) continue;
            it.remove();
        }
    }
}

