/*
 * Decompiled with CFR 0.152.
 */
package com.github.sabomichal.immutablexjc;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.beans.Introspector;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.logging.Level;
import org.xml.sax.ErrorHandler;

public final class PluginImpl
extends Plugin {
    private static final String BUILDER_OPTION_NAME = "-imm-builder";
    private static final String UNSET_PREFIX = "unset";
    private static final String SET_PREFIX = "set";
    private static final String MESSAGE_PREFIX = "IMMUTABLE-XJC";
    private static final String OPTION_NAME = "immutable";
    private static final JType[] NO_ARGS = new JType[0];
    private boolean createBuilder;
    private Options options;

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) {
        boolean success = true;
        this.options = options;
        this.log(Level.INFO, "title", new Object[0]);
        for (ClassOutline clazz : model.getClasses()) {
            int superclassFieldsLength;
            JDefinedClass implClass = clazz.implClass;
            FieldOutline[] declaredFields = clazz.getDeclaredFields();
            FieldOutline[] superclassFields = this.getSuperclassFields(clazz);
            int declaredFieldsLength = declaredFields != null ? declaredFields.length : 0;
            int n = superclassFieldsLength = superclassFields != null ? superclassFields.length : 0;
            if (declaredFieldsLength + superclassFieldsLength > 0 && this.addStandardConstructor(implClass, declaredFields, superclassFields) == null) {
                this.log(Level.WARNING, "couldNotAddStdCtor", implClass.binaryName());
            }
            if (declaredFieldsLength + superclassFieldsLength > 0 && this.addPropertyContructor(implClass, declaredFields, superclassFields) == null) {
                this.log(Level.WARNING, "couldNotAddPropertyCtor", implClass.binaryName());
            }
            this.makeClassFinal(implClass);
            this.removeSetters(implClass);
            this.makePropertiesPrivate(implClass);
            this.makePropertiesFinal(implClass);
            if (!this.createBuilder || this.addBuilderClass(clazz, declaredFields, superclassFields) != null) continue;
            this.log(Level.WARNING, "couldNotAddClassBuilder", implClass.binaryName());
        }
        for (ClassOutline clazz : model.getClasses()) {
            boolean hasJaxbBoundSuperclass = clazz.getSuperClass() != null;
            if (!hasJaxbBoundSuperclass) continue;
            clazz.getSuperClass().implClass.mods().setFinal(false);
        }
        this.options = null;
        return success;
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        String n = System.getProperty("line.separator", "\n");
        return "  -" + OPTION_NAME + "  :  " + PluginImpl.getMessage("usage", new Object[0]) + n + "  " + BUILDER_OPTION_NAME + "       :  " + PluginImpl.getMessage("builderUsage", new Object[0]) + n;
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        if (args[i].startsWith(BUILDER_OPTION_NAME)) {
            this.createBuilder = true;
            return 1;
        }
        return 0;
    }

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(ResourceBundle.getBundle("com/github/sabomichal/immutablexjc/PluginImpl").getString(key), args);
    }

    private JDefinedClass addBuilderClass(ClassOutline clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JDefinedClass builderClass = this.generateBuilderClass(clazz.implClass);
        if (builderClass == null) {
            return null;
        }
        for (FieldOutline field : declaredFields) {
            this.addProperty(builderClass, field);
            this.addWithMethod(builderClass, field);
        }
        for (FieldOutline field : superclassFields) {
            this.addProperty(builderClass, field);
            this.addWithMethod(builderClass, field);
        }
        this.addNewBuilder(clazz.implClass, builderClass);
        this.addBuildMethod(clazz.implClass, builderClass, declaredFields, superclassFields);
        return builderClass;
    }

    private void addProperty(JDefinedClass clazz, FieldOutline field) {
        clazz.field(4, this.getJavaType(field), field.getPropertyInfo().getName(false));
    }

    private JMethod addBuildMethod(JDefinedClass clazz, JDefinedClass builderClass, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod method = builderClass.method(1, (JType)clazz, "build");
        JInvocation constructorInvocation = JExpr._new((JClass)clazz);
        for (FieldOutline field : superclassFields) {
            constructorInvocation.arg((JExpression)JExpr.ref((String)field.getPropertyInfo().getName(false)));
        }
        for (FieldOutline field : declaredFields) {
            constructorInvocation.arg((JExpression)JExpr.ref((String)field.getPropertyInfo().getName(false)));
        }
        method.body()._return((JExpression)constructorInvocation);
        return method;
    }

    private void addNewBuilder(JDefinedClass clazz, JDefinedClass builderClass) {
        JMethod method = clazz.method(17, (JType)builderClass, Introspector.decapitalize(clazz.name()) + "Builder");
        method.body()._return((JExpression)JExpr._new((JClass)builderClass));
    }

    private Object addPropertyContructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = clazz.getConstructor(this.getFieldTypes(declaredFields, superclassFields));
        if (ctor == null) {
            ctor = this.generatePropertyConstructor(clazz, declaredFields, superclassFields);
        } else {
            this.log(Level.WARNING, "standardCtorExists", new Object[0]);
        }
        return ctor;
    }

    private JMethod addStandardConstructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = clazz.getConstructor(NO_ARGS);
        if (ctor == null) {
            ctor = this.generateStandardConstructor(clazz, declaredFields, superclassFields);
        } else {
            this.log(Level.WARNING, "standardCtorExists", new Object[0]);
        }
        return ctor;
    }

    private JMethod addWithMethod(JDefinedClass builderClass, FieldOutline field) {
        String fieldName = field.getPropertyInfo().getName(false);
        JMethod method = builderClass.method(1, (JType)builderClass, "with" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1));
        this.generatePropertyAssignment(method, field);
        method.body()._return(JExpr.direct((String)"this"));
        return method;
    }

    private JDefinedClass generateBuilderClass(JDefinedClass clazz) {
        JDefinedClass builderClass = null;
        String builderClassName = clazz.name() + "Builder";
        try {
            builderClass = clazz._class(17, builderClassName);
        }
        catch (JClassAlreadyExistsException e) {
            this.log(Level.WARNING, "builderClassExists", builderClassName);
        }
        return builderClass;
    }

    private void replaceCollectionGetter(FieldOutline field, JMethod getter) {
        JDefinedClass clazz = field.parent().implClass;
        clazz.methods().remove(getter);
        JMethod newGetter = field.parent().implClass.method(getter.mods().getValue(), getter.type(), getter.name());
        JFieldVar fieldVar = (JFieldVar)clazz.fields().get(field.getPropertyInfo().getName(false));
        JBlock block = newGetter.body();
        block._return((JExpression)fieldVar);
        getter.javadoc().append((Object)"Returns unmodifiable collection.");
    }

    private void generatePropertyAssignment(JMethod method, FieldOutline fieldOutline) {
        this.generatePropertyAssignment(method, fieldOutline, false);
    }

    private void generatePropertyAssignment(JMethod method, FieldOutline fieldOutline, boolean wrapUnmodifiable) {
        JBlock block = method.body();
        JCodeModel codeModel = fieldOutline.parent().implClass.owner();
        String fieldName = fieldOutline.getPropertyInfo().getName(false);
        JVar param = this.generateMethodParameter(method, fieldOutline);
        if (fieldOutline.getPropertyInfo().isCollection() && wrapUnmodifiable) {
            JConditional conditional = block._if(param.eq(JExpr._null()));
            conditional._then().assign((JAssignmentTarget)JExpr.refthis((String)fieldName), this.getEmptyCollectionExpression(codeModel, param));
            conditional._else().assign((JAssignmentTarget)JExpr.refthis((String)fieldName), this.getUnmodifiableWrappedExpression(codeModel, param));
            this.replaceCollectionGetter(fieldOutline, this.getGetterProperty(fieldOutline));
        } else {
            block.assign((JAssignmentTarget)JExpr.refthis((String)fieldName), (JExpression)JExpr.ref((String)fieldName));
        }
    }

    private JVar generateMethodParameter(JMethod method, FieldOutline fieldOutline) {
        String fieldName = fieldOutline.getPropertyInfo().getName(false);
        JType javaType = this.getJavaType(fieldOutline);
        return method.param(8, javaType, fieldName);
    }

    private JExpression getUnmodifiableWrappedExpression(JCodeModel codeModel, JVar param) {
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableCollection").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(List.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableList").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableMap").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSet").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSortedMap").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSortedSet").arg((JExpression)param);
        }
        return param;
    }

    private JExpression getEmptyCollectionExpression(JCodeModel codeModel, JVar param) {
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyList");
        }
        if (param.type().erasure().equals(codeModel.ref(List.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyList");
        }
        if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyMap");
        }
        if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptySet");
        }
        if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            return JExpr._new((JClass)codeModel.ref(SortedMap.class));
        }
        if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            return JExpr._new((JClass)codeModel.ref(SortedSet.class));
        }
        return param;
    }

    private void generateOuterPropertyAssignment(JMethod method, FieldOutline field, JClass outerClass) {
        JBlock block = method.body();
        String propertyName = field.getPropertyInfo().getName(false);
        JType javaType = this.getJavaType(field);
        method.param(javaType, propertyName);
        block.assign((JAssignmentTarget)outerClass.staticRef("this").ref(propertyName), (JExpression)JExpr.ref((String)propertyName));
    }

    private void generateDefaultPropertyAssignment(JMethod method, FieldOutline fieldOutline) {
        JBlock block = method.body();
        String propertyName = fieldOutline.getPropertyInfo().getName(false);
        block.assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.defaultValue(this.getJavaType(fieldOutline), fieldOutline));
    }

    private JExpression defaultValue(JType javaType, FieldOutline fieldOutline) {
        if (javaType.isPrimitive()) {
            if (fieldOutline.parent().parent().getCodeModel().BOOLEAN.equals(javaType)) {
                return JExpr.lit((boolean)false);
            }
            if (fieldOutline.parent().parent().getCodeModel().SHORT.equals(javaType)) {
                return JExpr.cast((JType)fieldOutline.parent().parent().getCodeModel().SHORT, (JExpression)JExpr.lit((int)0));
            }
            return JExpr.lit((int)0);
        }
        return JExpr._null();
    }

    private JMethod generatePropertyConstructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = this.createConstructor(clazz, 1);
        if (superclassFields.length > 0) {
            JInvocation superInvocation = ctor.body().invoke("super");
            for (FieldOutline fieldOutline : superclassFields) {
                superInvocation.arg((JExpression)JExpr.ref((String)fieldOutline.getPropertyInfo().getName(false)));
                this.generateMethodParameter(ctor, fieldOutline);
            }
        }
        for (FieldOutline fieldOutline : declaredFields) {
            this.generatePropertyAssignment(ctor, fieldOutline, true);
        }
        return ctor;
    }

    private JMethod generateStandardConstructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = this.createConstructor(clazz, 2);
        ctor.javadoc().add((Object)"Used by JAX-B");
        if (superclassFields.length > 0) {
            JInvocation superInvocation = ctor.body().invoke("super");
            for (FieldOutline fieldOutline : superclassFields) {
                superInvocation.arg(this.defaultValue(this.getJavaType(fieldOutline), fieldOutline));
            }
        }
        for (FieldOutline fieldOutline : declaredFields) {
            this.generateDefaultPropertyAssignment(ctor, fieldOutline);
        }
        return ctor;
    }

    private JMethod createConstructor(JDefinedClass clazz, int visibility) {
        JMethod ctor = clazz.constructor(visibility);
        ctor.body().directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        return ctor;
    }

    private JType getJavaType(FieldOutline field) {
        return field.getRawType();
    }

    private JType[] getFieldTypes(FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JType[] fieldTypes = new JType[declaredFields.length + superclassFields.length];
        int i = 0;
        for (FieldOutline fieldOutline : superclassFields) {
            fieldTypes[i++] = fieldOutline.getPropertyInfo().baseType;
        }
        for (FieldOutline fieldOutline : declaredFields) {
            fieldTypes[i++] = fieldOutline.getPropertyInfo().baseType;
        }
        return fieldTypes;
    }

    private JMethod getGetterProperty(FieldOutline fieldOutline) {
        JDefinedClass clazz = fieldOutline.parent().implClass;
        String name = fieldOutline.getPropertyInfo().getName(true);
        JMethod getter = clazz.getMethod("get" + name, NO_ARGS);
        if (getter == null) {
            getter = clazz.getMethod("is" + name, NO_ARGS);
        }
        return getter;
    }

    private void log(Level level, String key, Object ... args) {
        StringBuilder b = new StringBuilder(512).append("[").append(MESSAGE_PREFIX).append("] [").append(level.getLocalizedName()).append("] ").append(PluginImpl.getMessage(key, args));
        int logLevel = Level.WARNING.intValue();
        if (this.options != null && !this.options.quiet) {
            if (this.options.verbose) {
                logLevel = Level.INFO.intValue();
            }
            if (this.options.debugMode) {
                logLevel = Level.ALL.intValue();
            }
        }
        if (level.intValue() >= logLevel) {
            if (level.intValue() <= Level.INFO.intValue()) {
                System.out.println(b.toString());
            } else {
                System.err.println(b.toString());
            }
        }
    }

    private void makeClassFinal(JDefinedClass clazz) {
        clazz.mods().setFinal(true);
    }

    private void makePropertiesPrivate(JDefinedClass clazz) {
        for (JFieldVar field : clazz.fields().values()) {
            field.mods().setPrivate();
        }
    }

    private void makePropertiesFinal(JDefinedClass clazz) {
        for (JFieldVar field : clazz.fields().values()) {
            field.mods().setFinal(true);
        }
    }

    private void removeSetters(JDefinedClass clazz) {
        Collection methods = clazz.methods();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            JMethod method = (JMethod)it.next();
            String methodName = method.name();
            if (!methodName.startsWith(SET_PREFIX) && !methodName.startsWith(UNSET_PREFIX)) continue;
            it.remove();
        }
    }

    private FieldOutline[] getSuperclassFields(ClassOutline clazz) {
        ArrayList<ClassOutline> superclasses = new ArrayList<ClassOutline>();
        for (ClassOutline superclass = clazz.getSuperClass(); superclass != null; superclass = superclass.getSuperClass()) {
            superclasses.add(superclass);
        }
        ArrayList<FieldOutline> superclassFields = new ArrayList<FieldOutline>();
        Collections.reverse(superclasses);
        for (ClassOutline classOutline : superclasses) {
            superclassFields.addAll(Arrays.asList(classOutline.getDeclaredFields()));
        }
        return superclassFields.toArray(new FieldOutline[0]);
    }
}

