/*
 * Decompiled with CFR 0.152.
 */
package com.github.sabomichal.immutablexjc;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.beans.Introspector;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.xml.sax.ErrorHandler;

public final class PluginImpl
extends Plugin {
    private static final String BUILDER_OPTION_NAME = "-imm-builder";
    private static final String CCONSTRUCTOR_OPTION_NAME = "-imm-cc";
    private static final String UNSET_PREFIX = "unset";
    private static final String SET_PREFIX = "set";
    private static final String MESSAGE_PREFIX = "IMMUTABLE-XJC";
    private static final String OPTION_NAME = "immutable";
    private static final JType[] NO_ARGS = new JType[0];
    private ResourceBundle resourceBundle = ResourceBundle.getBundle(PluginImpl.class.getCanonicalName());
    private boolean createBuilder;
    private boolean createCConstructor;
    private Options options;

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) {
        boolean success = true;
        this.options = options;
        this.log(Level.INFO, "title", new Object[0]);
        for (ClassOutline clazz : model.getClasses()) {
            FieldOutline[] superclassFields;
            int superclassFieldsLength;
            JDefinedClass implClass = clazz.implClass;
            FieldOutline[] declaredFields = clazz.getDeclaredFields();
            int declaredFieldsLength = declaredFields != null ? declaredFields.length : 0;
            if (declaredFieldsLength + (superclassFieldsLength = (superclassFields = this.getSuperclassFields(clazz)).length) > 0 && this.addStandardConstructor(implClass, declaredFields, superclassFields) == null) {
                this.log(Level.WARNING, "couldNotAddStdCtor", implClass.binaryName());
            }
            if (declaredFieldsLength + superclassFieldsLength > 0 && this.addPropertyContructor(implClass, declaredFields, superclassFields) == null) {
                this.log(Level.WARNING, "couldNotAddPropertyCtor", implClass.binaryName());
            }
            this.makeClassFinal(implClass);
            this.removeSetters(implClass);
            this.makePropertiesPrivate(implClass);
            this.makePropertiesFinal(implClass);
            if (!this.createBuilder || clazz.implClass.isAbstract()) continue;
            JDefinedClass builderClass = this.addBuilderClass(clazz, declaredFields, superclassFields);
            if (builderClass == null) {
                this.log(Level.WARNING, "couldNotAddClassBuilder", implClass.binaryName());
            }
            if (!this.createCConstructor || builderClass == null || this.addCopyConstructor(clazz.implClass, builderClass, declaredFields, superclassFields) != null) continue;
            this.log(Level.WARNING, "couldNotAddCopyCtor", implClass.binaryName());
        }
        for (ClassOutline clazz : model.getClasses()) {
            if (clazz.getSuperClass() != null) {
                clazz.getSuperClass().implClass.mods().setFinal(false);
                continue;
            }
            if (!clazz.implClass.isAbstract()) continue;
            clazz.implClass.mods().setFinal(false);
        }
        this.options = null;
        return success;
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        String n = System.getProperty("line.separator", "\n");
        return "  -immutable  :  " + this.getMessage("usage", new Object[0]) + n + "  " + BUILDER_OPTION_NAME + "       :  " + this.getMessage("builderUsage", new Object[0]) + n + "  " + CCONSTRUCTOR_OPTION_NAME + "       :  " + this.getMessage("cConstructorUsage", new Object[0]) + n;
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        if (args[i].startsWith(BUILDER_OPTION_NAME)) {
            this.createBuilder = true;
            return 1;
        }
        if (args[i].startsWith(CCONSTRUCTOR_OPTION_NAME)) {
            this.createCConstructor = true;
            return 1;
        }
        return 0;
    }

    private String getMessage(String key, Object ... args) {
        return MessageFormat.format(this.resourceBundle.getString(key), args);
    }

    private JDefinedClass addBuilderClass(ClassOutline clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JDefinedClass builderClass = this.generateBuilderClass(clazz.implClass);
        if (builderClass == null) {
            return null;
        }
        for (FieldOutline field : declaredFields) {
            this.addProperty(builderClass, field);
            this.addWithMethod(builderClass, field);
            if (!field.getPropertyInfo().isCollection()) continue;
            this.addAddMethod(builderClass, field);
        }
        for (FieldOutline field : superclassFields) {
            this.addProperty(builderClass, field);
            this.addWithMethod(builderClass, field);
            if (!field.getPropertyInfo().isCollection()) continue;
            this.addAddMethod(builderClass, field);
        }
        this.addNewBuilder(clazz, builderClass);
        if (this.createCConstructor) {
            this.addNewBuilderCc(clazz, builderClass);
        }
        this.addBuildMethod(clazz.implClass, builderClass, declaredFields, superclassFields);
        return builderClass;
    }

    private JVar addProperty(JDefinedClass clazz, FieldOutline field) {
        JType jType = this.getJavaType(field);
        if (field.getPropertyInfo().isCollection()) {
            return clazz.field(4, jType, field.getPropertyInfo().getName(false), this.getNewCollectionExpression(field.parent().implClass.owner(), jType));
        }
        return clazz.field(4, jType, field.getPropertyInfo().getName(false));
    }

    private JMethod addBuildMethod(JDefinedClass clazz, JDefinedClass builderClass, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod method = builderClass.method(1, (JType)clazz, "build");
        JInvocation constructorInvocation = JExpr._new((JClass)clazz);
        for (FieldOutline field : superclassFields) {
            constructorInvocation.arg((JExpression)JExpr.ref((String)field.getPropertyInfo().getName(false)));
        }
        for (FieldOutline field : declaredFields) {
            constructorInvocation.arg((JExpression)JExpr.ref((String)field.getPropertyInfo().getName(false)));
        }
        method.body()._return((JExpression)constructorInvocation);
        return method;
    }

    private void addNewBuilder(ClassOutline clazz, JDefinedClass builderClass) {
        boolean superClassWithSameName = false;
        for (ClassOutline superclass = clazz.getSuperClass(); superclass != null; superclass = superclass.getSuperClass()) {
            if (!superclass.implClass.name().equals(clazz.implClass.name())) continue;
            superClassWithSameName = true;
        }
        if (!superClassWithSameName) {
            JMethod method = clazz.implClass.method(17, (JType)builderClass, Introspector.decapitalize(clazz.implClass.name()) + "Builder");
            method.body()._return((JExpression)JExpr._new((JClass)builderClass));
        }
    }

    private void addNewBuilderCc(ClassOutline clazz, JDefinedClass builderClass) {
        boolean superClassWithSameName = false;
        for (ClassOutline superclass = clazz.getSuperClass(); superclass != null; superclass = superclass.getSuperClass()) {
            if (!superclass.implClass.name().equals(clazz.implClass.name())) continue;
            superClassWithSameName = true;
        }
        if (!superClassWithSameName) {
            JMethod method = clazz.implClass.method(17, (JType)builderClass, Introspector.decapitalize(clazz.implClass.name()) + "Builder");
            JVar param = method.param(8, (JType)clazz.implClass, "o");
            method.body()._return((JExpression)JExpr._new((JClass)builderClass).arg((JExpression)param));
        }
    }

    private Object addPropertyContructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = clazz.getConstructor(this.getFieldTypes(declaredFields, superclassFields));
        if (ctor == null) {
            ctor = this.generatePropertyConstructor(clazz, declaredFields, superclassFields);
        } else {
            this.log(Level.WARNING, "standardCtorExists", new Object[0]);
        }
        return ctor;
    }

    private JMethod addStandardConstructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = clazz.getConstructor(NO_ARGS);
        if (ctor == null) {
            ctor = this.generateStandardConstructor(clazz, declaredFields, superclassFields);
        } else {
            this.log(Level.WARNING, "standardCtorExists", new Object[0]);
        }
        return ctor;
    }

    private JMethod addCopyConstructor(JDefinedClass clazz, JDefinedClass builderClass, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = this.generateCopyConstructor(clazz, builderClass, declaredFields, superclassFields);
        if (ctor != null) {
            this.createConstructor(builderClass, 1);
        }
        return ctor;
    }

    private JMethod addWithMethod(JDefinedClass builderClass, FieldOutline field) {
        String fieldName = field.getPropertyInfo().getName(true);
        JMethod method = builderClass.method(1, (JType)builderClass, "with" + fieldName);
        this.generatePropertyAssignment(method, field);
        method.body()._return(JExpr.direct((String)"this"));
        return method;
    }

    private JMethod addAddMethod(JDefinedClass builderClass, FieldOutline field) {
        List typeParams = ((JClass)this.getJavaType(field)).getTypeParameters();
        if (!typeParams.iterator().hasNext()) {
            return null;
        }
        JMethod method = builderClass.method(1, (JType)builderClass, "add" + field.getPropertyInfo().getName(true));
        JBlock block = method.body();
        String fieldName = field.getPropertyInfo().getName(false);
        JVar param = method.param(8, (JType)typeParams.iterator().next(), fieldName);
        JInvocation invocation = JExpr.refthis((String)fieldName).invoke("add").arg((JExpression)param);
        block.add((JStatement)invocation);
        block._return(JExpr.direct((String)"this"));
        return method;
    }

    private JDefinedClass generateBuilderClass(JDefinedClass clazz) {
        JDefinedClass builderClass = null;
        String builderClassName = clazz.name() + "Builder";
        try {
            builderClass = clazz._class(17, builderClassName);
        }
        catch (JClassAlreadyExistsException e) {
            this.log(Level.WARNING, "builderClassExists", builderClassName);
        }
        return builderClass;
    }

    private void replaceCollectionGetter(FieldOutline field, JMethod getter) {
        JDefinedClass clazz = field.parent().implClass;
        clazz.methods().remove(getter);
        JMethod newGetter = field.parent().implClass.method(getter.mods().getValue(), getter.type(), getter.name());
        JBlock block = newGetter.body();
        JVar ret = block.decl(this.getJavaType(field), "ret");
        JCodeModel codeModel = field.parent().implClass.owner();
        JVar param = this.generateMethodParameter(getter, field);
        JConditional conditional = block._if(param.eq(JExpr._null()));
        conditional._then().assign((JAssignmentTarget)ret, this.getEmptyCollectionExpression(codeModel, param));
        conditional._else().assign((JAssignmentTarget)ret, this.getUnmodifiableWrappedExpression(codeModel, param));
        block._return((JExpression)ret);
        getter.javadoc().append((Object)"Returns unmodifiable collection.");
    }

    private void generatePropertyAssignment(JMethod method, FieldOutline fieldOutline) {
        this.generatePropertyAssignment(method, fieldOutline, false);
    }

    private void generatePropertyAssignment(JMethod method, FieldOutline fieldOutline, boolean wrapUnmodifiable) {
        JBlock block = method.body();
        JCodeModel codeModel = fieldOutline.parent().implClass.owner();
        String fieldName = fieldOutline.getPropertyInfo().getName(false);
        JVar param = this.generateMethodParameter(method, fieldOutline);
        if (fieldOutline.getPropertyInfo().isCollection()) {
            if (wrapUnmodifiable) {
                JConditional conditional = block._if(param.eq(JExpr._null()));
                conditional._then().assign((JAssignmentTarget)JExpr.refthis((String)fieldName), JExpr._null());
                conditional._else().assign((JAssignmentTarget)JExpr.refthis((String)fieldName), this.getDefensiveCopyExpression(codeModel, this.getJavaType(fieldOutline), param));
            } else {
                block.assign((JAssignmentTarget)JExpr.refthis((String)fieldName), (JExpression)JExpr.ref((String)fieldName));
            }
            this.replaceCollectionGetter(fieldOutline, this.getGetterProperty(fieldOutline));
        } else {
            block.assign((JAssignmentTarget)JExpr.refthis((String)fieldName), (JExpression)JExpr.ref((String)fieldName));
        }
    }

    private JVar generateMethodParameter(JMethod method, FieldOutline fieldOutline) {
        String fieldName = fieldOutline.getPropertyInfo().getName(false);
        JType javaType = this.getJavaType(fieldOutline);
        return method.param(8, javaType, fieldName);
    }

    private JExpression getDefensiveCopyExpression(JCodeModel codeModel, JType jType, JVar param) {
        List typeParams = ((JClass)jType).getTypeParameters();
        JClass typeParameter = null;
        if (typeParams.iterator().hasNext()) {
            typeParameter = (JClass)typeParams.iterator().next();
        }
        JClass newClass = null;
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (param.type().erasure().equals(codeModel.ref(List.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            newClass = codeModel.ref(HashMap.class);
        } else if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            newClass = codeModel.ref(HashSet.class);
        } else if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            newClass = codeModel.ref(TreeMap.class);
        } else if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            newClass = codeModel.ref(TreeSet.class);
        }
        if (newClass != null && typeParameter != null) {
            newClass = newClass.narrow(typeParameter);
        }
        return newClass == null ? JExpr._null() : JExpr._new((JClass)newClass).arg((JExpression)param);
    }

    private JExpression getUnmodifiableWrappedExpression(JCodeModel codeModel, JVar param) {
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableCollection").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(List.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableList").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableMap").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSet").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSortedMap").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSortedSet").arg((JExpression)param);
        }
        return param;
    }

    private JExpression getEmptyCollectionExpression(JCodeModel codeModel, JVar param) {
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyList");
        }
        if (param.type().erasure().equals(codeModel.ref(List.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyList");
        }
        if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyMap");
        }
        if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptySet");
        }
        if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            return JExpr._new((JClass)codeModel.ref(TreeMap.class));
        }
        if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            return JExpr._new((JClass)codeModel.ref(TreeSet.class));
        }
        return param;
    }

    private JExpression getNewCollectionExpression(JCodeModel codeModel, JType jType) {
        List typeParams = ((JClass)jType).getTypeParameters();
        JClass typeParameter = null;
        if (typeParams.iterator().hasNext()) {
            typeParameter = (JClass)typeParams.iterator().next();
        }
        JClass newClass = null;
        if (jType.erasure().equals(codeModel.ref(Collection.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (jType.erasure().equals(codeModel.ref(List.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (jType.erasure().equals(codeModel.ref(Map.class))) {
            newClass = codeModel.ref(HashMap.class);
        } else if (jType.erasure().equals(codeModel.ref(Set.class))) {
            newClass = codeModel.ref(HashSet.class);
        } else if (jType.erasure().equals(codeModel.ref(SortedMap.class))) {
            newClass = codeModel.ref(TreeMap.class);
        } else if (jType.erasure().equals(codeModel.ref(SortedSet.class))) {
            newClass = codeModel.ref(TreeSet.class);
        }
        if (newClass != null && typeParameter != null) {
            newClass = newClass.narrow(typeParameter);
        }
        return newClass == null ? JExpr._null() : JExpr._new((JClass)newClass);
    }

    private void generateDefaultPropertyAssignment(JMethod method, FieldOutline fieldOutline) {
        JBlock block = method.body();
        String propertyName = fieldOutline.getPropertyInfo().getName(false);
        block.assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.defaultValue(this.getJavaType(fieldOutline), fieldOutline));
    }

    private JExpression defaultValue(JType javaType, FieldOutline fieldOutline) {
        if (javaType.isPrimitive()) {
            if (fieldOutline.parent().parent().getCodeModel().BOOLEAN.equals(javaType)) {
                return JExpr.lit((boolean)false);
            }
            if (fieldOutline.parent().parent().getCodeModel().SHORT.equals(javaType)) {
                return JExpr.cast((JType)fieldOutline.parent().parent().getCodeModel().SHORT, (JExpression)JExpr.lit((int)0));
            }
            return JExpr.lit((int)0);
        }
        return JExpr._null();
    }

    private JMethod generatePropertyConstructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = this.createConstructor(clazz, 1);
        if (superclassFields.length > 0) {
            JInvocation superInvocation = ctor.body().invoke("super");
            FieldOutline[] fieldOutlineArray = superclassFields;
            int n = fieldOutlineArray.length;
            for (int i = 0; i < n; ++i) {
                FieldOutline fieldOutline = fieldOutlineArray[i];
                superInvocation.arg((JExpression)JExpr.ref((String)fieldOutline.getPropertyInfo().getName(false)));
                this.generateMethodParameter(ctor, fieldOutline);
            }
        }
        for (FieldOutline fieldOutline : declaredFields) {
            this.generatePropertyAssignment(ctor, fieldOutline, true);
        }
        return ctor;
    }

    private JMethod generateStandardConstructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = this.createConstructor(clazz, 2);
        ctor.javadoc().add((Object)"Used by JAX-B");
        if (superclassFields.length > 0) {
            JInvocation superInvocation = ctor.body().invoke("super");
            FieldOutline[] fieldOutlineArray = superclassFields;
            int n = fieldOutlineArray.length;
            for (int i = 0; i < n; ++i) {
                FieldOutline fieldOutline = fieldOutlineArray[i];
                superInvocation.arg(this.defaultValue(this.getJavaType(fieldOutline), fieldOutline));
            }
        }
        for (FieldOutline fieldOutline : declaredFields) {
            this.generateDefaultPropertyAssignment(ctor, fieldOutline);
        }
        return ctor;
    }

    private JMethod generateCopyConstructor(JDefinedClass clazz, JDefinedClass builderClass, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        String propertyName;
        JMethod ctor = this.createConstructor(builderClass, 1);
        JVar o = ctor.param(8, (JType)clazz, "o");
        ctor.body()._if(o.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)builderClass.owner().ref(NullPointerException.class)).arg("Cannot create a copy of '" + builderClass.name() + "' from 'null'."));
        JCodeModel codeModel = clazz.owner();
        for (FieldOutline field : superclassFields) {
            propertyName = field.getPropertyInfo().getName(false);
            JMethod getter = this.getPropertyGetter(field);
            if (field.getPropertyInfo().isCollection()) {
                JVar tmpVar = ctor.body().decl(0, this.getJavaType(field), "_" + propertyName, (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter));
                JConditional conditional = ctor.body()._if(tmpVar.eq(JExpr._null()));
                conditional._then().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getNewCollectionExpression(codeModel, this.getJavaType(field)));
                conditional._else().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getDefensiveCopyExpression(codeModel, this.getJavaType(field), tmpVar));
                continue;
            }
            ctor.body().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter));
        }
        for (FieldOutline field : declaredFields) {
            propertyName = field.getPropertyInfo().getName(false);
            if (field.getPropertyInfo().isCollection()) {
                JVar tmpVar = ctor.body().decl(0, this.getJavaType(field), "_" + propertyName, (JExpression)JExpr.ref((JExpression)o, (String)propertyName));
                JConditional conditional = ctor.body()._if(tmpVar.eq(JExpr._null()));
                conditional._then().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getNewCollectionExpression(codeModel, this.getJavaType(field)));
                conditional._else().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getDefensiveCopyExpression(codeModel, this.getJavaType(field), tmpVar));
                continue;
            }
            ctor.body().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), (JExpression)JExpr.ref((JExpression)o, (String)propertyName));
        }
        return ctor;
    }

    private JMethod getPropertyGetter(FieldOutline f) {
        JDefinedClass clazz = f.parent().implClass;
        String name = f.getPropertyInfo().getName(true);
        JMethod getter = clazz.getMethod("get" + name, NO_ARGS);
        if (getter == null) {
            getter = clazz.getMethod("is" + name, NO_ARGS);
        }
        return getter;
    }

    private JMethod createConstructor(JDefinedClass clazz, int visibility) {
        return clazz.constructor(visibility);
    }

    private JType getJavaType(FieldOutline field) {
        return field.getRawType();
    }

    private JType[] getFieldTypes(FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JType[] fieldTypes = new JType[declaredFields.length + superclassFields.length];
        int i = 0;
        for (FieldOutline fieldOutline : superclassFields) {
            fieldTypes[i++] = fieldOutline.getPropertyInfo().baseType;
        }
        for (FieldOutline fieldOutline : declaredFields) {
            fieldTypes[i++] = fieldOutline.getPropertyInfo().baseType;
        }
        return fieldTypes;
    }

    private JMethod getGetterProperty(FieldOutline fieldOutline) {
        JDefinedClass clazz = fieldOutline.parent().implClass;
        String name = fieldOutline.getPropertyInfo().getName(true);
        JMethod getter = clazz.getMethod("get" + name, NO_ARGS);
        if (getter == null) {
            getter = clazz.getMethod("is" + name, NO_ARGS);
        }
        return getter;
    }

    private void log(Level level, String key, Object ... args) {
        String message = "[IMMUTABLE-XJC] [" + level.getLocalizedName() + "] " + this.getMessage(key, args);
        int logLevel = Level.WARNING.intValue();
        if (this.options != null && !this.options.quiet) {
            if (this.options.verbose) {
                logLevel = Level.INFO.intValue();
            }
            if (this.options.debugMode) {
                logLevel = Level.ALL.intValue();
            }
        }
        if (level.intValue() >= logLevel) {
            if (level.intValue() <= Level.INFO.intValue()) {
                System.out.println(message);
            } else {
                System.err.println(message);
            }
        }
    }

    private void makeClassFinal(JDefinedClass clazz) {
        clazz.mods().setFinal(true);
    }

    private void makePropertiesPrivate(JDefinedClass clazz) {
        for (JFieldVar field : clazz.fields().values()) {
            field.mods().setPrivate();
        }
    }

    private void makePropertiesFinal(JDefinedClass clazz) {
        for (JFieldVar field : clazz.fields().values()) {
            field.mods().setFinal(true);
        }
    }

    private void removeSetters(JDefinedClass clazz) {
        Collection methods = clazz.methods();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            JMethod method = (JMethod)it.next();
            String methodName = method.name();
            if (!methodName.startsWith(SET_PREFIX) && !methodName.startsWith(UNSET_PREFIX)) continue;
            it.remove();
        }
    }

    private FieldOutline[] getSuperclassFields(ClassOutline clazz) {
        ArrayList<ClassOutline> superclasses = new ArrayList<ClassOutline>();
        for (ClassOutline superclass = clazz.getSuperClass(); superclass != null; superclass = superclass.getSuperClass()) {
            superclasses.add(superclass);
        }
        ArrayList<FieldOutline> superclassFields = new ArrayList<FieldOutline>();
        Collections.reverse(superclasses);
        for (ClassOutline classOutline : superclasses) {
            superclassFields.addAll(Arrays.asList(classOutline.getDeclaredFields()));
        }
        return superclassFields.toArray(new FieldOutline[superclassFields.size()]);
    }
}

