/*
 * Decompiled with CFR 0.152.
 */
package com.github.sabomichal.immutablexjc;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAnnotationValue;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.beans.Introspector;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.xml.sax.ErrorHandler;

public final class PluginImpl
extends Plugin {
    private static final String BUILDER_OPTION_NAME = "-imm-builder";
    private static final String SIMPLEBUILDERNAME_OPTION_NAME = "-imm-simplebuildername";
    private static final String INHERIT_BUILDER_OPTION_NAME = "-imm-inheritbuilder";
    private static final String CCONSTRUCTOR_OPTION_NAME = "-imm-cc";
    private static final String WITHIFNOTNULL_OPTION_NAME = "-imm-ifnotnull";
    private static final String NOPUBLICCONSTRUCTOR_OPTION_NAME = "-imm-nopubconstructor";
    private static final String PUBLICCONSTRUCTOR_MAXARGS_OPTION_NAME = "-imm-pubconstructormaxargs";
    private static final String SKIPCOLLECTIONS_OPTION_NAME = "-imm-skipcollections";
    private static final String CONSTRUCTORDEFAULTS_OPTION_NAME = "-imm-constructordefaults";
    private static final String OPTIONAL_GETTER_OPTION_NAME = "-imm-optionalgetter";
    private static final String UNSET_PREFIX = "unset";
    private static final String SET_PREFIX = "set";
    private static final String MESSAGE_PREFIX = "IMMUTABLE-XJC";
    private static final String OPTION_NAME = "immutable";
    private static final JType[] NO_ARGS = new JType[0];
    private ResourceBundle resourceBundle = ResourceBundle.getBundle(PluginImpl.class.getCanonicalName());
    private boolean createBuilder;
    private boolean builderInheritance;
    private boolean createCConstructor;
    private boolean createWithIfNotNullMethod;
    private boolean createBuilderWithoutPublicConstructor;
    private int publicConstructorMaxArgs = Integer.MAX_VALUE;
    private boolean leaveCollectionsMutable;
    private boolean setDefaultValuesInConstructor;
    private boolean useSimpleBuilderName;
    private boolean optionalGetter;
    private Options options;

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) {
        boolean success = true;
        this.options = options;
        this.log(Level.INFO, "title", new Object[0]);
        ArrayList<ClassOutline> classes = new ArrayList<ClassOutline>(model.getClasses());
        if (this.builderInheritance) {
            classes.sort(new Comparator<ClassOutline>(){

                @Override
                public int compare(ClassOutline o1, ClassOutline o2) {
                    return Integer.compare(this.getDepth(o1), this.getDepth(o2));
                }

                private int getDepth(ClassOutline outline) {
                    int depth = 0;
                    while ((outline = outline.getSuperClass()) != null) {
                        ++depth;
                    }
                    return depth;
                }
            });
        }
        for (ClassOutline clazz : classes) {
            int mod;
            JDefinedClass implClass = clazz.implClass;
            JFieldVar[] declaredFields = this.getDeclaredFields(implClass);
            ClassField[] superclassFieldsWithOwners = this.getSuperclassFields(implClass);
            JFieldVar[] superclassFields = (JFieldVar[])Arrays.stream(superclassFieldsWithOwners).map(ClassField::getField).toArray(JFieldVar[]::new);
            this.makePropertiesPrivate(implClass);
            this.makePropertiesFinal(implClass, declaredFields);
            int declaredFieldsLength = declaredFields.length;
            int superclassFieldsLength = superclassFields.length;
            JMethod propertyContructor = null;
            if (declaredFieldsLength + superclassFieldsLength > 0 && (propertyContructor = this.addPropertyContructor(implClass, declaredFields, superclassFields, mod = this.createBuilderWithoutPublicConstructor || this.createBuilder && declaredFieldsLength + superclassFieldsLength > this.publicConstructorMaxArgs ? 0 : 1)) == null) {
                this.log(Level.WARNING, "couldNotAddPropertyCtor", implClass.binaryName());
            }
            if (propertyContructor == null || !propertyContructor.params().isEmpty()) {
                this.addStandardConstructor(implClass, declaredFields, superclassFields);
            }
            this.makeClassFinal(implClass);
            this.removeSetters(implClass);
            this.replaceCollectionGetters(implClass, declaredFields);
            if (this.optionalGetter) {
                this.replaceOptionalGetters(implClass, declaredFields);
            }
            if (!this.createBuilder || clazz.implClass.isAbstract()) continue;
            JFieldVar[] unhandledSuperclassFields = this.getUnhandledSuperclassFields(superclassFieldsWithOwners);
            JDefinedClass builderClass = this.addBuilderClass(clazz, declaredFields, unhandledSuperclassFields, superclassFields);
            if (builderClass == null) {
                this.log(Level.WARNING, "couldNotAddClassBuilder", implClass.binaryName());
            }
            if (!this.createCConstructor || builderClass == null) continue;
            this.addCopyConstructor(clazz.implClass, builderClass, declaredFields, unhandledSuperclassFields);
        }
        for (ClassOutline clazz : model.getClasses()) {
            if (clazz.getSuperClass() != null) {
                clazz.getSuperClass().implClass.mods().setFinal(false);
                continue;
            }
            if (!clazz.implClass.isAbstract()) continue;
            clazz.implClass.mods().setFinal(false);
        }
        this.options = null;
        return success;
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        String n = System.getProperty("line.separator", "\n");
        int maxOptionLength = PUBLICCONSTRUCTOR_MAXARGS_OPTION_NAME.length();
        StringBuilder retval = new StringBuilder();
        this.appendOption(retval, "-immutable", this.getMessage("usage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, BUILDER_OPTION_NAME, this.getMessage("builderUsage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, SIMPLEBUILDERNAME_OPTION_NAME, this.getMessage("simpleBuilderNameUsage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, INHERIT_BUILDER_OPTION_NAME, this.getMessage("inheritBuilderUsage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, CCONSTRUCTOR_OPTION_NAME, this.getMessage("cConstructorUsage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, WITHIFNOTNULL_OPTION_NAME, this.getMessage("withIfNotNullUsage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, NOPUBLICCONSTRUCTOR_OPTION_NAME, this.getMessage("builderWithoutPublicConstructor", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, SKIPCOLLECTIONS_OPTION_NAME, this.getMessage("leaveCollectionsMutable", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, PUBLICCONSTRUCTOR_MAXARGS_OPTION_NAME, this.getMessage("publicConstructorMaxArgs", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, CONSTRUCTORDEFAULTS_OPTION_NAME, this.getMessage("setDefaultValuesInConstructor", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, OPTIONAL_GETTER_OPTION_NAME, this.getMessage("optionalGetterUsage", new Object[0]), n, maxOptionLength);
        return retval.toString();
    }

    private void appendOption(StringBuilder retval, String option, String description, String n, int optionColumnWidth) {
        retval.append("  ");
        retval.append(option);
        for (int i = option.length(); i < optionColumnWidth; ++i) {
            retval.append(' ');
        }
        retval.append(" :  ");
        retval.append(description);
        retval.append(n);
    }

    public int parseArgument(Options opt, String[] args, int i) {
        if (args[i].startsWith(BUILDER_OPTION_NAME)) {
            this.createBuilder = true;
            return 1;
        }
        if (args[i].startsWith(SIMPLEBUILDERNAME_OPTION_NAME)) {
            this.useSimpleBuilderName = true;
            return 1;
        }
        if (args[i].startsWith(INHERIT_BUILDER_OPTION_NAME)) {
            this.createBuilder = true;
            this.builderInheritance = true;
            return 1;
        }
        if (args[i].startsWith(CCONSTRUCTOR_OPTION_NAME)) {
            this.createCConstructor = true;
            return 1;
        }
        if (args[i].startsWith(WITHIFNOTNULL_OPTION_NAME)) {
            this.createWithIfNotNullMethod = true;
            return 1;
        }
        if (args[i].startsWith(NOPUBLICCONSTRUCTOR_OPTION_NAME)) {
            this.createBuilderWithoutPublicConstructor = true;
            return 1;
        }
        if (args[i].startsWith(SKIPCOLLECTIONS_OPTION_NAME)) {
            this.leaveCollectionsMutable = true;
            return 1;
        }
        if (args[i].startsWith(PUBLICCONSTRUCTOR_MAXARGS_OPTION_NAME)) {
            this.publicConstructorMaxArgs = Integer.parseInt(args[i].substring(PUBLICCONSTRUCTOR_MAXARGS_OPTION_NAME.length() + 1));
            return 1;
        }
        if (args[i].startsWith(CONSTRUCTORDEFAULTS_OPTION_NAME)) {
            this.setDefaultValuesInConstructor = true;
            return 1;
        }
        if (args[i].startsWith(OPTIONAL_GETTER_OPTION_NAME)) {
            this.optionalGetter = true;
            return 1;
        }
        return 0;
    }

    private String getMessage(String key, Object ... args) {
        return MessageFormat.format(this.resourceBundle.getString(key), args);
    }

    private JDefinedClass addBuilderClass(ClassOutline clazz, JFieldVar[] declaredFields, JFieldVar[] unhandledSuperclassFields, JFieldVar[] allSuperclassFields) {
        JDefinedClass builderClass = this.generateBuilderClass(clazz.implClass);
        if (builderClass == null) {
            return null;
        }
        this.addBuilderMethodsForFields(builderClass, declaredFields);
        this.addBuilderMethodsForFields(builderClass, unhandledSuperclassFields);
        if (this.builderInheritance) {
            for (int i = 0; i < allSuperclassFields.length - unhandledSuperclassFields.length; ++i) {
                JFieldVar inheritedField = allSuperclassFields[i];
                JMethod unconditionalWithMethod = this.addWithMethod(builderClass, inheritedField, true);
                if (this.createWithIfNotNullMethod) {
                    this.addWithIfNotNullMethod(builderClass, inheritedField, unconditionalWithMethod, true);
                }
                if (!this.isCollection(inheritedField)) continue;
                this.addAddMethod(builderClass, inheritedField, true);
            }
        }
        this.addNewBuilder(clazz, builderClass);
        if (this.createCConstructor) {
            this.addNewBuilderCc(clazz, builderClass);
        }
        this.addBuildMethod(clazz.implClass, builderClass, declaredFields, allSuperclassFields);
        return builderClass;
    }

    private void addBuilderMethodsForFields(JDefinedClass builderClass, JFieldVar[] declaredFields) {
        for (JFieldVar field : declaredFields) {
            this.addProperty(builderClass, field);
            JMethod unconditionalWithMethod = this.addWithMethod(builderClass, field, false);
            if (this.createWithIfNotNullMethod) {
                this.addWithIfNotNullMethod(builderClass, field, unconditionalWithMethod, false);
            }
            if (!this.isCollection(field)) continue;
            this.addAddMethod(builderClass, field, false);
        }
    }

    private JVar addProperty(JDefinedClass clazz, JFieldVar field) {
        int builderFieldVisibility;
        JType jType = this.getJavaType(field);
        int n = builderFieldVisibility = this.builderInheritance ? 2 : 4;
        if (this.isCollection(field)) {
            return clazz.field(builderFieldVisibility, jType, field.name(), this.getNewCollectionExpression(field.type().owner(), jType));
        }
        return clazz.field(builderFieldVisibility, jType, field.name());
    }

    private JMethod addBuildMethod(JDefinedClass clazz, JDefinedClass builderClass, JFieldVar[] declaredFields, JFieldVar[] superclassFields) {
        JMethod method = builderClass.method(1, (JType)clazz, "build");
        if (this.hasSuperClass(builderClass)) {
            method.annotate(Override.class);
        }
        JInvocation constructorInvocation = JExpr._new((JClass)clazz);
        for (JFieldVar field : superclassFields) {
            if (!this.mustAssign(field)) continue;
            constructorInvocation.arg((JExpression)JExpr.ref((String)field.name()));
        }
        for (JFieldVar field : declaredFields) {
            if (!this.mustAssign(field)) continue;
            constructorInvocation.arg((JExpression)JExpr.ref((String)field.name()));
        }
        method.body()._return((JExpression)constructorInvocation);
        return method;
    }

    private void addNewBuilder(ClassOutline clazz, JDefinedClass builderClass) {
        if (this.builderInheritance || !this.hasSuperClassWithSameName(clazz)) {
            String builderMethodName = this.generateBuilderMethodName(clazz);
            JMethod method = clazz.implClass.method(17, (JType)builderClass, builderMethodName);
            method.body()._return((JExpression)JExpr._new((JClass)builderClass));
        }
    }

    private void addNewBuilderCc(ClassOutline clazz, JDefinedClass builderClass) {
        if (this.builderInheritance || !this.hasSuperClassWithSameName(clazz)) {
            String builderMethodName = this.generateBuilderMethodName(clazz);
            JMethod method = clazz.implClass.method(17, (JType)builderClass, builderMethodName);
            JVar param = method.param(8, (JType)clazz.implClass, "o");
            method.body()._return((JExpression)JExpr._new((JClass)builderClass).arg((JExpression)param));
        }
    }

    private String generateBuilderMethodName(ClassOutline clazz) {
        if (this.isUseSimpleBuilderName()) {
            return "builder";
        }
        return Introspector.decapitalize(clazz.implClass.name()) + "Builder";
    }

    private boolean isUseSimpleBuilderName() {
        return this.useSimpleBuilderName;
    }

    private boolean hasSuperClassWithSameName(ClassOutline clazz) {
        for (ClassOutline superclass = clazz.getSuperClass(); superclass != null; superclass = superclass.getSuperClass()) {
            if (!superclass.implClass.name().equals(clazz.implClass.name())) continue;
            return true;
        }
        return false;
    }

    private JMethod addPropertyContructor(JDefinedClass clazz, JFieldVar[] declaredFields, JFieldVar[] superclassFields, int constAccess) {
        JMethod ctor = clazz.getConstructor(this.getFieldTypes(declaredFields, superclassFields));
        if (ctor == null) {
            ctor = this.generatePropertyConstructor(clazz, declaredFields, superclassFields, constAccess);
        } else {
            this.log(Level.WARNING, "standardCtorExists", new Object[0]);
        }
        return ctor;
    }

    private JMethod addStandardConstructor(JDefinedClass clazz, JFieldVar[] declaredFields, JFieldVar[] superclassFields) {
        JMethod ctor = clazz.getConstructor(NO_ARGS);
        if (ctor == null) {
            ctor = this.generateStandardConstructor(clazz, declaredFields, superclassFields);
        } else {
            this.log(Level.WARNING, "standardCtorExists", new Object[0]);
        }
        return ctor;
    }

    private JMethod addCopyConstructor(JDefinedClass clazz, JDefinedClass builderClass, JFieldVar[] declaredFields, JFieldVar[] superclassFields) {
        JMethod ctor = this.generateCopyConstructor(clazz, builderClass, declaredFields, superclassFields);
        this.createConstructor(builderClass, 1);
        return ctor;
    }

    private JMethod addWithMethod(JDefinedClass builderClass, JFieldVar field, boolean inherit) {
        String fieldName = StringUtils.capitalize((String)field.name());
        JMethod method = builderClass.method(1, (JType)builderClass, "with" + fieldName);
        if (inherit) {
            this.generateMethodParameter(method, field);
            this.generateSuperCall(method);
        } else {
            this.generatePropertyAssignment(method, field);
        }
        method.body()._return(JExpr._this());
        return method;
    }

    private JMethod addWithIfNotNullMethod(JDefinedClass builderClass, JFieldVar field, JMethod unconditionalWithMethod, boolean inherit) {
        if (field.type().isPrimitive()) {
            return null;
        }
        String fieldName = StringUtils.capitalize((String)field.name());
        JMethod method = builderClass.method(1, (JType)builderClass, "with" + fieldName + "IfNotNull");
        JVar param = this.generateMethodParameter(method, field);
        JBlock block = method.body();
        if (inherit) {
            this.generateSuperCall(method);
            method.body()._return(JExpr._this());
        } else {
            JConditional conditional = block._if(param.eq(JExpr._null()));
            conditional._then()._return(JExpr._this());
            conditional._else()._return((JExpression)JExpr.invoke((JMethod)unconditionalWithMethod).arg((JExpression)param));
        }
        return method;
    }

    private JMethod addAddMethod(JDefinedClass builderClass, JFieldVar field, boolean inherit) {
        List typeParams = ((JClass)this.getJavaType(field)).getTypeParameters();
        if (!typeParams.iterator().hasNext()) {
            return null;
        }
        JMethod method = builderClass.method(1, (JType)builderClass, "add" + StringUtils.capitalize((String)field.name()));
        JBlock block = method.body();
        String fieldName = field.name();
        JVar param = method.param(8, (JType)typeParams.iterator().next(), fieldName);
        if (inherit) {
            this.generateSuperCall(method);
        } else {
            JInvocation invocation = JExpr.refthis((String)fieldName).invoke("add").arg((JExpression)param);
            block.add((JStatement)invocation);
        }
        block._return(JExpr._this());
        return method;
    }

    private void generateSuperCall(JMethod method) {
        method.annotate(Override.class);
        JBlock block = method.body();
        JInvocation superInvocation = block.invoke(JExpr._super(), method);
        for (JVar param : method.params()) {
            superInvocation.arg((JExpression)param);
        }
    }

    private JDefinedClass generateBuilderClass(JDefinedClass clazz) {
        JDefinedClass builderClass;
        block3: {
            builderClass = null;
            String builderClassName = this.getBuilderClassName((JClass)clazz);
            try {
                builderClass = clazz._class(17, builderClassName);
                if (!this.builderInheritance) break block3;
                for (JClass superClass = clazz._extends(); superClass != null; superClass = superClass._extends()) {
                    JClass superClassBuilderClass = this.getBuilderClass(superClass);
                    if (superClassBuilderClass == null) continue;
                    builderClass._extends(superClassBuilderClass);
                    break;
                }
            }
            catch (JClassAlreadyExistsException e) {
                this.log(Level.WARNING, "builderClassExists", builderClassName);
            }
        }
        return builderClass;
    }

    private String getBuilderClassName(JClass clazz) {
        if (this.isUseSimpleBuilderName()) {
            return "Builder";
        }
        return clazz.name() + "Builder";
    }

    private JClass getBuilderClass(JClass clazz) {
        if (!this.createBuilder || clazz.isAbstract()) {
            return null;
        }
        String builderClassName = this.getBuilderClassName(clazz);
        if (clazz instanceof JDefinedClass) {
            JDefinedClass definedClass = (JDefinedClass)clazz;
            Iterator i = definedClass.classes();
            while (i.hasNext()) {
                JDefinedClass innerClass = (JDefinedClass)i.next();
                if (!builderClassName.equals(innerClass.name())) continue;
                return innerClass;
            }
        }
        return null;
    }

    private void replaceOptionalGetters(JDefinedClass implClass, JFieldVar[] declaredFields) {
        for (JFieldVar field : declaredFields) {
            JMethod getterMethod;
            if (this.isCollection(field) || this.isRequired(field) || (getterMethod = this.getGetterProperty(field, implClass)) == null) continue;
            this.replaceOptionalGetter(implClass, field, getterMethod);
        }
    }

    private void replaceOptionalGetter(JDefinedClass ownerClass, JFieldVar field, JMethod getter) {
        ownerClass.methods().remove(getter);
        JCodeModel codeModel = field.type().owner();
        JClass optionalWrappedReturnType = codeModel.ref(Optional.class).narrow(field.type());
        JMethod newGetter = ownerClass.method(getter.mods().getValue(), (JType)optionalWrappedReturnType, getter.name());
        JBlock block = newGetter.body();
        JVar param = this.generateMethodParameter(getter, field);
        block._return(this.getOptionalWrappedExpression(codeModel, param));
        getter.javadoc().append((Object)"Returns optional attribute/element.");
    }

    private void replaceCollectionGetters(JDefinedClass implClass, JFieldVar[] declaredFields) {
        for (JFieldVar field : declaredFields) {
            JMethod getterMethod;
            if (!this.isCollection(field) || this.leaveCollectionsMutable || (getterMethod = this.getGetterProperty(field, implClass)) == null) continue;
            this.replaceCollectionGetter(implClass, field, getterMethod);
        }
    }

    private void replaceCollectionGetter(JDefinedClass ownerClass, JFieldVar field, JMethod getter) {
        ownerClass.methods().remove(getter);
        JMethod newGetter = ownerClass.method(getter.mods().getValue(), getter.type(), getter.name());
        JBlock block = newGetter.body();
        JVar ret = block.decl(this.getJavaType(field), "ret");
        JCodeModel codeModel = field.type().owner();
        JVar param = this.generateMethodParameter(getter, field);
        JConditional conditional = block._if(param.eq(JExpr._null()));
        conditional._then().assign((JAssignmentTarget)ret, this.getEmptyCollectionExpression(codeModel, param));
        conditional._else().assign((JAssignmentTarget)ret, this.getUnmodifiableWrappedExpression(codeModel, param));
        block._return((JExpression)ret);
        getter.javadoc().append((Object)"Returns unmodifiable collection.");
    }

    private void generatePropertyAssignment(JMethod method, JFieldVar field) {
        this.generatePropertyAssignment(method, field, false);
    }

    private void generatePropertyAssignment(JMethod method, JFieldVar field, boolean wrapUnmodifiable) {
        JBlock block = method.body();
        JCodeModel codeModel = field.type().owner();
        String fieldName = field.name();
        JVar param = this.generateMethodParameter(method, field);
        if (this.isCollection(field) && !this.leaveCollectionsMutable && wrapUnmodifiable) {
            JConditional conditional = block._if(param.eq(JExpr._null()));
            conditional._then().assign((JAssignmentTarget)JExpr.refthis((String)fieldName), JExpr._null());
            conditional._else().assign((JAssignmentTarget)JExpr.refthis((String)fieldName), this.getDefensiveCopyExpression(codeModel, this.getJavaType(field), param));
        } else {
            block.assign((JAssignmentTarget)JExpr.refthis((String)fieldName), (JExpression)JExpr.ref((String)fieldName));
        }
    }

    private JVar generateMethodParameter(JMethod method, JFieldVar field) {
        String fieldName = field.name();
        JType javaType = this.getJavaType(field);
        return method.param(8, javaType, fieldName);
    }

    private JExpression getDefensiveCopyExpression(JCodeModel codeModel, JType jType, JVar param) {
        List typeParams = ((JClass)jType).getTypeParameters();
        JClass typeParameter = null;
        if (typeParams.iterator().hasNext()) {
            typeParameter = (JClass)typeParams.iterator().next();
        }
        JClass newClass = null;
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (param.type().erasure().equals(codeModel.ref(List.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            newClass = codeModel.ref(HashMap.class);
        } else if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            newClass = codeModel.ref(HashSet.class);
        } else if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            newClass = codeModel.ref(TreeMap.class);
        } else if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            newClass = codeModel.ref(TreeSet.class);
        }
        if (newClass != null && typeParameter != null) {
            newClass = newClass.narrow(typeParameter);
        }
        return newClass == null ? JExpr._null() : JExpr._new((JClass)newClass).arg((JExpression)param);
    }

    private JExpression getUnmodifiableWrappedExpression(JCodeModel codeModel, JVar param) {
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableCollection").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(List.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableList").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableMap").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSet").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSortedMap").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSortedSet").arg((JExpression)param);
        }
        return param;
    }

    private JExpression getEmptyCollectionExpression(JCodeModel codeModel, JVar param) {
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyList");
        }
        if (param.type().erasure().equals(codeModel.ref(List.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyList");
        }
        if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyMap");
        }
        if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptySet");
        }
        if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            return JExpr._new((JClass)codeModel.ref(TreeMap.class));
        }
        if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            return JExpr._new((JClass)codeModel.ref(TreeSet.class));
        }
        return param;
    }

    private JExpression getNewCollectionExpression(JCodeModel codeModel, JType jType) {
        List typeParams = ((JClass)jType).getTypeParameters();
        JClass typeParameter = null;
        if (typeParams.iterator().hasNext()) {
            typeParameter = (JClass)typeParams.iterator().next();
        }
        JClass newClass = null;
        if (jType.erasure().equals(codeModel.ref(Collection.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (jType.erasure().equals(codeModel.ref(List.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (jType.erasure().equals(codeModel.ref(Map.class))) {
            newClass = codeModel.ref(HashMap.class);
        } else if (jType.erasure().equals(codeModel.ref(Set.class))) {
            newClass = codeModel.ref(HashSet.class);
        } else if (jType.erasure().equals(codeModel.ref(SortedMap.class))) {
            newClass = codeModel.ref(TreeMap.class);
        } else if (jType.erasure().equals(codeModel.ref(SortedSet.class))) {
            newClass = codeModel.ref(TreeSet.class);
        }
        if (newClass != null && typeParameter != null) {
            newClass = newClass.narrow(typeParameter);
        }
        return newClass == null ? JExpr._null() : JExpr._new((JClass)newClass);
    }

    private JExpression getOptionalWrappedExpression(JCodeModel codeModel, JVar param) {
        return codeModel.ref(Optional.class).staticInvoke("ofNullable").arg((JExpression)param);
    }

    private void generateDefaultPropertyAssignment(JMethod method, JFieldVar field) {
        JBlock block = method.body();
        String propertyName = field.name();
        block.assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.defaultValue(field));
    }

    private JExpression defaultValue(JFieldVar field) {
        JAnnotationValue annotationValue;
        Optional<JAnnotationUse> xmlElementAnnotation;
        JType javaType = field.type();
        if (this.setDefaultValuesInConstructor && (xmlElementAnnotation = this.getAnnotation(field.annotations(), XmlElement.class.getCanonicalName())).isPresent() && (annotationValue = (JAnnotationValue)xmlElementAnnotation.get().getAnnotationMembers().get("defaultValue")) != null) {
            StringWriter sw = new StringWriter();
            JFormatter f = new JFormatter((Writer)sw);
            annotationValue.generate(f);
            return JExpr.lit((String)sw.toString().replaceAll("\"", ""));
        }
        if (javaType.isPrimitive()) {
            if (field.type().owner().BOOLEAN.equals(javaType)) {
                return JExpr.lit((boolean)false);
            }
            if (javaType.owner().SHORT.equals(javaType)) {
                return JExpr.cast((JType)javaType.owner().SHORT, (JExpression)JExpr.lit((int)0));
            }
            return JExpr.lit((int)0);
        }
        return JExpr._null();
    }

    private Optional<JAnnotationUse> getAnnotation(Collection<JAnnotationUse> annotations, String clazz) {
        return annotations.stream().filter(ann -> ann.getAnnotationClass().fullName().equals(clazz)).findFirst();
    }

    private JMethod generatePropertyConstructor(JDefinedClass clazz, JFieldVar[] declaredFields, JFieldVar[] superclassFields, int constAccess) {
        JMethod ctor = this.createConstructor(clazz, constAccess);
        if (superclassFields.length > 0) {
            JInvocation superInvocation = ctor.body().invoke("super");
            JFieldVar[] jFieldVarArray = superclassFields;
            int n = jFieldVarArray.length;
            for (int i = 0; i < n; ++i) {
                JFieldVar field = jFieldVarArray[i];
                if (!this.mustAssign(field)) continue;
                superInvocation.arg((JExpression)JExpr.ref((String)field.name()));
                this.generateMethodParameter(ctor, field);
            }
        }
        for (JFieldVar field : declaredFields) {
            if (!this.mustAssign(field)) continue;
            this.generatePropertyAssignment(ctor, field, true);
        }
        return ctor;
    }

    private boolean mustAssign(JFieldVar field) {
        return !this.isFinal(field) || !this.isCollection(field) || this.getInitJExpression(field) == null;
    }

    private boolean shouldAssign(JFieldVar field) {
        return !this.isCollection(field) || this.getInitJExpression(field) == null;
    }

    private JMethod generateStandardConstructor(JDefinedClass clazz, JFieldVar[] declaredFields, JFieldVar[] superclassFields) {
        JMethod ctor = this.createConstructor(clazz, 2);
        ctor.javadoc().add((Object)"Used by JAX-B");
        if (superclassFields.length > 0) {
            JInvocation superInvocation = ctor.body().invoke("super");
            JFieldVar[] jFieldVarArray = superclassFields;
            int n = jFieldVarArray.length;
            for (int i = 0; i < n; ++i) {
                JFieldVar field = jFieldVarArray[i];
                if (!this.mustAssign(field)) continue;
                superInvocation.arg(this.defaultValue(field));
            }
        }
        for (JFieldVar field : declaredFields) {
            if (!this.shouldAssign(field)) continue;
            this.generateDefaultPropertyAssignment(ctor, field);
        }
        return ctor;
    }

    private JMethod generateCopyConstructor(JDefinedClass clazz, JDefinedClass builderClass, JFieldVar[] declaredFields, JFieldVar[] superclassFields) {
        String propertyName;
        JMethod ctor = this.createConstructor(builderClass, 1);
        JVar o = ctor.param(8, (JType)clazz, "o");
        if (this.hasSuperClass(builderClass)) {
            ctor.body().invoke("super").arg((JExpression)o);
        } else {
            String builderName = this.isUseSimpleBuilderName() ? String.format("%s.%s", clazz.name(), builderClass.name()) : builderClass.name();
            ctor.body()._if(o.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)builderClass.owner().ref(NullPointerException.class)).arg("Cannot create a copy of '" + builderName + "' from 'null'."));
        }
        JCodeModel codeModel = clazz.owner();
        for (JFieldVar field : superclassFields) {
            propertyName = field.name();
            JType type = field.type();
            if (!(type instanceof JDefinedClass)) continue;
            JMethod getter = this.getGetterProperty(field, clazz);
            if (this.isCollection(field)) {
                JVar tmpVar = ctor.body().decl(0, this.getJavaType(field), "_" + propertyName, (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter));
                JConditional conditional = ctor.body()._if(tmpVar.eq(JExpr._null()));
                conditional._then().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getNewCollectionExpression(codeModel, this.getJavaType(field)));
                conditional._else().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getDefensiveCopyExpression(codeModel, this.getJavaType(field), tmpVar));
                continue;
            }
            ctor.body().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter));
        }
        for (JFieldVar field : declaredFields) {
            propertyName = field.name();
            if (this.isCollection(field)) {
                JVar tmpVar = ctor.body().decl(0, this.getJavaType(field), "_" + propertyName, (JExpression)JExpr.ref((JExpression)o, (String)propertyName));
                JConditional conditional = ctor.body()._if(tmpVar.eq(JExpr._null()));
                conditional._then().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getNewCollectionExpression(codeModel, this.getJavaType(field)));
                conditional._else().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getDefensiveCopyExpression(codeModel, this.getJavaType(field), tmpVar));
                continue;
            }
            ctor.body().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), (JExpression)JExpr.ref((JExpression)o, (String)propertyName));
        }
        return ctor;
    }

    private boolean hasSuperClass(JDefinedClass builderClass) {
        return builderClass._extends() != null && builderClass._extends()._extends() != null;
    }

    private JMethod createConstructor(JDefinedClass clazz, int visibility) {
        return clazz.constructor(visibility);
    }

    private JType getJavaType(JFieldVar field) {
        return field.type();
    }

    private JType[] getFieldTypes(JFieldVar[] declaredFields, JFieldVar[] superclassFields) {
        JType[] fieldTypes = new JType[declaredFields.length + superclassFields.length];
        int i = 0;
        for (JFieldVar field : superclassFields) {
            fieldTypes[i++] = field.type();
        }
        for (JFieldVar field : declaredFields) {
            fieldTypes[i++] = field.type();
        }
        return fieldTypes;
    }

    private JMethod getGetterProperty(JFieldVar field, JDefinedClass clazz) {
        JAnnotationValue annotationValue;
        Optional<JAnnotationUse> xmlElementAnnotation;
        JMethod getter = clazz.getMethod("get" + StringUtils.capitalize((String)field.name()), NO_ARGS);
        if (getter == null) {
            getter = clazz.getMethod("is" + StringUtils.capitalize((String)field.name()), NO_ARGS);
        }
        if (getter == null) {
            JDefinedClass definedClass;
            List<JDefinedClass> superClasses = this.getSuperClasses((JClass)clazz);
            Iterator<JDefinedClass> iterator = superClasses.iterator();
            while (iterator.hasNext() && (getter = this.getGetterProperty(field, definedClass = iterator.next())) == null) {
            }
        }
        if (getter == null && (xmlElementAnnotation = this.getAnnotation(field.annotations(), XmlElement.class.getCanonicalName())).isPresent() && (annotationValue = (JAnnotationValue)xmlElementAnnotation.get().getAnnotationMembers().get("name")) != null) {
            StringWriter sw = new StringWriter();
            JFormatter f = new JFormatter((Writer)sw);
            annotationValue.generate(f);
            getter = clazz.getMethod("get" + sw.toString().replaceAll("\"", ""), NO_ARGS);
        }
        return getter;
    }

    private void makeClassFinal(JDefinedClass clazz) {
        clazz.mods().setFinal(true);
    }

    private void makePropertiesPrivate(JDefinedClass clazz) {
        for (JFieldVar field : clazz.fields().values()) {
            field.mods().setPrivate();
        }
    }

    private void makePropertiesFinal(JDefinedClass clazz, JFieldVar[] declaredFields) {
        for (JFieldVar field : declaredFields) {
            String fieldName = field.name();
            ((JFieldVar)clazz.fields().get(fieldName)).mods().setFinal(!this.leaveCollectionsMutable || !this.isCollection(field));
        }
    }

    private boolean isCollection(JFieldVar field) {
        if (field.type() instanceof JClass) {
            return this.isCollection((JClass)field.type());
        }
        return false;
    }

    private boolean isCollection(JClass clazz) {
        return clazz.owner().ref(Collection.class).isAssignableFrom(clazz) || clazz.owner().ref(Map.class).isAssignableFrom(clazz);
    }

    private boolean isRequired(JFieldVar field) {
        return Stream.of(XmlElement.class, XmlAttribute.class).map(annotationType -> this.getAnnotation(field.annotations(), annotationType.getCanonicalName()).map(JAnnotationUse::getAnnotationMembers).map(annotationValues -> (JAnnotationValue)annotationValues.get("required")).filter(annotationValue -> {
            StringWriter sw = new StringWriter();
            JFormatter f = new JFormatter((Writer)sw);
            annotationValue.generate(f);
            return sw.toString().equals("true");
        })).anyMatch(Optional::isPresent);
    }

    private void removeSetters(JDefinedClass clazz) {
        Collection methods = clazz.methods();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            JMethod method = (JMethod)it.next();
            String methodName = method.name();
            if (!methodName.startsWith(SET_PREFIX) && !methodName.startsWith(UNSET_PREFIX)) continue;
            it.remove();
        }
    }

    private JFieldVar[] getDeclaredFields(JDefinedClass clazz) {
        return (JFieldVar[])clazz.fields().values().stream().filter(f -> !this.isFinal((JFieldVar)f) || !this.isStatic((JFieldVar)f)).toArray(JFieldVar[]::new);
    }

    private ClassField[] getSuperclassFields(JDefinedClass clazz) {
        List<JDefinedClass> superclasses = this.getSuperClasses((JClass)clazz);
        ArrayList<ClassField> superclassFields = new ArrayList<ClassField>();
        Collections.reverse(superclasses);
        for (JDefinedClass classOutline : superclasses) {
            Map fields = classOutline.fields();
            for (JFieldVar jFieldVar : fields.values()) {
                if (this.isStatic(jFieldVar) && this.isFinal(jFieldVar)) continue;
                superclassFields.add(new ClassField(classOutline, jFieldVar));
            }
        }
        return superclassFields.toArray(new ClassField[0]);
    }

    private List<JDefinedClass> getSuperClasses(JClass clazz) {
        ArrayList<JDefinedClass> superclasses = new ArrayList<JDefinedClass>();
        for (JClass superclass = clazz._extends(); superclass != null; superclass = superclass._extends()) {
            if (!(superclass instanceof JDefinedClass)) continue;
            superclasses.add((JDefinedClass)superclass);
        }
        return superclasses;
    }

    public boolean isStatic(JFieldVar var) {
        return (var.mods().getValue() & 0x10) != 0;
    }

    public boolean isFinal(JFieldVar var) {
        return (var.mods().getValue() & 8) != 0;
    }

    private JFieldVar[] getUnhandledSuperclassFields(ClassField[] superclassFieldsWithOwners) {
        JFieldVar[] superclassFields = (JFieldVar[])Arrays.stream(superclassFieldsWithOwners).map(ClassField::getField).toArray(JFieldVar[]::new);
        if (!this.builderInheritance) {
            return superclassFields;
        }
        for (int i = superclassFields.length - 1; i >= 0; --i) {
            JDefinedClass type = superclassFieldsWithOwners[i].getClazz();
            if (type == null || this.getBuilderClass((JClass)type) == null) continue;
            if (i == superclassFields.length - 1) {
                return new JFieldVar[0];
            }
            JFieldVar[] handledSuperclassFields = new JFieldVar[superclassFields.length - i - 1];
            System.arraycopy(superclassFields, i + 1, handledSuperclassFields, 0, handledSuperclassFields.length);
            return handledSuperclassFields;
        }
        return superclassFields;
    }

    private JExpression getInitJExpression(JFieldVar jFieldVar) {
        try {
            return (JExpression)FieldUtils.readField((Object)jFieldVar, (String)"init", (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private void log(Level level, String key, Object ... args) {
        String message = "[IMMUTABLE-XJC] [" + level.getLocalizedName() + "] " + this.getMessage(key, args);
        int logLevel = Level.WARNING.intValue();
        if (this.options != null && !this.options.quiet) {
            if (this.options.verbose) {
                logLevel = Level.INFO.intValue();
            }
            if (this.options.debugMode) {
                logLevel = Level.ALL.intValue();
            }
        }
        if (level.intValue() >= logLevel) {
            if (level.intValue() <= Level.INFO.intValue()) {
                System.out.println(message);
            } else {
                System.err.println(message);
            }
        }
    }

    private static class ClassField {
        private JDefinedClass clazz;
        private JFieldVar field;

        public ClassField(JDefinedClass clazz, JFieldVar field) {
            this.clazz = clazz;
            this.field = field;
        }

        public JDefinedClass getClazz() {
            return this.clazz;
        }

        public JFieldVar getField() {
            return this.field;
        }
    }
}

