/*
 * Decompiled with CFR 0.152.
 */
package com.github.sabomichal.immutablexjc;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.model.CAdapter;
import com.sun.tools.xjc.model.CDefaultValue;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.model.TypeUse;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XmlString;
import java.beans.Introspector;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.activation.MimeType;
import org.xml.sax.ErrorHandler;

public final class PluginImpl
extends Plugin {
    private static final String BUILDER_OPTION_NAME = "-imm-builder";
    private static final String SIMPLEBUILDERNAME_OPTION_NAME = "-imm-simplebuildername";
    private static final String INHERIT_BUILDER_OPTION_NAME = "-imm-inheritbuilder";
    private static final String CCONSTRUCTOR_OPTION_NAME = "-imm-cc";
    private static final String WITHIFNOTNULL_OPTION_NAME = "-imm-ifnotnull";
    private static final String NOPUBLICCONSTRUCTOR_OPTION_NAME = "-imm-nopubconstructor";
    private static final String PUBLICCONSTRUCTOR_MAXARGS_OPTION_NAME = "-imm-pubconstructormaxargs";
    private static final String SKIPCOLLECTIONS_OPTION_NAME = "-imm-skipcollections";
    private static final String CONSTRUCTORDEFAULTS_OPTION_NAME = "-imm-constructordefaults";
    private static final String UNSET_PREFIX = "unset";
    private static final String SET_PREFIX = "set";
    private static final String MESSAGE_PREFIX = "IMMUTABLE-XJC";
    private static final String OPTION_NAME = "immutable";
    private static final JType[] NO_ARGS = new JType[0];
    private ResourceBundle resourceBundle = ResourceBundle.getBundle(PluginImpl.class.getCanonicalName());
    private boolean createBuilder;
    private boolean builderInheritance;
    private boolean createCConstructor;
    private boolean createWithIfNotNullMethod;
    private boolean createBuilderWithoutPublicConstructor;
    private int publicConstructorMaxArgs = Integer.MAX_VALUE;
    private boolean leaveCollectionsMutable;
    private boolean setDefaultValuesInConstructor;
    private boolean useSimpleBuilderName;
    private Options options;

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) {
        boolean success = true;
        this.options = options;
        this.log(Level.INFO, "title", new Object[0]);
        ArrayList<ClassOutline> classes = new ArrayList<ClassOutline>(model.getClasses());
        if (this.builderInheritance) {
            classes.sort(new Comparator<ClassOutline>(){

                @Override
                public int compare(ClassOutline o1, ClassOutline o2) {
                    if (this.isSubClass(o1, o2)) {
                        return 1;
                    }
                    if (this.isSubClass(o2, o1)) {
                        return -1;
                    }
                    return 0;
                }

                private boolean isSubClass(ClassOutline o1, ClassOutline o2) {
                    ClassOutline superClass;
                    boolean isSubClass = false;
                    for (superClass = o1.getSuperClass(); superClass != null && superClass != o2; superClass = superClass.getSuperClass()) {
                    }
                    if (superClass == o2) {
                        isSubClass = true;
                    }
                    return isSubClass;
                }
            });
        }
        for (ClassOutline clazz : classes) {
            FieldOutline[] superclassFields;
            int superclassFieldsLength;
            JDefinedClass implClass = clazz.implClass;
            FieldOutline[] declaredFields = clazz.getDeclaredFields();
            int declaredFieldsLength = declaredFields.length;
            if (declaredFieldsLength + (superclassFieldsLength = (superclassFields = this.getSuperclassFields(clazz)).length) > 0 && this.addStandardConstructor(implClass, declaredFields, superclassFields) == null) {
                this.log(Level.WARNING, "couldNotAddStdCtor", implClass.binaryName());
            }
            if (declaredFieldsLength + superclassFieldsLength > 0) {
                if (this.createBuilderWithoutPublicConstructor || this.createBuilder && declaredFieldsLength + superclassFieldsLength > this.publicConstructorMaxArgs) {
                    if (this.addPropertyContructor(implClass, declaredFields, superclassFields, 0) == null) {
                        this.log(Level.WARNING, "couldNotAddPropertyCtor", implClass.binaryName());
                    }
                } else if (this.addPropertyContructor(implClass, declaredFields, superclassFields, 1) == null) {
                    this.log(Level.WARNING, "couldNotAddPropertyCtor", implClass.binaryName());
                }
            }
            this.makeClassFinal(implClass);
            this.removeSetters(implClass);
            this.makePropertiesPrivate(implClass);
            this.makePropertiesFinal(implClass, declaredFields);
            if (!this.createBuilder || clazz.implClass.isAbstract()) continue;
            FieldOutline[] unhandledSuperclassFields = this.getUnhandledSuperclassFields(clazz, superclassFields);
            JDefinedClass builderClass = this.addBuilderClass(clazz, declaredFields, unhandledSuperclassFields, superclassFields);
            if (builderClass == null) {
                this.log(Level.WARNING, "couldNotAddClassBuilder", implClass.binaryName());
            }
            if (!this.createCConstructor || builderClass == null || this.addCopyConstructor(clazz.implClass, builderClass, declaredFields, unhandledSuperclassFields) != null) continue;
            this.log(Level.WARNING, "couldNotAddCopyCtor", implClass.binaryName());
        }
        for (ClassOutline clazz : model.getClasses()) {
            if (clazz.getSuperClass() != null) {
                clazz.getSuperClass().implClass.mods().setFinal(false);
                continue;
            }
            if (!clazz.implClass.isAbstract()) continue;
            clazz.implClass.mods().setFinal(false);
        }
        this.options = null;
        return success;
    }

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        String n = System.getProperty("line.separator", "\n");
        int maxOptionLength = PUBLICCONSTRUCTOR_MAXARGS_OPTION_NAME.length();
        StringBuilder retval = new StringBuilder();
        this.appendOption(retval, "-immutable", this.getMessage("usage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, BUILDER_OPTION_NAME, this.getMessage("builderUsage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, SIMPLEBUILDERNAME_OPTION_NAME, this.getMessage("simpleBuilderNameUsage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, INHERIT_BUILDER_OPTION_NAME, this.getMessage("inheritBuilderUsage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, CCONSTRUCTOR_OPTION_NAME, this.getMessage("cConstructorUsage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, WITHIFNOTNULL_OPTION_NAME, this.getMessage("withIfNotNullUsage", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, NOPUBLICCONSTRUCTOR_OPTION_NAME, this.getMessage("builderWithoutPublicConstructor", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, SKIPCOLLECTIONS_OPTION_NAME, this.getMessage("leaveCollectionsMutable", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, PUBLICCONSTRUCTOR_MAXARGS_OPTION_NAME, this.getMessage("publicConstructorMaxArgs", new Object[0]), n, maxOptionLength);
        this.appendOption(retval, CONSTRUCTORDEFAULTS_OPTION_NAME, this.getMessage("setDefaultValuesInConstructor", new Object[0]), n, maxOptionLength);
        return retval.toString();
    }

    private void appendOption(StringBuilder retval, String option, String description, String n, int optionColumnWidth) {
        retval.append("  ");
        retval.append(option);
        for (int i = option.length(); i < optionColumnWidth; ++i) {
            retval.append(' ');
        }
        retval.append(" :  ");
        retval.append(description);
        retval.append(n);
    }

    public int parseArgument(Options opt, String[] args, int i) {
        if (args[i].startsWith(BUILDER_OPTION_NAME)) {
            this.createBuilder = true;
            return 1;
        }
        if (args[i].startsWith(SIMPLEBUILDERNAME_OPTION_NAME)) {
            this.useSimpleBuilderName = true;
            return 1;
        }
        if (args[i].startsWith(INHERIT_BUILDER_OPTION_NAME)) {
            this.createBuilder = true;
            this.builderInheritance = true;
            return 1;
        }
        if (args[i].startsWith(CCONSTRUCTOR_OPTION_NAME)) {
            this.createCConstructor = true;
            return 1;
        }
        if (args[i].startsWith(WITHIFNOTNULL_OPTION_NAME)) {
            this.createWithIfNotNullMethod = true;
            return 1;
        }
        if (args[i].startsWith(NOPUBLICCONSTRUCTOR_OPTION_NAME)) {
            this.createBuilderWithoutPublicConstructor = true;
            return 1;
        }
        if (args[i].startsWith(SKIPCOLLECTIONS_OPTION_NAME)) {
            this.leaveCollectionsMutable = true;
            return 1;
        }
        if (args[i].startsWith(PUBLICCONSTRUCTOR_MAXARGS_OPTION_NAME)) {
            this.publicConstructorMaxArgs = Integer.parseInt(args[i].substring(PUBLICCONSTRUCTOR_MAXARGS_OPTION_NAME.length() + 1));
            return 1;
        }
        if (args[i].startsWith(CONSTRUCTORDEFAULTS_OPTION_NAME)) {
            this.setDefaultValuesInConstructor = true;
            return 1;
        }
        return 0;
    }

    private String getMessage(String key, Object ... args) {
        return MessageFormat.format(this.resourceBundle.getString(key), args);
    }

    private JDefinedClass addBuilderClass(ClassOutline clazz, FieldOutline[] declaredFields, FieldOutline[] unhandledSuperclassFields, FieldOutline[] allSuperclassFields) {
        JDefinedClass builderClass = this.generateBuilderClass(clazz.implClass);
        if (builderClass == null) {
            return null;
        }
        this.addBuilderMethodsForFields(builderClass, declaredFields);
        this.addBuilderMethodsForFields(builderClass, unhandledSuperclassFields);
        if (this.builderInheritance) {
            for (int i = 0; i < allSuperclassFields.length - unhandledSuperclassFields.length; ++i) {
                FieldOutline inheritedField = allSuperclassFields[i];
                JMethod unconditionalWithMethod = this.addWithMethod(builderClass, inheritedField, true);
                if (this.createWithIfNotNullMethod) {
                    this.addWithIfNotNullMethod(builderClass, inheritedField, unconditionalWithMethod, true);
                }
                if (!inheritedField.getPropertyInfo().isCollection()) continue;
                this.addAddMethod(builderClass, inheritedField, true);
            }
        }
        this.addNewBuilder(clazz, builderClass);
        if (this.createCConstructor) {
            this.addNewBuilderCc(clazz, builderClass);
        }
        this.addBuildMethod(clazz.implClass, builderClass, declaredFields, allSuperclassFields);
        return builderClass;
    }

    private void addBuilderMethodsForFields(JDefinedClass builderClass, FieldOutline[] declaredFields) {
        for (FieldOutline field : declaredFields) {
            this.addProperty(builderClass, field);
            JMethod unconditionalWithMethod = this.addWithMethod(builderClass, field, false);
            if (this.createWithIfNotNullMethod) {
                this.addWithIfNotNullMethod(builderClass, field, unconditionalWithMethod, false);
            }
            if (!field.getPropertyInfo().isCollection()) continue;
            this.addAddMethod(builderClass, field, false);
        }
    }

    private JVar addProperty(JDefinedClass clazz, FieldOutline field) {
        int builderFieldVisibility;
        JType jType = this.getJavaType(field);
        int n = builderFieldVisibility = this.builderInheritance ? 2 : 4;
        if (field.getPropertyInfo().isCollection()) {
            return clazz.field(builderFieldVisibility, jType, field.getPropertyInfo().getName(false), this.getNewCollectionExpression(field.parent().implClass.owner(), jType));
        }
        return clazz.field(builderFieldVisibility, jType, field.getPropertyInfo().getName(false));
    }

    private JMethod addBuildMethod(JDefinedClass clazz, JDefinedClass builderClass, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod method = builderClass.method(1, (JType)clazz, "build");
        if (this.hasSuperClass(builderClass)) {
            method.annotate(Override.class);
        }
        JInvocation constructorInvocation = JExpr._new((JClass)clazz);
        for (FieldOutline field : superclassFields) {
            constructorInvocation.arg((JExpression)JExpr.ref((String)field.getPropertyInfo().getName(false)));
        }
        for (FieldOutline field : declaredFields) {
            constructorInvocation.arg((JExpression)JExpr.ref((String)field.getPropertyInfo().getName(false)));
        }
        method.body()._return((JExpression)constructorInvocation);
        return method;
    }

    private void addNewBuilder(ClassOutline clazz, JDefinedClass builderClass) {
        if (this.builderInheritance || !this.hasSuperClassWithSameName(clazz)) {
            String builderMethodName = this.generateBuilderMethodName(clazz);
            JMethod method = clazz.implClass.method(17, (JType)builderClass, builderMethodName);
            method.body()._return((JExpression)JExpr._new((JClass)builderClass));
        }
    }

    private void addNewBuilderCc(ClassOutline clazz, JDefinedClass builderClass) {
        if (this.builderInheritance || !this.hasSuperClassWithSameName(clazz)) {
            String builderMethodName = this.generateBuilderMethodName(clazz);
            JMethod method = clazz.implClass.method(17, (JType)builderClass, builderMethodName);
            JVar param = method.param(8, (JType)clazz.implClass, "o");
            method.body()._return((JExpression)JExpr._new((JClass)builderClass).arg((JExpression)param));
        }
    }

    private String generateBuilderMethodName(ClassOutline clazz) {
        if (this.isUseSimpleBuilderName()) {
            return "builder";
        }
        return Introspector.decapitalize(clazz.implClass.name()) + "Builder";
    }

    private boolean isUseSimpleBuilderName() {
        return this.useSimpleBuilderName;
    }

    private boolean hasSuperClassWithSameName(ClassOutline clazz) {
        for (ClassOutline superclass = clazz.getSuperClass(); superclass != null; superclass = superclass.getSuperClass()) {
            if (!superclass.implClass.name().equals(clazz.implClass.name())) continue;
            return true;
        }
        return false;
    }

    private Object addPropertyContructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields, int constAccess) {
        JMethod ctor = clazz.getConstructor(this.getFieldTypes(declaredFields, superclassFields));
        if (ctor == null) {
            ctor = this.generatePropertyConstructor(clazz, declaredFields, superclassFields, constAccess);
        } else {
            this.log(Level.WARNING, "standardCtorExists", new Object[0]);
        }
        return ctor;
    }

    private JMethod addStandardConstructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = clazz.getConstructor(NO_ARGS);
        if (ctor == null) {
            ctor = this.generateStandardConstructor(clazz, declaredFields, superclassFields);
        } else {
            this.log(Level.WARNING, "standardCtorExists", new Object[0]);
        }
        return ctor;
    }

    private JMethod addCopyConstructor(JDefinedClass clazz, JDefinedClass builderClass, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = this.generateCopyConstructor(clazz, builderClass, declaredFields, superclassFields);
        if (ctor != null) {
            this.createConstructor(builderClass, 1);
        }
        return ctor;
    }

    private JMethod addWithMethod(JDefinedClass builderClass, FieldOutline field, boolean inherit) {
        String fieldName = field.getPropertyInfo().getName(true);
        JMethod method = builderClass.method(1, (JType)builderClass, "with" + fieldName);
        if (inherit) {
            this.generateMethodParameter(method, field);
            this.generateSuperCall(method);
        } else {
            this.generatePropertyAssignment(method, field);
        }
        method.body()._return(JExpr._this());
        return method;
    }

    private JMethod addWithIfNotNullMethod(JDefinedClass builderClass, FieldOutline field, JMethod unconditionalWithMethod, boolean inherit) {
        if (field.getRawType().isPrimitive()) {
            return null;
        }
        String fieldName = field.getPropertyInfo().getName(true);
        JMethod method = builderClass.method(1, (JType)builderClass, "with" + fieldName + "IfNotNull");
        JVar param = this.generateMethodParameter(method, field);
        JBlock block = method.body();
        if (inherit) {
            this.generateSuperCall(method);
            method.body()._return(JExpr._this());
        } else {
            JConditional conditional = block._if(param.eq(JExpr._null()));
            conditional._then()._return(JExpr._this());
            conditional._else()._return((JExpression)JExpr.invoke((JMethod)unconditionalWithMethod).arg((JExpression)param));
        }
        return method;
    }

    private JMethod addAddMethod(JDefinedClass builderClass, FieldOutline field, boolean inherit) {
        List typeParams = ((JClass)this.getJavaType(field)).getTypeParameters();
        if (!typeParams.iterator().hasNext()) {
            return null;
        }
        JMethod method = builderClass.method(1, (JType)builderClass, "add" + field.getPropertyInfo().getName(true));
        JBlock block = method.body();
        String fieldName = field.getPropertyInfo().getName(false);
        JVar param = method.param(8, (JType)typeParams.iterator().next(), fieldName);
        if (inherit) {
            this.generateSuperCall(method);
        } else {
            JInvocation invocation = JExpr.refthis((String)fieldName).invoke("add").arg((JExpression)param);
            block.add((JStatement)invocation);
        }
        block._return(JExpr._this());
        return method;
    }

    private void generateSuperCall(JMethod method) {
        method.annotate(Override.class);
        JBlock block = method.body();
        JInvocation superInvocation = block.invoke(JExpr._super(), method);
        for (JVar param : method.params()) {
            superInvocation.arg((JExpression)param);
        }
    }

    private JDefinedClass generateBuilderClass(JDefinedClass clazz) {
        JDefinedClass builderClass;
        block3: {
            builderClass = null;
            String builderClassName = this.getBuilderClassName((JClass)clazz);
            try {
                builderClass = clazz._class(17, builderClassName);
                if (!this.builderInheritance) break block3;
                for (JClass superClass = clazz._extends(); superClass != null; superClass = superClass._extends()) {
                    JClass superClassBuilderClass = this.getBuilderClass(superClass);
                    if (superClassBuilderClass == null) continue;
                    builderClass._extends(superClassBuilderClass);
                    break;
                }
            }
            catch (JClassAlreadyExistsException e) {
                this.log(Level.WARNING, "builderClassExists", builderClassName);
            }
        }
        return builderClass;
    }

    private String getBuilderClassName(JClass clazz) {
        if (this.isUseSimpleBuilderName()) {
            return "Builder";
        }
        return clazz.name() + "Builder";
    }

    private JClass getBuilderClass(JClass clazz) {
        if (!this.createBuilder || clazz.isAbstract()) {
            return null;
        }
        String builderClassName = this.getBuilderClassName(clazz);
        if (clazz instanceof JDefinedClass) {
            JDefinedClass definedClass = (JDefinedClass)clazz;
            Iterator i = definedClass.classes();
            while (i.hasNext()) {
                JDefinedClass innerClass = (JDefinedClass)i.next();
                if (!builderClassName.equals(innerClass.name())) continue;
                return innerClass;
            }
        }
        return null;
    }

    private void replaceCollectionGetter(FieldOutline field, JMethod getter) {
        JDefinedClass clazz = field.parent().implClass;
        clazz.methods().remove(getter);
        JMethod newGetter = field.parent().implClass.method(getter.mods().getValue(), getter.type(), getter.name());
        JBlock block = newGetter.body();
        JVar ret = block.decl(this.getJavaType(field), "ret");
        JCodeModel codeModel = field.parent().implClass.owner();
        JVar param = this.generateMethodParameter(getter, field);
        JConditional conditional = block._if(param.eq(JExpr._null()));
        conditional._then().assign((JAssignmentTarget)ret, this.getEmptyCollectionExpression(codeModel, param));
        conditional._else().assign((JAssignmentTarget)ret, this.getUnmodifiableWrappedExpression(codeModel, param));
        block._return((JExpression)ret);
        getter.javadoc().append((Object)"Returns unmodifiable collection.");
    }

    private void generatePropertyAssignment(JMethod method, FieldOutline fieldOutline) {
        this.generatePropertyAssignment(method, fieldOutline, false);
    }

    private void generatePropertyAssignment(JMethod method, FieldOutline fieldOutline, boolean wrapUnmodifiable) {
        JBlock block = method.body();
        JCodeModel codeModel = fieldOutline.parent().implClass.owner();
        String fieldName = fieldOutline.getPropertyInfo().getName(false);
        JVar param = this.generateMethodParameter(method, fieldOutline);
        if (fieldOutline.getPropertyInfo().isCollection() && !this.leaveCollectionsMutable) {
            if (wrapUnmodifiable) {
                JConditional conditional = block._if(param.eq(JExpr._null()));
                conditional._then().assign((JAssignmentTarget)JExpr.refthis((String)fieldName), JExpr._null());
                conditional._else().assign((JAssignmentTarget)JExpr.refthis((String)fieldName), this.getDefensiveCopyExpression(codeModel, this.getJavaType(fieldOutline), param));
            } else {
                block.assign((JAssignmentTarget)JExpr.refthis((String)fieldName), (JExpression)JExpr.ref((String)fieldName));
            }
            this.replaceCollectionGetter(fieldOutline, this.getGetterProperty(fieldOutline));
        } else {
            block.assign((JAssignmentTarget)JExpr.refthis((String)fieldName), (JExpression)JExpr.ref((String)fieldName));
        }
    }

    private JVar generateMethodParameter(JMethod method, FieldOutline fieldOutline) {
        String fieldName = fieldOutline.getPropertyInfo().getName(false);
        JType javaType = this.getJavaType(fieldOutline);
        return method.param(8, javaType, fieldName);
    }

    private JExpression getDefensiveCopyExpression(JCodeModel codeModel, JType jType, JVar param) {
        List typeParams = ((JClass)jType).getTypeParameters();
        JClass typeParameter = null;
        if (typeParams.iterator().hasNext()) {
            typeParameter = (JClass)typeParams.iterator().next();
        }
        JClass newClass = null;
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (param.type().erasure().equals(codeModel.ref(List.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            newClass = codeModel.ref(HashMap.class);
        } else if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            newClass = codeModel.ref(HashSet.class);
        } else if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            newClass = codeModel.ref(TreeMap.class);
        } else if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            newClass = codeModel.ref(TreeSet.class);
        }
        if (newClass != null && typeParameter != null) {
            newClass = newClass.narrow(typeParameter);
        }
        return newClass == null ? JExpr._null() : JExpr._new((JClass)newClass).arg((JExpression)param);
    }

    private JExpression getUnmodifiableWrappedExpression(JCodeModel codeModel, JVar param) {
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableCollection").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(List.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableList").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableMap").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSet").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSortedMap").arg((JExpression)param);
        }
        if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            return codeModel.ref(Collections.class).staticInvoke("unmodifiableSortedSet").arg((JExpression)param);
        }
        return param;
    }

    private JExpression getEmptyCollectionExpression(JCodeModel codeModel, JVar param) {
        if (param.type().erasure().equals(codeModel.ref(Collection.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyList");
        }
        if (param.type().erasure().equals(codeModel.ref(List.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyList");
        }
        if (param.type().erasure().equals(codeModel.ref(Map.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptyMap");
        }
        if (param.type().erasure().equals(codeModel.ref(Set.class))) {
            return codeModel.ref(Collections.class).staticInvoke("emptySet");
        }
        if (param.type().erasure().equals(codeModel.ref(SortedMap.class))) {
            return JExpr._new((JClass)codeModel.ref(TreeMap.class));
        }
        if (param.type().erasure().equals(codeModel.ref(SortedSet.class))) {
            return JExpr._new((JClass)codeModel.ref(TreeSet.class));
        }
        return param;
    }

    private JExpression getNewCollectionExpression(JCodeModel codeModel, JType jType) {
        List typeParams = ((JClass)jType).getTypeParameters();
        JClass typeParameter = null;
        if (typeParams.iterator().hasNext()) {
            typeParameter = (JClass)typeParams.iterator().next();
        }
        JClass newClass = null;
        if (jType.erasure().equals(codeModel.ref(Collection.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (jType.erasure().equals(codeModel.ref(List.class))) {
            newClass = codeModel.ref(ArrayList.class);
        } else if (jType.erasure().equals(codeModel.ref(Map.class))) {
            newClass = codeModel.ref(HashMap.class);
        } else if (jType.erasure().equals(codeModel.ref(Set.class))) {
            newClass = codeModel.ref(HashSet.class);
        } else if (jType.erasure().equals(codeModel.ref(SortedMap.class))) {
            newClass = codeModel.ref(TreeMap.class);
        } else if (jType.erasure().equals(codeModel.ref(SortedSet.class))) {
            newClass = codeModel.ref(TreeSet.class);
        }
        if (newClass != null && typeParameter != null) {
            newClass = newClass.narrow(typeParameter);
        }
        return newClass == null ? JExpr._null() : JExpr._new((JClass)newClass);
    }

    private void generateDefaultPropertyAssignment(JMethod method, FieldOutline fieldOutline) {
        JBlock block = method.body();
        String propertyName = fieldOutline.getPropertyInfo().getName(false);
        block.assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.defaultValue(this.getJavaType(fieldOutline), fieldOutline));
    }

    private JExpression defaultValue(JType javaType, FieldOutline fieldOutline) {
        if (this.setDefaultValuesInConstructor) {
            XSElementDecl elem;
            XSParticle part;
            if (fieldOutline.getPropertyInfo().defaultValue == null && fieldOutline.getPropertyInfo().getSchemaComponent() instanceof XSParticle && (part = (XSParticle)fieldOutline.getPropertyInfo().getSchemaComponent()).getTerm().isElementDecl() && (elem = part.getTerm().asElementDecl()).getDefaultValue() != null) {
                TypeUse typeUse = null;
                final CAdapter ad = fieldOutline.getPropertyInfo().getAdapter();
                for (CTypeInfo cti : fieldOutline.getPropertyInfo().ref()) {
                    if (!(cti instanceof TypeUse)) continue;
                    if (ad != null) {
                        final CNonElement cti2 = (CNonElement)cti;
                        typeUse = new TypeUse(){

                            public boolean isCollection() {
                                return false;
                            }

                            public CAdapter getAdapterUse() {
                                return null;
                            }

                            public CNonElement getInfo() {
                                return null;
                            }

                            public ID idUse() {
                                return null;
                            }

                            public MimeType getExpectedMimeType() {
                                return null;
                            }

                            public JExpression createConstant(Outline outline, XmlString lexical) {
                                JExpression cons = cti2.createConstant(outline, lexical);
                                return JExpr._new((JClass)ad.getAdapterClass(outline)).invoke("unmarshal").arg(cons);
                            }
                        };
                        break;
                    }
                    typeUse = (TypeUse)cti;
                    break;
                }
                fieldOutline.getPropertyInfo().defaultValue = CDefaultValue.create(typeUse, (XmlString)elem.getDefaultValue());
            }
            if (fieldOutline.getPropertyInfo().defaultValue != null) {
                return fieldOutline.getPropertyInfo().defaultValue.compute(fieldOutline.parent().parent());
            }
        }
        if (javaType.isPrimitive()) {
            if (fieldOutline.parent().parent().getCodeModel().BOOLEAN.equals(javaType)) {
                return JExpr.lit((boolean)false);
            }
            if (fieldOutline.parent().parent().getCodeModel().SHORT.equals(javaType)) {
                return JExpr.cast((JType)fieldOutline.parent().parent().getCodeModel().SHORT, (JExpression)JExpr.lit((int)0));
            }
            return JExpr.lit((int)0);
        }
        return JExpr._null();
    }

    private JMethod generatePropertyConstructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields, int constAccess) {
        JMethod ctor = this.createConstructor(clazz, constAccess);
        if (superclassFields.length > 0) {
            JInvocation superInvocation = ctor.body().invoke("super");
            FieldOutline[] fieldOutlineArray = superclassFields;
            int n = fieldOutlineArray.length;
            for (int i = 0; i < n; ++i) {
                FieldOutline fieldOutline = fieldOutlineArray[i];
                superInvocation.arg((JExpression)JExpr.ref((String)fieldOutline.getPropertyInfo().getName(false)));
                this.generateMethodParameter(ctor, fieldOutline);
            }
        }
        for (FieldOutline fieldOutline : declaredFields) {
            this.generatePropertyAssignment(ctor, fieldOutline, true);
        }
        return ctor;
    }

    private JMethod generateStandardConstructor(JDefinedClass clazz, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JMethod ctor = this.createConstructor(clazz, 2);
        ctor.javadoc().add((Object)"Used by JAX-B");
        if (superclassFields.length > 0) {
            JInvocation superInvocation = ctor.body().invoke("super");
            FieldOutline[] fieldOutlineArray = superclassFields;
            int n = fieldOutlineArray.length;
            for (int i = 0; i < n; ++i) {
                FieldOutline fieldOutline = fieldOutlineArray[i];
                superInvocation.arg(this.defaultValue(this.getJavaType(fieldOutline), fieldOutline));
            }
        }
        for (FieldOutline fieldOutline : declaredFields) {
            this.generateDefaultPropertyAssignment(ctor, fieldOutline);
        }
        return ctor;
    }

    private JMethod generateCopyConstructor(JDefinedClass clazz, JDefinedClass builderClass, FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        String propertyName;
        JMethod ctor = this.createConstructor(builderClass, 1);
        JVar o = ctor.param(8, (JType)clazz, "o");
        if (this.hasSuperClass(builderClass)) {
            ctor.body().invoke("super").arg((JExpression)o);
        } else {
            String builderName = this.isUseSimpleBuilderName() ? String.format("%s.%s", clazz.name(), builderClass.name()) : builderClass.name();
            ctor.body()._if(o.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)builderClass.owner().ref(NullPointerException.class)).arg("Cannot create a copy of '" + builderName + "' from 'null'."));
        }
        JCodeModel codeModel = clazz.owner();
        for (FieldOutline field : superclassFields) {
            propertyName = field.getPropertyInfo().getName(false);
            JMethod getter = this.getGetterProperty(field);
            if (field.getPropertyInfo().isCollection()) {
                JVar tmpVar = ctor.body().decl(0, this.getJavaType(field), "_" + propertyName, (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter));
                JConditional conditional = ctor.body()._if(tmpVar.eq(JExpr._null()));
                conditional._then().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getNewCollectionExpression(codeModel, this.getJavaType(field)));
                conditional._else().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getDefensiveCopyExpression(codeModel, this.getJavaType(field), tmpVar));
                continue;
            }
            ctor.body().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), (JExpression)JExpr.invoke((JExpression)o, (JMethod)getter));
        }
        for (FieldOutline field : declaredFields) {
            propertyName = field.getPropertyInfo().getName(false);
            if (field.getPropertyInfo().isCollection()) {
                JVar tmpVar = ctor.body().decl(0, this.getJavaType(field), "_" + propertyName, (JExpression)JExpr.ref((JExpression)o, (String)propertyName));
                JConditional conditional = ctor.body()._if(tmpVar.eq(JExpr._null()));
                conditional._then().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getNewCollectionExpression(codeModel, this.getJavaType(field)));
                conditional._else().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), this.getDefensiveCopyExpression(codeModel, this.getJavaType(field), tmpVar));
                continue;
            }
            ctor.body().assign((JAssignmentTarget)JExpr.refthis((String)propertyName), (JExpression)JExpr.ref((JExpression)o, (String)propertyName));
        }
        return ctor;
    }

    private boolean hasSuperClass(JDefinedClass builderClass) {
        return builderClass._extends() != null && builderClass._extends()._extends() != null;
    }

    private JMethod createConstructor(JDefinedClass clazz, int visibility) {
        return clazz.constructor(visibility);
    }

    private JType getJavaType(FieldOutline field) {
        return field.getRawType();
    }

    private JType[] getFieldTypes(FieldOutline[] declaredFields, FieldOutline[] superclassFields) {
        JType[] fieldTypes = new JType[declaredFields.length + superclassFields.length];
        int i = 0;
        for (FieldOutline fieldOutline : superclassFields) {
            fieldTypes[i++] = fieldOutline.getPropertyInfo().baseType;
        }
        for (FieldOutline fieldOutline : declaredFields) {
            fieldTypes[i++] = fieldOutline.getPropertyInfo().baseType;
        }
        return fieldTypes;
    }

    private JMethod getGetterProperty(FieldOutline fieldOutline) {
        JDefinedClass clazz = fieldOutline.parent().implClass;
        String name = fieldOutline.getPropertyInfo().getName(true);
        JMethod getter = clazz.getMethod("get" + name, NO_ARGS);
        if (getter == null) {
            getter = clazz.getMethod("is" + name, NO_ARGS);
        }
        return getter;
    }

    private void log(Level level, String key, Object ... args) {
        String message = "[IMMUTABLE-XJC] [" + level.getLocalizedName() + "] " + this.getMessage(key, args);
        int logLevel = Level.WARNING.intValue();
        if (this.options != null && !this.options.quiet) {
            if (this.options.verbose) {
                logLevel = Level.INFO.intValue();
            }
            if (this.options.debugMode) {
                logLevel = Level.ALL.intValue();
            }
        }
        if (level.intValue() >= logLevel) {
            if (level.intValue() <= Level.INFO.intValue()) {
                System.out.println(message);
            } else {
                System.err.println(message);
            }
        }
    }

    private void makeClassFinal(JDefinedClass clazz) {
        clazz.mods().setFinal(true);
    }

    private void makePropertiesPrivate(JDefinedClass clazz) {
        for (JFieldVar field : clazz.fields().values()) {
            field.mods().setPrivate();
        }
    }

    private void makePropertiesFinal(JDefinedClass clazz, FieldOutline[] declaredFields) {
        for (FieldOutline fieldOutline : declaredFields) {
            String fieldName = fieldOutline.getPropertyInfo().getName(false);
            ((JFieldVar)clazz.fields().get(fieldName)).mods().setFinal(!this.leaveCollectionsMutable || !fieldOutline.getPropertyInfo().isCollection());
        }
    }

    private void removeSetters(JDefinedClass clazz) {
        Collection methods = clazz.methods();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            JMethod method = (JMethod)it.next();
            String methodName = method.name();
            if (!methodName.startsWith(SET_PREFIX) && !methodName.startsWith(UNSET_PREFIX)) continue;
            it.remove();
        }
    }

    private FieldOutline[] getSuperclassFields(ClassOutline clazz) {
        ArrayList<ClassOutline> superclasses = new ArrayList<ClassOutline>();
        for (ClassOutline superclass = clazz.getSuperClass(); superclass != null; superclass = superclass.getSuperClass()) {
            superclasses.add(superclass);
        }
        ArrayList<FieldOutline> superclassFields = new ArrayList<FieldOutline>();
        Collections.reverse(superclasses);
        for (ClassOutline classOutline : superclasses) {
            superclassFields.addAll(Arrays.asList(classOutline.getDeclaredFields()));
        }
        return superclassFields.toArray(new FieldOutline[0]);
    }

    private FieldOutline[] getUnhandledSuperclassFields(ClassOutline clazz, FieldOutline[] superclassFields) {
        if (!this.builderInheritance) {
            return superclassFields;
        }
        for (int i = superclassFields.length - 1; i >= 0; --i) {
            FieldOutline superclassField = superclassFields[i];
            ClassOutline superClass = superclassField.parent();
            if (this.getBuilderClass((JClass)superClass.implClass) == null) continue;
            if (i == superclassFields.length - 1) {
                return new FieldOutline[0];
            }
            FieldOutline[] handledSuperclassFields = new FieldOutline[superclassFields.length - i - 1];
            System.arraycopy(superclassFields, i + 1, handledSuperclassFields, 0, handledSuperclassFields.length);
            return handledSuperclassFields;
        }
        return superclassFields;
    }
}

