/*
 * Decompiled with CFR 0.152.
 */
package com.github.sabomichal.jooq;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.flywaydb.core.Flyway;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.postgresql.Driver;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class PostgresDDLDatabase
extends PostgresDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(PostgresDDLDatabase.class);
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"postgres");
    private static final String DEFAULT_TAG = "14";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private Connection connection;
    private PostgreSQLContainer<?> postgresContainer;

    protected DSLContext create0() {
        return DSL.using((Connection)this.connection(), (SQLDialect)SQLDialect.POSTGRES);
    }

    protected Connection connection() {
        if (this.connection == null) {
            try {
                String customDockerImageName = this.getProperties().getProperty("dockerImage");
                DockerImageName dockerImageName = StringUtils.isBlank((String)customDockerImageName) ? DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG) : DockerImageName.parse((String)customDockerImageName).asCompatibleSubstituteFor("postgres");
                this.postgresContainer = new PostgreSQLContainer(dockerImageName).withDatabaseName("jooqdb").withUsername("user").withPassword("pwd");
                this.postgresContainer.start();
                Properties info = new Properties();
                info.put("user", this.postgresContainer.getUsername());
                info.put("password", this.postgresContainer.getPassword());
                this.connection = new Driver().connect(this.postgresContainer.getJdbcUrl(), info);
                String locationsProperty = this.getProperties().getProperty("locations");
                if (StringUtils.isBlank((String)locationsProperty)) {
                    locationsProperty = "";
                    log.warn((Object)"No scripts location defined", (Object)"It is recommended that you provide an explicit script directory to scan");
                }
                String[] locations = (String[])Arrays.stream(locationsProperty.split(",")).map(l -> "filesystem:" + this.getBasedir() + "/" + l).toArray(String[]::new);
                String placeholdersProperty = this.getProperties().getProperty("placeholders");
                Map<Object, Object> placeholders = StringUtils.isBlank((String)placeholdersProperty) ? Collections.emptyMap() : Arrays.stream(placeholdersProperty.split(",")).map(p -> p.split(KEY_VALUE_SEPARATOR)).collect(Collectors.toMap(pair -> pair[0], pair -> pair[1]));
                String defaultSchema = this.getProperties().getProperty("defaultSchema");
                if (StringUtils.isBlank((String)defaultSchema)) {
                    defaultSchema = "public";
                }
                Flyway.configure().dataSource(this.postgresContainer.getJdbcUrl(), this.postgresContainer.getUsername(), this.postgresContainer.getPassword()).locations(locations).schemas(new String[]{defaultSchema}).placeholders(placeholders).load().migrate();
                this.setConnection(this.connection);
            }
            catch (Exception e) {
                throw new DataAccessException("Error while exporting schema", (Throwable)e);
            }
        }
        return this.connection;
    }

    public void close() {
        JDBCUtils.safeClose((Connection)this.connection);
        this.connection = null;
        if (this.postgresContainer != null) {
            this.postgresContainer.close();
            this.postgresContainer = null;
        }
        super.close();
    }
}

