/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mssql.change;

import java.util.ArrayList;
import liquibase.change.DatabaseChange;
import liquibase.change.core.AddPrimaryKeyChange;
import liquibase.database.Database;
import liquibase.ext.mssql.statement.AddPrimaryKeyStatementMSSQL;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddPrimaryKeyStatement;

@DatabaseChange(name="addPrimaryKey", description="Adds creates a primary key out of an existing column or set of columns.", priority=1, appliesTo={"column"})
public class AddPrimaryKeyChangeMSSQL
extends AddPrimaryKeyChange {
    private Integer fillFactor;

    public Integer getFillFactor() {
        return this.fillFactor;
    }

    public void setFillFactor(Integer fillFactor) {
        this.fillFactor = fillFactor;
    }

    public SqlStatement[] generateStatements(Database database) {
        SqlStatement[] statements = super.generateStatements(database);
        if (!"Microsoft SQL Server".equals(database.getDatabaseProductName())) {
            return statements;
        }
        ArrayList<AddPrimaryKeyStatementMSSQL> extendedStatements = new ArrayList<AddPrimaryKeyStatementMSSQL>(statements.length);
        for (SqlStatement statement : statements) {
            if (statement instanceof AddPrimaryKeyStatement) {
                extendedStatements.add(new AddPrimaryKeyStatementMSSQL((AddPrimaryKeyStatement)statement, this.fillFactor));
                continue;
            }
            extendedStatements.add((AddPrimaryKeyStatementMSSQL)statement);
        }
        return extendedStatements.toArray(new SqlStatement[0]);
    }
}

