/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mssql.change;

import java.util.ArrayList;
import liquibase.change.DatabaseChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.database.Database;
import liquibase.ext.mssql.statement.CreateIndexStatementMSSQL;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateIndexStatement;

@DatabaseChange(name="createIndex", description="Creates an index on an existing column or set of columns.", priority=5, appliesTo={"index"})
public class CreateIndexChangeMSSQL
extends CreateIndexChange {
    private String includedColumns;
    private Integer fillFactor;

    public String getIncludedColumns() {
        return this.includedColumns;
    }

    public void setIncludedColumns(String includedColumns) {
        this.includedColumns = includedColumns;
    }

    public Integer getFillFactor() {
        return this.fillFactor;
    }

    public void setFillFactor(Integer fillFactor) {
        this.fillFactor = fillFactor;
    }

    public SqlStatement[] generateStatements(Database database) {
        SqlStatement[] statements = super.generateStatements(database);
        if (!"Microsoft SQL Server".equals(database.getDatabaseProductName())) {
            return statements;
        }
        ArrayList<CreateIndexStatementMSSQL> extendedStatements = new ArrayList<CreateIndexStatementMSSQL>(statements.length);
        for (SqlStatement statement : statements) {
            if (statement instanceof CreateIndexStatement) {
                extendedStatements.add(new CreateIndexStatementMSSQL((CreateIndexStatement)statement, this.includedColumns, this.fillFactor));
                continue;
            }
            extendedStatements.add((CreateIndexStatementMSSQL)statement);
        }
        return extendedStatements.toArray(new SqlStatement[0]);
    }
}

