/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mssql.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.mssql.statement.AddPrimaryKeyStatementMSSQL;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddPrimaryKeyGenerator;
import liquibase.statement.core.AddPrimaryKeyStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.util.StringUtils;

public class AddPrimaryKeyGeneratorMSSQL
extends AddPrimaryKeyGenerator {
    public int getPriority() {
        return 15;
    }

    public Sql[] generateSql(AddPrimaryKeyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (statement instanceof AddPrimaryKeyStatementMSSQL && ((AddPrimaryKeyStatementMSSQL)statement).getFillFactor() != null) {
            return this.generateMSSQLSql((AddPrimaryKeyStatementMSSQL)statement, database, sqlGeneratorChain);
        }
        return super.generateSql(statement, database, sqlGeneratorChain);
    }

    private Sql[] generateMSSQLSql(AddPrimaryKeyStatementMSSQL statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql;
        if (statement.getConstraintName() == null) {
            sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " ADD PRIMARY KEY (" + database.escapeColumnNameList(statement.getColumnNames()) + ")";
        } else {
            sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " ADD CONSTRAINT " + database.escapeConstraintName(statement.getConstraintName()) + " PRIMARY KEY";
            if (!statement.isClustered().booleanValue()) {
                sql = sql + " NONCLUSTERED";
            }
            sql = sql + " (" + database.escapeColumnNameList(statement.getColumnNames()) + ")";
        }
        sql = sql + " WITH (FILLFACTOR = " + statement.getFillFactor() + ")";
        if (StringUtils.trimToNull((String)statement.getTablespace()) != null && database.supportsTablespaces()) {
            sql = sql + " ON " + statement.getTablespace();
        }
        if (statement.getForIndexName() != null) {
            sql = sql + " USING INDEX " + database.escapeObjectName(statement.getForIndexCatalogName(), statement.getForIndexSchemaName(), statement.getForIndexName(), Index.class);
        }
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedPrimaryKey(statement)})};
    }
}

