/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mssql.change;

import java.util.ArrayList;
import liquibase.change.DatabaseChange;
import liquibase.change.core.InsertDataChange;
import liquibase.database.Database;
import liquibase.ext.mssql.database.MSSQLDatabase;
import liquibase.ext.mssql.statement.InsertStatementMSSQL;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.InsertStatement;

@DatabaseChange(name="insert", description="Inserts data into an existing table", priority=5, appliesTo={"table"})
public class InsertDataChangeMSSQL
extends InsertDataChange {
    private Boolean identityInsertEnabled;

    public Boolean getIdentityInsertEnabled() {
        return this.identityInsertEnabled;
    }

    public void setIdentityInsertEnabled(Boolean identityInsertEnabled) {
        this.identityInsertEnabled = identityInsertEnabled;
    }

    public SqlStatement[] generateStatements(Database database) {
        SqlStatement[] statements = super.generateStatements(database);
        if (!"Microsoft SQL Server".equals(database.getDatabaseProductName())) {
            return statements;
        }
        ArrayList<InsertStatementMSSQL> wrappedStatements = new ArrayList<InsertStatementMSSQL>(statements.length);
        for (SqlStatement statement : statements) {
            if (statement instanceof InsertStatement) {
                wrappedStatements.add(new InsertStatementMSSQL((InsertStatement)statement, this.identityInsertEnabled));
                continue;
            }
            wrappedStatements.add((InsertStatementMSSQL)statement);
        }
        return wrappedStatements.toArray(new SqlStatement[0]);
    }

    public boolean supports(Database database) {
        return database instanceof MSSQLDatabase;
    }
}

