/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.FilterType;
import ar.com.hjg.pngj.IImageLine;
import ar.com.hjg.pngj.IImageLineSet;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLineInt;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngjOutputException;
import ar.com.hjg.pngj.chunks.ChunkCopyBehaviour;
import ar.com.hjg.pngj.chunks.ChunkPredicate;
import ar.com.hjg.pngj.chunks.ChunksList;
import ar.com.hjg.pngj.chunks.ChunksListForWrite;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkIEND;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import ar.com.hjg.pngj.chunks.PngMetadata;
import ar.com.hjg.pngj.pixels.PixelsWriter;
import ar.com.hjg.pngj.pixels.PixelsWriterDefault;
import java.io.File;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngWriter {
    public final ImageInfo imgInfo;
    protected int rowNum = -1;
    private final ChunksListForWrite chunksList;
    private final PngMetadata metadata;
    protected int currentChunkGroup = -1;
    private int passes = 1;
    private int currentpass = 0;
    private boolean shouldCloseStream = true;
    private int idatMaxSize = 0;
    protected PixelsWriter pixelsWriter;
    private final OutputStream os;
    private ChunkPredicate copyFromPredicate = null;
    private ChunksList copyFromList = null;
    protected StringBuilder debuginfo = new StringBuilder();

    public PngWriter(File file, ImageInfo imgInfo, boolean allowoverwrite) {
        this(PngHelperInternal.ostreamFromFile(file, allowoverwrite), imgInfo);
        this.setShouldCloseStream(true);
    }

    public PngWriter(File file, ImageInfo imgInfo) {
        this(file, imgInfo, true);
    }

    public PngWriter(OutputStream outputStream, ImageInfo imgInfo) {
        this.os = outputStream;
        this.imgInfo = imgInfo;
        this.chunksList = new ChunksListForWrite(imgInfo);
        this.metadata = new PngMetadata(this.chunksList);
        this.pixelsWriter = this.createPixelsWriter(imgInfo);
        this.setCompLevel(9);
    }

    private void initIdat() {
        this.pixelsWriter.setOs(this.os);
        this.pixelsWriter.setIdatMaxSize(this.idatMaxSize);
        this.writeSignatureAndIHDR();
        this.writeFirstChunks();
    }

    private void writeEndChunk() {
        this.currentChunkGroup = 6;
        PngChunkIEND c = new PngChunkIEND(this.imgInfo);
        c.createRawChunk().writeChunk(this.os);
        this.chunksList.getChunks().add(c);
    }

    private void writeFirstChunks() {
        if (this.currentChunkGroup >= 4) {
            return;
        }
        int nw = 0;
        this.currentChunkGroup = 1;
        this.queueChunksFromOther();
        nw = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        this.currentChunkGroup = 2;
        nw = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        if (nw > 0 && this.imgInfo.greyscale) {
            throw new PngjOutputException("cannot write palette for this format");
        }
        if (nw == 0 && this.imgInfo.indexed) {
            throw new PngjOutputException("missing palette");
        }
        this.currentChunkGroup = 3;
        nw = this.chunksList.writeChunks(this.os, this.currentChunkGroup);
    }

    private void writeLastChunks() {
        this.currentChunkGroup = 5;
        this.queueChunksFromOther();
        this.chunksList.writeChunks(this.os, this.currentChunkGroup);
        List<PngChunk> pending = this.chunksList.getQueuedChunks();
        if (!pending.isEmpty()) {
            throw new PngjOutputException(pending.size() + " chunks were not written! Eg: " + pending.get(0).toString());
        }
    }

    private void writeSignatureAndIHDR() {
        PngHelperInternal.writeBytes(this.os, PngHelperInternal.getPngIdSignature());
        this.currentChunkGroup = 0;
        PngChunkIHDR ihdr = new PngChunkIHDR(this.imgInfo);
        ihdr.createRawChunk().writeChunk(this.os);
        this.chunksList.getChunks().add(ihdr);
    }

    private void queueChunksFromOther() {
        if (this.copyFromList == null || this.copyFromPredicate == null) {
            return;
        }
        boolean idatDone = this.currentChunkGroup >= 4;
        for (PngChunk chunk : this.copyFromList.getChunks()) {
            boolean copy;
            int groupOri;
            if (chunk.getRaw().data == null || (groupOri = chunk.getChunkGroup()) <= 4 && idatDone || groupOri >= 4 && !idatDone || chunk.crit && !chunk.id.equals("PLTE") || !(copy = this.copyFromPredicate.match(chunk)) || !this.chunksList.getEquivalent(chunk).isEmpty() || !this.chunksList.getQueuedEquivalent(chunk).isEmpty()) continue;
            this.chunksList.queue(chunk);
        }
    }

    public void queueChunk(PngChunk chunk) {
        for (PngChunk other : this.chunksList.getQueuedEquivalent(chunk)) {
            this.getChunksList().removeChunk(other);
        }
        this.chunksList.queue(chunk);
    }

    public void copyChunksFrom(ChunksList chunks, int copyMask) {
        this.copyChunksFrom(chunks, ChunkCopyBehaviour.createPredicate(copyMask, this.imgInfo));
    }

    public void copyChunksFrom(ChunksList chunks) {
        this.copyChunksFrom(chunks, 8);
    }

    public void copyChunksFrom(ChunksList chunks, ChunkPredicate predicate) {
        if (this.copyFromList != null && chunks != null) {
            PngHelperInternal.LOGGER.warning("copyChunksFrom should only be called once");
        }
        if (predicate == null) {
            throw new PngjOutputException("copyChunksFrom requires a predicate");
        }
        this.copyFromList = chunks;
        this.copyFromPredicate = predicate;
    }

    public double computeCompressionRatio() {
        if (this.currentChunkGroup < 5) {
            throw new PngjOutputException("must be called after end()");
        }
        return this.pixelsWriter.getCompression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        if (this.rowNum != this.imgInfo.rows - 1 || !this.pixelsWriter.isDone()) {
            throw new PngjOutputException("all rows have not been written");
        }
        try {
            if (this.pixelsWriter != null) {
                this.pixelsWriter.close();
            }
            if (this.currentChunkGroup < 5) {
                this.writeLastChunks();
            }
            if (this.currentChunkGroup < 6) {
                this.writeEndChunk();
            }
        }
        finally {
            this.close();
        }
    }

    public void close() {
        if (this.pixelsWriter != null) {
            this.pixelsWriter.close();
        }
        if (this.shouldCloseStream && this.os != null) {
            try {
                this.os.close();
            }
            catch (Exception e) {
                PngHelperInternal.LOGGER.warning("Error closing writer " + e.toString());
            }
        }
    }

    public ChunksListForWrite getChunksList() {
        return this.chunksList;
    }

    public PngMetadata getMetadata() {
        return this.metadata;
    }

    public void setFilterType(FilterType filterType) {
        this.pixelsWriter.setFilterType(filterType);
    }

    public void setCompLevel(int complevel) {
        this.pixelsWriter.setDeflaterCompLevel(complevel);
    }

    public void setFilterPreserve(boolean filterPreserve) {
        if (filterPreserve) {
            this.pixelsWriter.setFilterType(FilterType.FILTER_PRESERVE);
        } else if (this.pixelsWriter.getFilterType() == null) {
            this.pixelsWriter.setFilterType(FilterType.FILTER_DEFAULT);
        }
    }

    public void setIdatMaxSize(int idatMaxSize) {
        this.idatMaxSize = idatMaxSize;
    }

    public void setShouldCloseStream(boolean shouldCloseStream) {
        this.shouldCloseStream = shouldCloseStream;
    }

    public void writeRow(IImageLine imgline) {
        this.writeRow(imgline, this.rowNum + 1);
    }

    public void writeRows(IImageLineSet<? extends IImageLine> imglines) {
        for (int i = 0; i < this.imgInfo.rows; ++i) {
            this.writeRow(imglines.getImageLineRawNum(i));
        }
    }

    public void writeRow(IImageLine imgline, int rownumber) {
        ++this.rowNum;
        if (this.rowNum == this.imgInfo.rows) {
            this.rowNum = 0;
        }
        if (rownumber == this.imgInfo.rows) {
            rownumber = 0;
        }
        if (rownumber >= 0 && this.rowNum != rownumber) {
            throw new PngjOutputException("rows must be written in order: expected:" + this.rowNum + " passed:" + rownumber);
        }
        if (this.rowNum == 0) {
            ++this.currentpass;
        }
        if (rownumber == 0 && this.currentpass == this.passes) {
            this.initIdat();
            this.currentChunkGroup = 4;
        }
        byte[] rowb = this.pixelsWriter.getRowb();
        imgline.writeToPngRaw(rowb);
        this.pixelsWriter.processRow(rowb);
    }

    public void writeRowInt(int[] buf) {
        this.writeRow(new ImageLineInt(this.imgInfo, buf));
    }

    protected PixelsWriter createPixelsWriter(ImageInfo imginfo) {
        PixelsWriterDefault pw = new PixelsWriterDefault(imginfo);
        return pw;
    }

    public final PixelsWriter getPixelsWriter() {
        return this.pixelsWriter;
    }

    public String getDebuginfo() {
        return this.debuginfo.toString();
    }
}

