/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.chunks;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkSingle;

public class PngChunkACTL
extends PngChunkSingle {
    public static final String ID = "acTL";
    private int numFrames;
    private int numPlays;

    public PngChunkACTL(ImageInfo info) {
        super(ID, info);
    }

    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    public ChunkRaw createRawChunk() {
        ChunkRaw c = this.createEmptyChunk(8, true);
        PngHelperInternal.writeInt4tobytes(this.numFrames, c.data, 0);
        PngHelperInternal.writeInt4tobytes(this.numPlays, c.data, 4);
        return c;
    }

    public void parseFromRaw(ChunkRaw chunk) {
        this.numFrames = PngHelperInternal.readInt4fromBytes(chunk.data, 0);
        this.numPlays = PngHelperInternal.readInt4fromBytes(chunk.data, 4);
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public void setNumFrames(int numFrames) {
        this.numFrames = numFrames;
    }

    public int getNumPlays() {
        return this.numPlays;
    }

    public void setNumPlays(int numPlays) {
        this.numPlays = numPlays;
    }
}

