/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj.pixels;

public final class DeflaterEstimatorHjg {
    static final int MEMORY_USAGE = 14;
    static final int NOT_COMPRESSIBLE_DETECTION_LEVEL = 6;
    static final int MIN_MATCH = 4;
    static final int HASH_LOG = 12;
    static final int HASH_TABLE_SIZE = 4096;
    static final int SKIP_STRENGTH = Math.max(6, 2);
    static final int COPY_LENGTH = 8;
    static final int LAST_LITERALS = 5;
    static final int MF_LIMIT = 12;
    static final int MIN_LENGTH = 13;
    static final int MAX_DISTANCE = 65536;
    static final int ML_BITS = 4;
    static final int ML_MASK = 15;
    static final int RUN_BITS = 4;
    static final int RUN_MASK = 15;
    static final int LZ4_64K_LIMIT = 65547;
    static final int HASH_LOG_64K = 13;
    static final int HASH_TABLE_SIZE_64K = 8192;
    static final int HASH_LOG_HC = 15;
    static final int HASH_TABLE_SIZE_HC = 32768;
    static final int OPTIMAL_ML = 18;

    public int compressEstim(byte[] src, int srcOff, int srcLen) {
        if (srcLen < 10) {
            return srcLen;
        }
        int stride = 65546;
        int segments = (srcLen + stride - 1) / stride;
        if ((stride = srcLen / segments) >= 65546 || stride * segments > srcLen || segments < 1 || stride < 1) {
            throw new RuntimeException("?? " + srcLen);
        }
        int bytesIn = 0;
        int bytesOut = 0;
        int len = srcLen;
        while (len > 0) {
            if (len > stride) {
                len = stride;
            }
            bytesOut += DeflaterEstimatorHjg.compress64k(src, srcOff, len);
            srcOff += len;
            len = srcLen - (bytesIn += len);
        }
        double ratio = (double)bytesOut / (double)bytesIn;
        return bytesIn == srcLen ? bytesOut : (int)(ratio * (double)srcLen + 0.5);
    }

    public int compressEstim(byte[] src) {
        return this.compressEstim(src, 0, src.length);
    }

    static int compress64k(byte[] src, int srcOff, int srcLen) {
        int runLen;
        int srcEnd = srcOff + srcLen;
        int srcLimit = srcEnd - 5;
        int mflimit = srcEnd - 12;
        int sOff = srcOff;
        int dOff = 0;
        int anchor = sOff++;
        if (srcLen >= 13) {
            short[] hashTable = new short[8192];
            block0: while (true) {
                int ref;
                int forwardOff = sOff;
                int findMatchAttempts1 = (1 << SKIP_STRENGTH) + 3;
                do {
                    sOff = forwardOff;
                    if ((forwardOff += findMatchAttempts1++ >>> SKIP_STRENGTH) > mflimit) break block0;
                    int h = DeflaterEstimatorHjg.hash64k(DeflaterEstimatorHjg.readInt(src, sOff));
                    ref = srcOff + DeflaterEstimatorHjg.readShort(hashTable, h);
                    DeflaterEstimatorHjg.writeShort(hashTable, h, sOff - srcOff);
                } while (!DeflaterEstimatorHjg.readIntEquals(src, ref, sOff));
                int excess = DeflaterEstimatorHjg.commonBytesBackward(src, ref, sOff, srcOff, anchor);
                ref -= excess;
                int runLen2 = (sOff -= excess) - anchor;
                ++dOff;
                if (runLen2 >= 15) {
                    if (runLen2 > 15) {
                        dOff += (runLen2 - 15) / 255;
                    }
                    ++dOff;
                }
                dOff += runLen2;
                while (true) {
                    dOff += 2;
                    int matchLen = DeflaterEstimatorHjg.commonBytes(src, ref += 4, sOff += 4, srcLimit);
                    sOff += matchLen;
                    if (matchLen >= 15) {
                        if (matchLen >= 270) {
                            dOff += (matchLen - 15) / 255;
                        }
                        ++dOff;
                    }
                    if (sOff > mflimit) {
                        anchor = sOff;
                        break block0;
                    }
                    DeflaterEstimatorHjg.writeShort(hashTable, DeflaterEstimatorHjg.hash64k(DeflaterEstimatorHjg.readInt(src, sOff - 2)), sOff - 2 - srcOff);
                    int h = DeflaterEstimatorHjg.hash64k(DeflaterEstimatorHjg.readInt(src, sOff));
                    ref = srcOff + DeflaterEstimatorHjg.readShort(hashTable, h);
                    DeflaterEstimatorHjg.writeShort(hashTable, h, sOff - srcOff);
                    if (!DeflaterEstimatorHjg.readIntEquals(src, sOff, ref)) break;
                    ++dOff;
                }
                anchor = sOff++;
            }
        }
        if ((runLen = srcEnd - anchor) >= 270) {
            dOff += (runLen - 15) / 255;
        }
        ++dOff;
        return dOff += runLen;
    }

    static final int maxCompressedLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0, got " + length);
        }
        return length + length / 255 + 16;
    }

    static int hash(int i) {
        return i * -1640531535 >>> 20;
    }

    static int hash64k(int i) {
        return i * -1640531535 >>> 19;
    }

    static int readShortLittleEndian(byte[] buf, int i) {
        return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8;
    }

    static boolean readIntEquals(byte[] buf, int i, int j) {
        return buf[i] == buf[j] && buf[i + 1] == buf[j + 1] && buf[i + 2] == buf[j + 2] && buf[i + 3] == buf[j + 3];
    }

    static int commonBytes(byte[] b, int o1, int o2, int limit) {
        int count = 0;
        while (o2 < limit && b[o1++] == b[o2++]) {
            ++count;
        }
        return count;
    }

    static int commonBytesBackward(byte[] b, int o1, int o2, int l1, int l2) {
        int count = 0;
        while (o1 > l1 && o2 > l2 && b[--o1] == b[--o2]) {
            ++count;
        }
        return count;
    }

    static int readShort(short[] buf, int off) {
        return buf[off] & 0xFFFF;
    }

    static byte readByte(byte[] buf, int i) {
        return buf[i];
    }

    static void checkRange(byte[] buf, int off) {
        if (off < 0 || off >= buf.length) {
            throw new ArrayIndexOutOfBoundsException(off);
        }
    }

    static void checkRange(byte[] buf, int off, int len) {
        DeflaterEstimatorHjg.checkLength(len);
        if (len > 0) {
            DeflaterEstimatorHjg.checkRange(buf, off);
            DeflaterEstimatorHjg.checkRange(buf, off + len - 1);
        }
    }

    static void checkLength(int len) {
        if (len < 0) {
            throw new IllegalArgumentException("lengths must be >= 0");
        }
    }

    static int readIntBE(byte[] buf, int i) {
        return (buf[i] & 0xFF) << 24 | (buf[i + 1] & 0xFF) << 16 | (buf[i + 2] & 0xFF) << 8 | buf[i + 3] & 0xFF;
    }

    static int readIntLE(byte[] buf, int i) {
        return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | (buf[i + 3] & 0xFF) << 24;
    }

    static int readInt(byte[] buf, int i) {
        return DeflaterEstimatorHjg.readIntBE(buf, i);
    }

    static void writeShort(short[] buf, int off, int v) {
        buf[off] = (short)v;
    }
}

