/*
 * Decompiled with CFR 0.152.
 */
package com.github.sahasbhop.apngview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.SystemClock;
import android.view.View;
import android.widget.ImageView;
import ar.com.hjg.pngj.PngReaderApng;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkACTL;
import ar.com.hjg.pngj.chunks.PngChunkFCTL;
import com.github.sahasbhop.apngview.ApngImageLoader;
import com.github.sahasbhop.apngview.assist.ApngExtractFrames;
import com.github.sahasbhop.apngview.assist.AssistUtil;
import com.github.sahasbhop.apngview.assist.PngImageLoader;
import com.github.sahasbhop.flog.FLog;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ApngDrawable
extends Drawable
implements Animatable,
Runnable {
    private static final float DELAY_FACTOR = 1000.0f;
    private final Uri sourceUri;
    private ArrayList<PngChunkFCTL> fctlArrayList = new ArrayList();
    private Bitmap baseBitmap;
    private Bitmap[] bitmapArray;
    private DisplayImageOptions displayImageOptions;
    private PngImageLoader imageLoader;
    private Paint paint = new Paint();
    private String workingPath;
    private boolean isPrepared = false;
    private boolean isRunning = false;
    private int baseWidth;
    private int baseHeight;
    private int currentFrame = -1;
    private int currentLoop = 0;
    private int numFrames;
    private int numPlays;
    private float mScaling = 0.0f;
    private File baseFile;

    public ApngDrawable(Context context, Bitmap bitmap, Uri uri) {
        this.paint.setAntiAlias(true);
        this.displayImageOptions = new DisplayImageOptions.Builder().cacheInMemory(false).cacheOnDisk(true).build();
        File workingDir = AssistUtil.getWorkingDir(context);
        this.workingPath = workingDir.getPath();
        this.sourceUri = uri;
        this.imageLoader = PngImageLoader.getInstance();
        this.baseBitmap = bitmap;
        this.baseWidth = bitmap.getWidth();
        this.baseHeight = bitmap.getHeight();
        if (ApngImageLoader.enableDebugLog) {
            FLog.d((String)"Uri: %s", (Object[])new Object[]{this.sourceUri});
        }
        if (ApngImageLoader.enableDebugLog) {
            FLog.d((String)"Bitmap size: %dx%d", (Object[])new Object[]{this.baseWidth, this.baseHeight});
        }
    }

    public static ApngDrawable getFromView(View view) {
        if (view == null || !(view instanceof ImageView)) {
            return null;
        }
        Drawable drawable = ((ImageView)view).getDrawable();
        if (drawable == null || !(drawable instanceof ApngDrawable)) {
            return null;
        }
        return (ApngDrawable)drawable;
    }

    public int getNumPlays() {
        return this.numPlays;
    }

    public void setNumPlays(int numPlays) {
        this.numPlays = numPlays;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public void start() {
        if (!this.isRunning()) {
            this.isRunning = true;
            this.currentFrame = 0;
            if (!this.isPrepared) {
                if (ApngImageLoader.enableVerboseLog) {
                    FLog.v((String)"Prepare", (Object[])new Object[0]);
                }
                this.prepare();
            }
            if (this.isPrepared) {
                if (ApngImageLoader.enableVerboseLog) {
                    FLog.v((String)"Run", (Object[])new Object[0]);
                }
                this.run();
            } else {
                this.stop();
            }
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.currentLoop = 0;
            this.unscheduleSelf(this);
            this.isRunning = false;
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void run() {
        if (this.currentFrame < 0) {
            this.currentFrame = 0;
        } else if (this.currentFrame > this.fctlArrayList.size() - 1) {
            this.currentFrame = 0;
        }
        PngChunkFCTL pngChunk = this.fctlArrayList.get(this.currentFrame);
        int delayNum = pngChunk.getDelayNum();
        int delayDen = pngChunk.getDelayDen();
        int delay = Math.round((float)delayNum * 1000.0f / (float)delayDen);
        this.scheduleSelf(this, SystemClock.uptimeMillis() + (long)delay);
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        if (ApngImageLoader.enableVerboseLog) {
            FLog.v((String)"Current frame: %d", (Object[])new Object[]{this.currentFrame});
        }
        if (this.currentFrame <= 0) {
            this.drawBaseBitmap(canvas);
        } else {
            this.drawAnimateBitmap(canvas, this.currentFrame);
        }
        if (this.numPlays > 0 && this.currentLoop >= this.numPlays) {
            this.stop();
        }
        if (this.numPlays > 0 && this.currentFrame == this.numFrames - 1) {
            ++this.currentLoop;
            if (ApngImageLoader.enableVerboseLog) {
                FLog.v((String)"Loop count: %d/%d", (Object[])new Object[]{this.currentLoop, this.numPlays});
            }
        }
        ++this.currentFrame;
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.paint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public void recycleBitmaps() {
        if (this.bitmapArray == null) {
            return;
        }
        for (int i = 1; i < this.bitmapArray.length; ++i) {
            if (this.bitmapArray[i] == null) continue;
            this.bitmapArray[i].recycle();
            this.bitmapArray[i] = null;
        }
    }

    private void readApngInformation(File baseFile) {
        PngReaderApng reader = new PngReaderApng(baseFile);
        reader.end();
        List pngChunks = reader.getChunksList().getChunks();
        for (int i = 0; i < pngChunks.size(); ++i) {
            PngChunk chunk = (PngChunk)pngChunks.get(i);
            if (chunk instanceof PngChunkACTL) {
                this.numFrames = ((PngChunkACTL)chunk).getNumFrames();
                if (ApngImageLoader.enableDebugLog) {
                    FLog.d((String)"numFrames: %d", (Object[])new Object[]{this.numFrames});
                }
                if (this.numPlays > 0) {
                    if (!ApngImageLoader.enableDebugLog) continue;
                    FLog.d((String)"numPlays: %d (user defined)", (Object[])new Object[]{this.numPlays});
                    continue;
                }
                this.numPlays = ((PngChunkACTL)chunk).getNumPlays();
                if (!ApngImageLoader.enableDebugLog) continue;
                FLog.d((String)"numPlays: %d (media info)", (Object[])new Object[]{this.numPlays});
                continue;
            }
            if (!(chunk instanceof PngChunkFCTL)) continue;
            this.fctlArrayList.add((PngChunkFCTL)chunk);
        }
        this.bitmapArray = new Bitmap[this.fctlArrayList.size()];
    }

    private void drawBaseBitmap(Canvas canvas) {
        if (this.mScaling == 0.0f) {
            int width = canvas.getWidth();
            int height = canvas.getHeight();
            if (ApngImageLoader.enableVerboseLog) {
                FLog.v((String)"Canvas: %dx%d", (Object[])new Object[]{width, height});
            }
            float scalingByWidth = (float)canvas.getWidth() / (float)this.baseWidth;
            if (ApngImageLoader.enableVerboseLog) {
                FLog.v((String)"scalingByWidth: %.2f", (Object[])new Object[]{Float.valueOf(scalingByWidth)});
            }
            float scalingByHeight = (float)canvas.getHeight() / (float)this.baseHeight;
            if (ApngImageLoader.enableVerboseLog) {
                FLog.v((String)"scalingByHeight: %.2f", (Object[])new Object[]{Float.valueOf(scalingByHeight)});
            }
            float f = this.mScaling = scalingByWidth <= scalingByHeight ? scalingByWidth : scalingByHeight;
            if (ApngImageLoader.enableVerboseLog) {
                FLog.v((String)"mScaling: %.2f", (Object[])new Object[]{Float.valueOf(this.mScaling)});
            }
        }
        RectF dst = new RectF(0.0f, 0.0f, this.mScaling * (float)this.baseWidth, this.mScaling * (float)this.baseHeight);
        canvas.drawBitmap(this.baseBitmap, null, dst, this.paint);
        if (this.bitmapArray != null) {
            this.bitmapArray[0] = this.baseBitmap;
        }
    }

    private void drawAnimateBitmap(Canvas canvas, int frameIndex) {
        if (this.bitmapArray != null && this.bitmapArray.length > frameIndex) {
            if (this.bitmapArray[frameIndex] == null) {
                this.bitmapArray[frameIndex] = this.createAnimateBitmap(frameIndex);
            }
            if (this.bitmapArray[frameIndex] == null) {
                return;
            }
            RectF dst = new RectF(0.0f, 0.0f, this.mScaling * (float)this.bitmapArray[frameIndex].getWidth(), this.mScaling * (float)this.bitmapArray[frameIndex].getHeight());
            canvas.drawBitmap(this.bitmapArray[frameIndex], null, dst, this.paint);
        }
    }

    private Bitmap createAnimateBitmap(int frameIndex) {
        PngChunkFCTL previousChunk;
        if (ApngImageLoader.enableVerboseLog) {
            FLog.v((String)"ENTER", (Object[])new Object[0]);
        }
        Bitmap bitmap = null;
        PngChunkFCTL pngChunkFCTL = previousChunk = frameIndex > 0 ? this.fctlArrayList.get(frameIndex - 1) : null;
        if (previousChunk != null) {
            bitmap = this.handleDisposeOperation(frameIndex, this.baseFile, previousChunk);
        }
        String path = new File(this.workingPath, ApngExtractFrames.getFileName(this.baseFile, frameIndex)).getPath();
        Bitmap frameBitmap = this.imageLoader.loadImageSync(Uri.fromFile((File)new File(path)).toString(), this.displayImageOptions);
        PngChunkFCTL chunk = this.fctlArrayList.get(frameIndex);
        byte blendOp = chunk.getBlendOp();
        int offsetX = chunk.getxOff();
        int offsetY = chunk.getyOff();
        Bitmap redrawnBitmap = this.handleBlendingOperation(offsetX, offsetY, blendOp, frameBitmap, bitmap);
        if (ApngImageLoader.enableVerboseLog) {
            FLog.v((String)"EXIT", (Object[])new Object[0]);
        }
        return redrawnBitmap;
    }

    private Bitmap handleDisposeOperation(int frameIndex, File baseFile, PngChunkFCTL previousChunk) {
        Bitmap bitmap = null;
        byte disposeOp = previousChunk.getDisposeOp();
        int offsetX = previousChunk.getxOff();
        int offsetY = previousChunk.getyOff();
        block0 : switch (disposeOp) {
            case 0: {
                bitmap = frameIndex > 0 ? this.bitmapArray[frameIndex - 1] : null;
                break;
            }
            case 1: {
                Bitmap bitmap2 = bitmap = frameIndex > 0 ? this.bitmapArray[frameIndex - 1] : null;
                if (bitmap == null) break;
                String tempPath = new File(this.workingPath, ApngExtractFrames.getFileName(baseFile, frameIndex - 1)).getPath();
                Bitmap frameBitmap = this.imageLoader.loadImageSync(Uri.fromFile((File)new File(tempPath)).toString(), this.displayImageOptions);
                if (ApngImageLoader.enableVerboseLog) {
                    FLog.v((String)"Create a new bitmap", (Object[])new Object[0]);
                }
                Bitmap tempBitmap = Bitmap.createBitmap((int)this.baseWidth, (int)this.baseHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas tempCanvas = new Canvas(tempBitmap);
                tempCanvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
                tempCanvas.clipRect(offsetX, offsetY, offsetX + frameBitmap.getWidth(), offsetY + frameBitmap.getHeight());
                tempCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
                tempCanvas.clipRect(0, 0, this.baseWidth, this.baseHeight);
                bitmap = tempBitmap;
                break;
            }
            case 2: {
                if (frameIndex <= 1) break;
                for (int i = frameIndex - 2; i >= 0; --i) {
                    PngChunkFCTL tempPngChunk = this.fctlArrayList.get(i);
                    byte tempDisposeOp = tempPngChunk.getDisposeOp();
                    int tempOffsetX = tempPngChunk.getxOff();
                    int tempOffsetY = tempPngChunk.getyOff();
                    String tempPath = new File(this.workingPath, ApngExtractFrames.getFileName(baseFile, i)).getPath();
                    Bitmap frameBitmap = this.imageLoader.loadImageSync(Uri.fromFile((File)new File(tempPath)).toString(), this.displayImageOptions);
                    if (tempDisposeOp == 2) continue;
                    if (tempDisposeOp == 0) {
                        bitmap = this.bitmapArray[i];
                        break block0;
                    }
                    if (tempDisposeOp != 1) break block0;
                    if (ApngImageLoader.enableVerboseLog) {
                        FLog.v((String)"Create a new bitmap", (Object[])new Object[0]);
                    }
                    Bitmap tempBitmap = Bitmap.createBitmap((int)this.baseWidth, (int)this.baseHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas tempCanvas = new Canvas(tempBitmap);
                    tempCanvas.drawBitmap(this.bitmapArray[i], 0.0f, 0.0f, null);
                    tempCanvas.clipRect(tempOffsetX, tempOffsetY, tempOffsetX + frameBitmap.getWidth(), tempOffsetY + frameBitmap.getHeight());
                    tempCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    tempCanvas.clipRect(0, 0, this.baseWidth, this.baseHeight);
                    bitmap = tempBitmap;
                    break block0;
                }
                break;
            }
        }
        return bitmap;
    }

    private void prepare() {
        String imagePath = this.getImagePathFromUri();
        if (imagePath == null) {
            return;
        }
        this.baseFile = new File(imagePath);
        if (!this.baseFile.exists()) {
            return;
        }
        if (ApngImageLoader.enableDebugLog) {
            FLog.d((String)"Extracting PNGs..", (Object[])new Object[0]);
        }
        ApngExtractFrames.process(this.baseFile);
        if (ApngImageLoader.enableDebugLog) {
            FLog.d((String)"Extracting complete", (Object[])new Object[0]);
        }
        if (ApngImageLoader.enableDebugLog) {
            FLog.d((String)"Read APNG information..", (Object[])new Object[0]);
        }
        this.readApngInformation(this.baseFile);
        this.isPrepared = true;
    }

    private String getImagePathFromUri() {
        if (this.sourceUri == null) {
            return null;
        }
        String imagePath = null;
        try {
            String filename = this.sourceUri.getLastPathSegment();
            File file = new File(this.workingPath, filename);
            if (!file.exists()) {
                if (ApngImageLoader.enableVerboseLog) {
                    FLog.v((String)"Copy file from %s to %s", (Object[])new Object[]{this.sourceUri.getPath(), file.getPath()});
                }
                FileUtils.copyFile((File)new File(this.sourceUri.getPath()), (File)file);
            }
            imagePath = file.getPath();
        }
        catch (Exception e) {
            FLog.e((String)"Error: %s", (Object[])new Object[]{e.toString()});
        }
        return imagePath;
    }

    private Bitmap handleBlendingOperation(int offsetX, int offsetY, byte blendOp, Bitmap frameBitmap, Bitmap baseBitmap) {
        if (ApngImageLoader.enableVerboseLog) {
            FLog.v((String)"Create a new bitmap", (Object[])new Object[0]);
        }
        Bitmap redrawnBitmap = Bitmap.createBitmap((int)this.baseWidth, (int)this.baseHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(redrawnBitmap);
        if (baseBitmap != null) {
            canvas.drawBitmap(baseBitmap, 0.0f, 0.0f, null);
            if (blendOp == 0) {
                canvas.clipRect(offsetX, offsetY, offsetX + frameBitmap.getWidth(), offsetY + frameBitmap.getHeight());
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                canvas.clipRect(0, 0, this.baseWidth, this.baseHeight);
            }
        }
        canvas.drawBitmap(frameBitmap, (float)offsetX, (float)offsetY, null);
        return redrawnBitmap;
    }
}

