/*
 * Decompiled with CFR 0.152.
 */
package com.github.sahasbhop.apngview;

import android.content.Context;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import com.github.sahasbhop.apngview.ApngDrawable;
import com.github.sahasbhop.apngview.assist.ApngImageDownloader;
import com.github.sahasbhop.apngview.assist.ApngImageLoaderCallback;
import com.github.sahasbhop.apngview.assist.ApngImageLoadingListener;
import com.github.sahasbhop.apngview.assist.PngImageLoader;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import com.nostra13.universalimageloader.cache.memory.impl.LruMemoryCache;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;

public class ApngImageLoader
extends ImageLoader {
    public static boolean enableVerboseLog = false;
    public static boolean enableDebugLog = false;
    private static ApngImageLoader singleton;
    private Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApngImageLoader getInstance() {
        if (singleton != null) return singleton;
        Class<ApngImageLoader> clazz = ApngImageLoader.class;
        synchronized (ApngImageLoader.class) {
            if (singleton != null) return singleton;
            singleton = new ApngImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    protected ApngImageLoader() {
    }

    public void init(Context context) {
        this.init(context, null, null);
    }

    public void init(Context context, ImageLoaderConfiguration commonImageLoaderConfiguration, ImageLoaderConfiguration apngComponentImageLoaderConfiguration) {
        this.context = context.getApplicationContext();
        if (commonImageLoaderConfiguration == null) {
            commonImageLoaderConfiguration = this.getDefaultCommonImageLoaderConfiguration();
        }
        if (apngComponentImageLoaderConfiguration == null) {
            apngComponentImageLoaderConfiguration = this.getDefaultApngComponentImageLoaderConfiguration(this.context);
        }
        PngImageLoader.getInstance().init(commonImageLoaderConfiguration);
        super.init(apngComponentImageLoaderConfiguration);
    }

    public void setEnableVerboseLog(boolean enableVerboseLog) {
        ApngImageLoader.enableVerboseLog = enableVerboseLog;
    }

    public void setEnableDebugLog(boolean enableDebugLog) {
        ApngImageLoader.enableDebugLog = enableDebugLog;
    }

    public void displayImage(String uri, ImageView imageView) {
        this.displayApng(uri, imageView, null);
    }

    public void displayImage(String uri, ImageView imageView, DisplayImageOptions options) {
        this.displayApng(uri, imageView, options, null);
    }

    public void displayApng(String uri, ImageView imageView, ApngConfig config) {
        super.displayImage(uri, imageView, (ImageLoadingListener)new ApngImageLoadingListener(this.context, Uri.parse((String)uri), this.getAutoPlayHandler(config)));
    }

    public void displayApng(String uri, ImageView imageView, DisplayImageOptions options, ApngConfig config) {
        super.displayImage(uri, imageView, options, (ImageLoadingListener)new ApngImageLoadingListener(this.context, Uri.parse((String)uri), this.getAutoPlayHandler(config)));
    }

    private ImageLoaderConfiguration getDefaultApngComponentImageLoaderConfiguration(Context context) {
        DisplayImageOptions defaultDisplayImageOptions = new DisplayImageOptions.Builder().cacheInMemory(false).cacheOnDisk(true).build();
        return new ImageLoaderConfiguration.Builder(context).memoryCache((MemoryCache)new LruMemoryCache(0x200000)).memoryCacheSize(0x200000).diskCacheSize(0x3200000).diskCacheFileCount(100).imageDownloader((ImageDownloader)new ApngImageDownloader(context)).defaultDisplayImageOptions(defaultDisplayImageOptions).build();
    }

    private ImageLoaderConfiguration getDefaultCommonImageLoaderConfiguration() {
        return new ImageLoaderConfiguration.Builder(this.context).memoryCache((MemoryCache)new LruMemoryCache(0x200000)).memoryCacheSize(0x200000).diskCacheSize(0x3200000).diskCacheFileCount(100).build();
    }

    private ApngImageLoaderCallback getAutoPlayHandler(final ApngConfig config) {
        if (config == null || !config.autoPlay) {
            return null;
        }
        return new ApngImageLoaderCallback(){

            @Override
            public void onLoadFinish(boolean success, String imageUri, View view) {
                if (!success) {
                    return;
                }
                ApngDrawable apngDrawable = ApngDrawable.getFromView(view);
                if (apngDrawable == null) {
                    return;
                }
                if (config.numPlays > 0) {
                    apngDrawable.setNumPlays(config.numPlays);
                }
                apngDrawable.start();
            }
        };
    }

    public static class ApngConfig {
        public int numPlays = 0;
        public boolean autoPlay = false;

        public ApngConfig(int numPlays, boolean autoPlay) {
            this.numPlays = numPlays;
            this.autoPlay = autoPlay;
        }
    }
}

