/*
 * Decompiled with CFR 0.152.
 */
package com.github.sahasbhop.apngview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import com.github.sahasbhop.apngview.ApngDrawable;
import com.github.sahasbhop.apngview.ApngHelper;
import com.github.sahasbhop.apngview.ApngImageLoader;
import com.github.sahasbhop.flog.FLog;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.utils.DiskCacheUtils;
import com.nostra13.universalimageloader.utils.MemoryCacheUtils;
import java.io.File;

public class ApngImageLoadingListener
implements ImageLoadingListener {
    private Context mContext;
    private Uri mUri;

    public ApngImageLoadingListener(Context context, Uri uri) {
        this.mContext = context;
        this.mUri = uri;
    }

    public void onLoadingStarted(String imageUri, View view) {
        view.setTag((Object)this.mUri.toString());
    }

    public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
        Object tag = view.getTag();
        FLog.d((String)"tag: %s", (Object[])new Object[]{tag});
        if (tag != null && tag instanceof String) {
            String actualUri = tag.toString();
            File pngFile = ApngHelper.getCopiedFile((Context)this.mContext, (String)actualUri);
            if (pngFile == null) {
                FLog.w((String)"Can't locate the file!!! %s", (Object[])new Object[]{actualUri});
            } else if (pngFile.exists()) {
                boolean isApng = ApngHelper.isApng((File)pngFile);
                if (isApng) {
                    FLog.d((String)"Setup apng drawable", (Object[])new Object[0]);
                    ApngDrawable drawable = new ApngDrawable(this.mContext, loadedImage, Uri.fromFile((File)pngFile));
                    ((ImageView)view).setImageDrawable((Drawable)drawable);
                } else {
                    ((ImageView)view).setImageBitmap(loadedImage);
                }
            } else {
                FLog.d((String)"Clear cache and reload", (Object[])new Object[0]);
                MemoryCacheUtils.removeFromCache((String)actualUri, (MemoryCache)ApngImageLoader.getInstance().getMemoryCache());
                DiskCacheUtils.removeFromCache((String)actualUri, (DiskCache)ApngImageLoader.getInstance().getDiskCache());
                ApngImageLoader.getInstance().displayImage(actualUri, (ImageView)view, this);
            }
        }
    }

    public void onLoadingCancelled(String imageUri, View view) {
        Object tag = view.getTag();
        FLog.d((String)"tag: %s", (Object[])new Object[]{tag});
        view.setTag(null);
    }

    public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
        Object tag = view.getTag();
        FLog.d((String)"tag: %s", (Object[])new Object[]{tag});
        view.setTag(null);
    }
}

