/*
 * Decompiled with CFR 0.152.
 */
package com.github.sahasbhop.apngview;

import android.support.annotation.NonNull;
import com.github.sahasbhop.flog.FLog;
import java.io.File;
import java.util.Arrays;

public class CacheManager {
    private static boolean VERBOSE = true;
    public static final long MAX_SIZE = 500000L;

    private CacheManager() {
    }

    public static void checkCahceSize(File cacheDir, long maxSize) {
        long cacheSize = CacheManager.getDirSize(cacheDir);
        if (VERBOSE) {
            FLog.v((String)"checkCacheSize: %d", (Object[])new Object[]{cacheSize});
        }
        if (maxSize < 1L && cacheSize >= 500000L) {
            CacheManager.cleanDir(cacheDir, cacheSize - 500000L);
        } else if (maxSize > 0L && cacheSize >= maxSize) {
            CacheManager.cleanDir(cacheDir, cacheSize - maxSize);
        }
    }

    private static void cleanDir(File dir, long bytes) {
        File[] files;
        long bytesDeleted = 0L;
        for (File file : files = CacheManager.listFilesSortingByDate(dir)) {
            bytesDeleted += file.length();
            boolean isSuccess = file.delete();
            if (VERBOSE) {
                FLog.v((String)"Delete(%s): %s", (Object[])new Object[]{isSuccess ? "success" : "failed", file.getPath()});
            }
            if (bytesDeleted >= bytes) break;
        }
    }

    private static long getDirSize(File dir) {
        File[] files;
        long size = 0L;
        for (File file : files = CacheManager.listFilesSortingByDate(dir)) {
            if (!file.isFile()) continue;
            size += file.length();
        }
        return size;
    }

    public static File[] listFilesSortingByDate(File directory) {
        int i;
        File[] files = directory.listFiles();
        Object[] pairs = new Pair[files.length];
        for (i = 0; i < files.length; ++i) {
            pairs[i] = new Pair(files[i]);
        }
        Arrays.sort(pairs);
        for (i = 0; i < files.length; ++i) {
            files[i] = ((Pair)pairs[i]).f;
        }
        return files;
    }

    static class Pair
    implements Comparable<Pair> {
        public long t;
        public File f;

        public Pair(File file) {
            this.f = file;
            this.t = file.lastModified();
        }

        @Override
        public int compareTo(@NonNull Pair o) {
            long u = o.t;
            return this.t < u ? -1 : (this.t == u ? 0 : 1);
        }
    }
}

