/*
 * Decompiled with CFR 0.152.
 */
package com.github.sahasbhop.apngview.assist;

import ar.com.hjg.pngj.ChunkReader;
import ar.com.hjg.pngj.ChunkSeqReaderPng;
import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.PngHelperInternal;
import ar.com.hjg.pngj.PngReader;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.chunks.ChunkHelper;
import ar.com.hjg.pngj.chunks.ChunkRaw;
import ar.com.hjg.pngj.chunks.PngChunk;
import ar.com.hjg.pngj.chunks.PngChunkFCTL;
import ar.com.hjg.pngj.chunks.PngChunkIEND;
import ar.com.hjg.pngj.chunks.PngChunkIHDR;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;

public class ApngExtractFrames {
    public static String getFileName(File sourceFile, int frameIndex) {
        String filename = sourceFile.getName();
        String baseName = FilenameUtils.getBaseName((String)filename);
        String extension = FilenameUtils.getExtension((String)filename);
        return String.format(Locale.ENGLISH, "%s_%03d.%s", baseName, frameIndex, extension);
    }

    public static int process(File orig) {
        PngReaderBuffered pngr = new PngReaderBuffered(orig);
        pngr.end();
        return pngr.frameIndex + 1;
    }

    static class PngReaderBuffered
    extends PngReader {
        private File orig;
        FileOutputStream fo = null;
        File dest;
        ImageInfo frameInfo;
        int frameIndex = -1;

        public PngReaderBuffered(File file) {
            super(file);
            this.orig = file;
        }

        protected ChunkSeqReaderPng createChunkSeqReader() {
            return new ChunkSeqReaderPng(false){

                public boolean shouldSkipContent(int len, String id2) {
                    return false;
                }

                protected boolean isIdatKind(String id2) {
                    return false;
                }

                protected void postProcessChunk(ChunkReader chunkR) {
                    super.postProcessChunk(chunkR);
                    try {
                        String id2 = chunkR.getChunkRaw().id;
                        PngChunk lastChunk = (PngChunk)this.chunksList.getChunks().get(this.chunksList.getChunks().size() - 1);
                        if (id2.equals("fcTL")) {
                            ++PngReaderBuffered.this.frameIndex;
                            PngReaderBuffered.this.frameInfo = ((PngChunkFCTL)lastChunk).getEquivImageInfo();
                            PngReaderBuffered.this.startNewFile();
                        }
                        if (id2.equals("fdAT") || id2.equals("IDAT")) {
                            if (id2.equals("IDAT")) {
                                if (PngReaderBuffered.this.fo != null) {
                                    chunkR.getChunkRaw().writeChunk((OutputStream)PngReaderBuffered.this.fo);
                                }
                            } else {
                                ChunkRaw crawi = new ChunkRaw(chunkR.getChunkRaw().len - 4, ChunkHelper.b_IDAT, true);
                                System.arraycopy(chunkR.getChunkRaw().data, 4, crawi.data, 0, crawi.data.length);
                                crawi.writeChunk((OutputStream)PngReaderBuffered.this.fo);
                            }
                            chunkR.getChunkRaw().data = null;
                        }
                        if (id2.equals("IEND") && PngReaderBuffered.this.fo != null) {
                            PngReaderBuffered.this.endFile();
                        }
                    }
                    catch (Exception e) {
                        throw new PngjException((Throwable)e);
                    }
                }
            };
        }

        private void startNewFile() throws Exception {
            if (this.fo != null) {
                this.endFile();
            }
            this.dest = this.createOutputName();
            this.fo = new FileOutputStream(this.dest);
            this.fo.write(PngHelperInternal.getPngIdSignature());
            PngChunkIHDR ihdr = new PngChunkIHDR(this.frameInfo);
            ihdr.createRawChunk().writeChunk((OutputStream)this.fo);
            for (PngChunk chunk : this.getChunksList(false).getChunks()) {
                String id2 = chunk.id;
                if (id2.equals("IHDR") || id2.equals("fcTL") || id2.equals("acTL")) continue;
                if (id2.equals("IDAT")) break;
                chunk.getRaw().writeChunk((OutputStream)this.fo);
            }
        }

        private void endFile() throws IOException {
            new PngChunkIEND(null).createRawChunk().writeChunk((OutputStream)this.fo);
            this.fo.close();
            this.fo = null;
        }

        private File createOutputName() {
            return new File(this.orig.getParent(), ApngExtractFrames.getFileName(this.orig, this.frameIndex));
        }
    }
}

