/*
 * Decompiled with CFR 0.152.
 */
package com.github.sahasbhop.apngview.assist;

import android.content.Context;
import android.net.Uri;
import com.github.sahasbhop.apngview.ApngImageLoader;
import com.github.sahasbhop.apngview.assist.AssistUtil;
import com.github.sahasbhop.flog.FLog;
import com.nostra13.universalimageloader.core.assist.ContentLengthInputStream;
import com.nostra13.universalimageloader.core.download.BaseImageDownloader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;

public class ApngImageDownloader
extends BaseImageDownloader {
    private static final int BUFFER_SIZE = 32768;
    private Context mContext;
    private ExecutorService mExecutor;

    public ApngImageDownloader(Context context) {
        super(context);
        this.mContext = context;
        this.mExecutor = Executors.newSingleThreadExecutor();
    }

    protected InputStream getStreamFromFile(final String imageUri, Object extra) throws IOException {
        InputStream result;
        block2: {
            final InputStream imageStream = super.getStreamFromFile(imageUri, extra);
            Future<InputStream> future = this.mExecutor.submit(new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return ApngImageDownloader.this.processImage(imageUri, imageStream);
                }
            });
            result = null;
            try {
                result = future.get();
            }
            catch (Exception e) {
                if (!ApngImageLoader.enableDebugLog) break block2;
                FLog.w((String)"Error: %s", (Object[])new Object[]{e.toString()});
            }
        }
        return result;
    }

    protected InputStream getStreamFromAssets(final String imageUri, Object extra) throws IOException {
        InputStream result;
        block2: {
            final InputStream imageStream = super.getStreamFromAssets(imageUri, extra);
            Future<InputStream> future = this.mExecutor.submit(new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return ApngImageDownloader.this.processImage(imageUri, imageStream);
                }
            });
            result = null;
            try {
                result = future.get();
            }
            catch (Exception e) {
                if (!ApngImageLoader.enableDebugLog) break block2;
                FLog.w((String)"Error: %s", (Object[])new Object[]{e.toString()});
            }
        }
        return result;
    }

    protected InputStream getStreamFromNetwork(final String imageUri, Object extra) throws IOException {
        InputStream result;
        block2: {
            final InputStream imageStream = super.getStreamFromNetwork(imageUri, extra);
            Future<InputStream> future = this.mExecutor.submit(new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return ApngImageDownloader.this.processImage(imageUri, imageStream);
                }
            });
            result = null;
            try {
                result = future.get();
            }
            catch (Exception e) {
                if (!ApngImageLoader.enableDebugLog) break block2;
                FLog.w((String)"Error: %s", (Object[])new Object[]{e.toString()});
            }
        }
        return result;
    }

    private InputStream processImage(String imageUri, InputStream imageStream) {
        block14: {
            if (imageUri == null || imageStream == null) {
                return imageStream;
            }
            boolean isPng = false;
            try {
                Uri url = Uri.parse((String)imageUri);
                String path = url.getPath();
                isPng = path != null && path.endsWith(".png");
            }
            catch (Exception url) {
                // empty catch block
            }
            if (!isPng) {
                return imageStream;
            }
            File cacheDir = AssistUtil.getWorkingDir(this.mContext);
            AssistUtil.checkCahceSize(cacheDir, 0L);
            File targetFile = AssistUtil.getCopiedFile(this.mContext, imageUri);
            if (targetFile == null) {
                if (ApngImageLoader.enableDebugLog) {
                    FLog.w((String)"Can't copy a file!!! %s", (Object[])new Object[]{imageUri});
                }
            } else if (!targetFile.exists()) {
                if (ApngImageLoader.enableVerboseLog) {
                    FLog.v((String)"Copy\nfrom: %s\nto: %s", (Object[])new Object[]{imageUri, targetFile.getPath()});
                }
                try {
                    try {
                        URL url = new URL(imageUri);
                        FileUtils.copyURLToFile((URL)url, (File)targetFile);
                    }
                    catch (MalformedURLException e) {
                        FileUtils.copyInputStreamToFile((InputStream)imageStream, (File)targetFile);
                    }
                    if (ApngImageLoader.enableVerboseLog) {
                        FLog.v((String)"Copy finished", (Object[])new Object[0]);
                    }
                    FileInputStream input = new FileInputStream(targetFile);
                    imageStream = new ContentLengthInputStream((InputStream)new BufferedInputStream(input, 32768), input.available());
                }
                catch (Exception e) {
                    if (!ApngImageLoader.enableDebugLog) break block14;
                    FLog.w((String)"Error: %s", (Object[])new Object[]{e.toString()});
                }
            }
        }
        return imageStream;
    }
}

