/*
 * Decompiled with CFR 0.152.
 */
package com.github.sahasbhop.apngview.assist;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import com.github.sahasbhop.apngview.ApngDrawable;
import com.github.sahasbhop.apngview.ApngImageLoader;
import com.github.sahasbhop.apngview.R;
import com.github.sahasbhop.apngview.assist.ApngImageLoaderCallback;
import com.github.sahasbhop.apngview.assist.AssistUtil;
import com.github.sahasbhop.flog.FLog;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.utils.DiskCacheUtils;
import com.nostra13.universalimageloader.utils.MemoryCacheUtils;
import java.io.File;

public class ApngImageLoadingListener
implements ImageLoadingListener {
    private ApngImageLoaderCallback callback;
    private Context context;
    private Uri uri;

    public ApngImageLoadingListener(Context context, Uri uri, ApngImageLoaderCallback callback) {
        this.context = context;
        this.uri = uri;
        this.callback = callback;
    }

    public void onLoadingStarted(String imageUri, View view) {
        if (view == null) {
            return;
        }
        view.setTag(R.id.tag_image, (Object)this.uri.toString());
    }

    public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
        if (view == null) {
            return;
        }
        Object tag = view.getTag(R.id.tag_image);
        if (ApngImageLoader.enableDebugLog) {
            FLog.d((String)"tag: %s", (Object[])new Object[]{tag});
        }
        if (tag != null && tag instanceof String) {
            String actualUri = tag.toString();
            File pngFile = AssistUtil.getCopiedFile(this.context, actualUri);
            if (pngFile == null) {
                if (ApngImageLoader.enableDebugLog) {
                    FLog.w((String)"Can't locate the file!!! %s", (Object[])new Object[]{actualUri});
                }
            } else if (pngFile.exists()) {
                boolean isApng = AssistUtil.isApng(pngFile);
                if (isApng) {
                    if (ApngImageLoader.enableDebugLog) {
                        FLog.d((String)"Setup apng drawable", (Object[])new Object[0]);
                    }
                    ApngDrawable drawable = new ApngDrawable(this.context, loadedImage, Uri.fromFile((File)pngFile));
                    ((ImageView)view).setImageDrawable((Drawable)drawable);
                } else {
                    ((ImageView)view).setImageBitmap(loadedImage);
                }
            } else {
                if (ApngImageLoader.enableDebugLog) {
                    FLog.d((String)"Clear cache and reload", (Object[])new Object[0]);
                }
                MemoryCacheUtils.removeFromCache((String)actualUri, (MemoryCache)ApngImageLoader.getInstance().getMemoryCache());
                DiskCacheUtils.removeFromCache((String)actualUri, (DiskCache)ApngImageLoader.getInstance().getDiskCache());
                ApngImageLoader.getInstance().displayImage(actualUri, (ImageView)view, this);
            }
        }
        if (this.shouldForward()) {
            this.callback.onLoadFinish(true, imageUri, view);
        }
    }

    public void onLoadingCancelled(String imageUri, View view) {
        if (view == null) {
            return;
        }
        Object tag = view.getTag(R.id.tag_image);
        if (ApngImageLoader.enableDebugLog) {
            FLog.d((String)"tag: %s", (Object[])new Object[]{tag});
        }
        view.setTag(R.id.tag_image, null);
        if (this.shouldForward()) {
            this.callback.onLoadFinish(false, imageUri, view);
        }
    }

    public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
        if (view == null) {
            return;
        }
        Object tag = view.getTag(R.id.tag_image);
        if (ApngImageLoader.enableDebugLog) {
            FLog.d((String)"tag: %s", (Object[])new Object[]{tag});
        }
        view.setTag(R.id.tag_image, null);
        if (this.shouldForward()) {
            this.callback.onLoadFinish(false, imageUri, view);
        }
    }

    private boolean shouldForward() {
        return this.callback != null;
    }
}

