/*
 * Decompiled with CFR 0.152.
 */
package com.github.sahasbhop.apngview.assist;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import ar.com.hjg.pngj.PngReaderApng;
import com.github.sahasbhop.apngview.ApngImageLoader;
import com.github.sahasbhop.flog.FLog;
import java.io.File;
import java.security.MessageDigest;
import java.util.Arrays;

public class AssistUtil {
    public static final long MAX_SIZE = 5000000L;
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private AssistUtil() {
    }

    public static void checkCahceSize(File cacheDir, long maxSize) {
        long cacheSize = AssistUtil.getDirSize(cacheDir);
        if (ApngImageLoader.enableVerboseLog) {
            FLog.v((String)"checkCacheSize: %d", (Object[])new Object[]{cacheSize});
        }
        if (maxSize < 1L && cacheSize >= 5000000L) {
            AssistUtil.cleanDir(cacheDir, cacheSize - 5000000L);
        } else if (maxSize > 0L && cacheSize >= maxSize) {
            AssistUtil.cleanDir(cacheDir, cacheSize - maxSize);
        }
    }

    private static void cleanDir(File dir, long bytes) {
        File[] files;
        long bytesDeleted = 0L;
        for (File file : files = AssistUtil.listFilesSortingByDate(dir)) {
            bytesDeleted += file.length();
            boolean isSuccess = file.delete();
            if (ApngImageLoader.enableVerboseLog) {
                FLog.v((String)"Delete(%s): %s", (Object[])new Object[]{isSuccess ? "success" : "failed", file.getPath()});
            }
            if (bytesDeleted >= bytes) break;
        }
    }

    private static long getDirSize(File dir) {
        File[] files;
        long size = 0L;
        for (File file : files = AssistUtil.listFilesSortingByDate(dir)) {
            if (!file.isFile()) continue;
            size += file.length();
        }
        return size;
    }

    public static File[] listFilesSortingByDate(File directory) {
        int i;
        File[] files = directory.listFiles();
        Object[] pairs = new Pair[files.length];
        for (i = 0; i < files.length; ++i) {
            pairs[i] = new Pair(files[i]);
        }
        Arrays.sort(pairs);
        for (i = 0; i < files.length; ++i) {
            files[i] = ((Pair)pairs[i]).f;
        }
        return files;
    }

    public static boolean isApng(File file) {
        boolean isApng;
        block2: {
            isApng = false;
            try {
                PngReaderApng reader = new PngReaderApng(file);
                reader.end();
                int apngNumFrames = reader.getApngNumFrames();
                isApng = apngNumFrames > 1;
            }
            catch (Exception e) {
                if (!ApngImageLoader.enableDebugLog) break block2;
                FLog.w((String)"Error: %s", (Object[])new Object[]{e.toString()});
            }
        }
        return isApng;
    }

    public static File getWorkingDir(Context context) {
        File workingDir = null;
        File cacheDir = context.getExternalCacheDir();
        if (cacheDir == null) {
            cacheDir = context.getCacheDir();
        }
        if (cacheDir != null && !(workingDir = new File(String.format("%s/apng/.nomedia/", cacheDir.getPath()))).exists()) {
            workingDir.mkdirs();
        }
        return workingDir;
    }

    public static File getCopiedFile(Context context, String imageUri) {
        String filename;
        try {
            filename = String.format("%s.png", AssistUtil.md5(imageUri));
        }
        catch (Exception e) {
            filename = Uri.parse((String)imageUri).getLastPathSegment();
        }
        File workingDir = AssistUtil.getWorkingDir(context);
        File f = null;
        if (workingDir != null && workingDir.exists()) {
            f = new File(workingDir, filename);
        }
        return f;
    }

    private static String md5(String message) throws Exception {
        MessageDigest md = MessageDigest.getInstance("md5");
        return AssistUtil.bytesToHex(md.digest(message.getBytes("utf-8")));
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    static class Pair
    implements Comparable<Pair> {
        public long t;
        public File f;

        public Pair(File file) {
            this.f = file;
            this.t = file.lastModified();
        }

        @Override
        public int compareTo(@NonNull Pair o) {
            long u = o.t;
            return this.t < u ? -1 : (this.t == u ? 0 : 1);
        }
    }
}

