/*
 * Decompiled with CFR 0.152.
 */
package com.github.sahasbhop.flog;

import android.os.Process;
import android.util.Log;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FLog {
    private static final int STACKTRACE_LIMIT = 50;
    private static String sLogFilePath;
    private static String sLogFileName;
    private static boolean sEnableLogcat;
    private static boolean sEnableSystemOut;
    private static boolean sEnableFileLog;
    public static final DateFormat sFileLogDateFormat;

    public static void setEnableLogCat(boolean enable) {
        sEnableLogcat = enable;
    }

    public static void setEnableSystemOut(boolean enable) {
        sEnableSystemOut = enable;
    }

    public static void setEnableFileLog(boolean enable, String path, String fileName) {
        sEnableFileLog = enable;
        if (enable && path != null && fileName != null) {
            sLogFilePath = path.trim();
            sLogFileName = fileName.trim();
            if (!sLogFilePath.endsWith("/")) {
                sLogFilePath = sLogFilePath + "/";
            }
        }
    }

    public static String getLogFilePaht() {
        return sLogFilePath;
    }

    public static String getLogFileName() {
        return sLogFileName;
    }

    public static synchronized void v(String format, Object ... args) {
        String msg = String.format(format, args);
        String tag = null;
        StackTraceElement element = FLog.getStackTraceElement();
        if (element != null) {
            tag = FLog.getTag(element);
            msg = FLog.getPrettyLog(element, msg);
        }
        if (sEnableLogcat) {
            Log.v((String)tag, (String)msg);
        }
        if (sEnableSystemOut) {
            System.out.println(msg);
        }
        if (sEnableFileLog) {
            FLog.writeLogToFile(LogType.VERBOSE, tag, msg);
        }
    }

    public static synchronized void v(String msg, Throwable e) {
        String tag = null;
        StackTraceElement element = FLog.getStackTraceElement();
        if (element != null) {
            tag = FLog.getTag(element);
            msg = FLog.getPrettyLog(element, msg);
        }
        if (sEnableLogcat) {
            Log.v((String)tag, (String)msg, (Throwable)e);
        }
        if (sEnableSystemOut) {
            System.out.println(msg);
            e.printStackTrace();
        }
        if (sEnableFileLog) {
            FLog.writeLogToFile(LogType.VERBOSE, tag, msg, e);
        }
    }

    public static synchronized void d(String format, Object ... args) {
        String msg = String.format(format, args);
        String tag = null;
        StackTraceElement element = FLog.getStackTraceElement();
        if (element != null) {
            tag = FLog.getTag(element);
            msg = FLog.getPrettyLog(element, msg);
        }
        if (sEnableLogcat) {
            Log.d((String)tag, (String)msg);
        }
        if (sEnableSystemOut) {
            System.out.println(msg);
        }
        if (sEnableFileLog) {
            FLog.writeLogToFile(LogType.DEBUG, tag, msg);
        }
    }

    public static synchronized void d(String msg, Throwable e) {
        String tag = null;
        StackTraceElement element = FLog.getStackTraceElement();
        if (element != null) {
            tag = FLog.getTag(element);
            msg = FLog.getPrettyLog(element, msg);
        }
        if (sEnableLogcat) {
            Log.d((String)tag, (String)msg, (Throwable)e);
        }
        if (sEnableSystemOut) {
            System.out.println(msg);
            e.printStackTrace();
        }
        if (sEnableFileLog) {
            FLog.writeLogToFile(LogType.DEBUG, tag, msg, e);
        }
    }

    public static synchronized void i(String format, Object ... args) {
        String msg = String.format(format, args);
        String tag = null;
        StackTraceElement element = FLog.getStackTraceElement();
        if (element != null) {
            tag = FLog.getTag(element);
            msg = FLog.getPrettyLog(element, msg);
        }
        if (sEnableLogcat) {
            Log.i((String)tag, (String)msg);
        }
        if (sEnableSystemOut) {
            System.out.println(msg);
        }
        if (sEnableFileLog) {
            FLog.writeLogToFile(LogType.INFO, tag, msg);
        }
    }

    public static synchronized void i(String msg, Throwable e) {
        String tag = null;
        StackTraceElement element = FLog.getStackTraceElement();
        if (element != null) {
            tag = FLog.getTag(element);
            msg = FLog.getPrettyLog(element, msg);
        }
        if (sEnableLogcat) {
            Log.i((String)tag, (String)msg, (Throwable)e);
        }
        if (sEnableSystemOut) {
            System.out.println(msg);
            e.printStackTrace();
        }
        if (sEnableFileLog) {
            FLog.writeLogToFile(LogType.INFO, tag, msg, e);
        }
    }

    public static synchronized void w(String format, Object ... args) {
        String msg = String.format(format, args);
        String tag = null;
        StackTraceElement element = FLog.getStackTraceElement();
        if (element != null) {
            tag = FLog.getTag(element);
            msg = FLog.getPrettyLog(element, msg);
        }
        if (sEnableLogcat) {
            Log.w((String)tag, (String)msg);
        }
        if (sEnableSystemOut) {
            System.out.println(msg);
        }
        if (sEnableFileLog) {
            FLog.writeLogToFile(LogType.WARNING, tag, msg);
        }
    }

    public static synchronized void w(String msg, Throwable e) {
        String tag = null;
        StackTraceElement element = FLog.getStackTraceElement();
        if (element != null) {
            tag = FLog.getTag(element);
            msg = FLog.getPrettyLog(element, msg);
        }
        if (sEnableLogcat) {
            Log.w((String)tag, (String)msg, (Throwable)e);
        }
        if (sEnableSystemOut) {
            System.out.println(msg);
            e.printStackTrace();
        }
        if (sEnableFileLog) {
            FLog.writeLogToFile(LogType.WARNING, tag, msg, e);
        }
    }

    public static synchronized void e(String format, Object ... args) {
        String msg = String.format(format, args);
        String tag = null;
        StackTraceElement element = FLog.getStackTraceElement();
        if (element != null) {
            tag = FLog.getTag(element);
            msg = FLog.getPrettyLog(element, msg);
        }
        if (sEnableLogcat) {
            Log.e((String)tag, (String)msg);
        }
        if (sEnableSystemOut) {
            System.out.println(msg);
        }
        if (sEnableFileLog) {
            FLog.writeLogToFile(LogType.ERROR, tag, msg);
        }
    }

    public static synchronized void e(String msg, Throwable e) {
        String tag = null;
        StackTraceElement element = FLog.getStackTraceElement();
        if (element != null) {
            tag = FLog.getTag(element);
            msg = FLog.getPrettyLog(element, msg);
        }
        if (sEnableLogcat) {
            Log.e((String)tag, (String)msg, (Throwable)e);
        }
        if (sEnableSystemOut) {
            System.out.println(msg);
            e.printStackTrace();
        }
        if (sEnableFileLog) {
            FLog.writeLogToFile(LogType.ERROR, tag, msg, e);
        }
    }

    private static synchronized void writeLogToFile(LogType level, String tag, String msg, Throwable e) {
        String stacktrace = FLog.getStackTraceLog(msg, e);
        FLog.writeLogToFile(level, tag, stacktrace);
    }

    private static synchronized void writeLogToFile(LogType level, String tag, String msg) {
        if (sLogFilePath != null && !sLogFilePath.equals("") && sLogFileName != null && !sLogFileName.equals("")) {
            File f = new File(sLogFilePath);
            if (!f.exists()) {
                try {
                    f.mkdirs();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (f.canWrite()) {
                String log = FLog.getLogDisplay(level, tag, msg);
                f = new File(sLogFilePath + sLogFileName);
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new StringReader(log), 256);
                    BufferedWriter writer = new BufferedWriter(new FileWriter(f, true), 256);
                    while ((line = reader.readLine()) != null) {
                        writer.append(line);
                        writer.append("\r\n");
                    }
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static String getStackTraceLog(String msg, Throwable e) {
        StringBuilder b = new StringBuilder();
        b.append(msg).append("\n");
        if (e != null) {
            b.append(e.toString()).append("\n");
            StackTraceElement[] elements = e.getStackTrace();
            if (elements != null) {
                for (int i = 0; i < elements.length && i < 50; ++i) {
                    StackTraceElement element = elements[i];
                    if (element == null) continue;
                    b.append("\tat ").append(element.toString()).append("\n");
                }
                int more = elements.length - 50;
                if (more > 0) {
                    b.append("\t... ").append(more).append(" more").append("\n");
                }
            }
        }
        return b.toString();
    }

    public static String getLogDisplay(LogType level, String tag, String msg) {
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new StringReader(msg), 256);
            Date date = new Date();
            date.setTime(System.currentTimeMillis());
            String time = sFileLogDateFormat.format(date);
            while ((line = reader.readLine()) != null) {
                builder.append(String.format("%s: ", time));
                builder.append(String.format("%s/%s(%d): ", new Object[]{level, tag, Process.myPid()}));
                builder.append(line);
                builder.append("\r\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    private static StackTraceElement getStackTraceElement() {
        StackTraceElement element = null;
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements != null && elements.length >= 5) {
            element = elements[4];
        }
        return element;
    }

    private static String getTag(StackTraceElement element) {
        if (element == null) {
            return null;
        }
        String className = element.getClassName();
        if (className != null) {
            String[] paths = className.split("\\.");
            className = paths.length > 0 ? paths[paths.length - 1] : className;
        }
        return className;
    }

    private static String getPrettyLog(StackTraceElement element, String msg) {
        if (element == null) {
            return msg;
        }
        return String.format("%s # %s", element.getMethodName(), msg);
    }

    static {
        sEnableLogcat = true;
        sEnableSystemOut = false;
        sEnableFileLog = false;
        sFileLogDateFormat = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss.SSS", Locale.ENGLISH);
    }

    public static enum LogType {
        ERROR,
        WARNING,
        DEBUG,
        INFO,
        VERBOSE;

    }
}

