/*
 * Decompiled with CFR 0.152.
 */
package com.github.sakserv.minicluster.impl;

import com.github.sakserv.minicluster.MiniCluster;
import com.github.sakserv.minicluster.util.FileUtils;
import com.github.sakserv.minicluster.util.WindowsLibsUtils;
import java.io.File;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveLocalMetaStore
implements MiniCluster {
    private static final Logger LOG = LoggerFactory.getLogger(HiveLocalMetaStore.class);
    private String hiveMetastoreHostname;
    private Integer hiveMetastorePort;
    private String hiveMetastoreDerbyDbDir;
    private String hiveScratchDir;
    private String hiveWarehouseDir;
    private HiveConf hiveConf;
    private Thread t;

    private HiveLocalMetaStore(Builder builder) {
        this.hiveMetastoreHostname = builder.hiveMetastoreHostname;
        this.hiveMetastorePort = builder.hiveMetastorePort;
        this.hiveMetastoreDerbyDbDir = builder.hiveMetastoreDerbyDbDir;
        this.hiveScratchDir = builder.hiveScratchDir;
        this.hiveWarehouseDir = builder.hiveWarehouseDir;
        this.hiveConf = builder.hiveConf;
    }

    public String getHiveMetastoreHostname() {
        return this.hiveMetastoreHostname;
    }

    public Integer getHiveMetastorePort() {
        return this.hiveMetastorePort;
    }

    public String getHiveMetastoreDerbyDbDir() {
        return this.hiveMetastoreDerbyDbDir;
    }

    public String getHiveScratchDir() {
        return this.hiveScratchDir;
    }

    public HiveConf getHiveConf() {
        return this.hiveConf;
    }

    public String getHiveWarehouseDir() {
        return this.hiveWarehouseDir;
    }

    public void start() throws Exception {
        LOG.info("HIVEMETASTORE: Starting Hive Metastore on port: {}", (Object)this.hiveMetastorePort);
        this.configure();
        StartHiveLocalMetaStore startHiveLocalMetaStore = new StartHiveLocalMetaStore();
        startHiveLocalMetaStore.setHiveMetastorePort(this.hiveMetastorePort);
        startHiveLocalMetaStore.setHiveConf(this.hiveConf);
        this.t = new Thread(startHiveLocalMetaStore);
        this.t.setDaemon(true);
        this.t.start();
    }

    public void stop() throws Exception {
        this.stop(true);
    }

    public void stop(boolean cleanUp) throws Exception {
        LOG.info("HIVEMETASTORE: Stopping Hive Metastore on port: {}", (Object)this.hiveMetastorePort);
        this.t.interrupt();
        if (cleanUp) {
            this.cleanUp();
        }
    }

    public void configure() throws Exception {
        this.hiveConf.setVar(HiveConf.ConfVars.METASTOREURIS, "thrift://" + this.hiveMetastoreHostname + ":" + this.hiveMetastorePort);
        this.hiveConf.setVar(HiveConf.ConfVars.SCRATCHDIR, this.hiveScratchDir);
        this.hiveConf.setVar(HiveConf.ConfVars.METASTORECONNECTURLKEY, "jdbc:derby:;databaseName=" + this.hiveMetastoreDerbyDbDir + ";create=true");
        this.hiveConf.setVar(HiveConf.ConfVars.METASTOREWAREHOUSE, new File(this.hiveWarehouseDir).getAbsolutePath());
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST, true);
        this.hiveConf.set("datanucleus.schema.autoCreateTables", "true");
        this.hiveConf.set("hive.metastore.schema.verification", "false");
        WindowsLibsUtils.setHadoopHome();
    }

    public void cleanUp() throws Exception {
        FileUtils.deleteFolder((String)this.hiveMetastoreDerbyDbDir);
        FileUtils.deleteFolder((String)this.hiveWarehouseDir);
        FileUtils.deleteFolder((String)new File("derby.log").getAbsolutePath());
    }

    private static class StartHiveLocalMetaStore
    implements Runnable {
        private Integer hiveMetastorePort;
        private HiveConf hiveConf;

        private StartHiveLocalMetaStore() {
        }

        public void setHiveMetastorePort(Integer hiveMetastorePort) {
            this.hiveMetastorePort = hiveMetastorePort;
        }

        public void setHiveConf(HiveConf hiveConf) {
            this.hiveConf = hiveConf;
        }

        @Override
        public void run() {
            try {
                HiveMetaStore.startMetaStore((int)this.hiveMetastorePort, (HadoopThriftAuthBridge)new HadoopThriftAuthBridge(), (HiveConf)this.hiveConf);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static class Builder {
        private String hiveMetastoreHostname;
        private Integer hiveMetastorePort;
        private String hiveMetastoreDerbyDbDir;
        private String hiveScratchDir;
        private String hiveWarehouseDir;
        private HiveConf hiveConf;

        public Builder setHiveMetastoreHostname(String hiveMetastoreHostname) {
            this.hiveMetastoreHostname = hiveMetastoreHostname;
            return this;
        }

        public Builder setHiveMetastorePort(int hiveMetaStorePort) {
            this.hiveMetastorePort = hiveMetaStorePort;
            return this;
        }

        public Builder setHiveMetastoreDerbyDbDir(String hiveDerbyDbDir) {
            this.hiveMetastoreDerbyDbDir = hiveDerbyDbDir;
            return this;
        }

        public Builder setHiveScratchDir(String hiveScratchDir) {
            this.hiveScratchDir = hiveScratchDir;
            return this;
        }

        public Builder setHiveConf(HiveConf hiveConf) {
            this.hiveConf = hiveConf;
            return this;
        }

        public Builder setHiveWarehouseDir(String hiveWarehouseDir) {
            this.hiveWarehouseDir = hiveWarehouseDir;
            return this;
        }

        public HiveLocalMetaStore build() {
            HiveLocalMetaStore hiveLocalMetaStore = new HiveLocalMetaStore(this);
            this.validateObject(hiveLocalMetaStore);
            return hiveLocalMetaStore;
        }

        public void validateObject(HiveLocalMetaStore hiveLocalMetaStore) {
            if (hiveLocalMetaStore.hiveMetastoreHostname == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: Hive Meta Store Hostname");
            }
            if (hiveLocalMetaStore.hiveMetastorePort == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: Hive Meta Store Port");
            }
            if (hiveLocalMetaStore.hiveMetastoreDerbyDbDir == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: Hive Derby Db Path");
            }
            if (hiveLocalMetaStore.hiveScratchDir == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: Hive Scratch Dir");
            }
            if (hiveLocalMetaStore.hiveWarehouseDir == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: Hive Warehouse Dir");
            }
            if (hiveLocalMetaStore.hiveConf == null) {
                throw new IllegalArgumentException("ERROR: Missing required config: Hive Conf");
            }
        }
    }
}

