/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.api;

import com.hulaki.smtp.api.ApiRequest;
import com.hulaki.smtp.api.ApiResponse;
import com.hulaki.smtp.api.ClearRequest;
import com.hulaki.smtp.api.CountRequest;
import com.hulaki.smtp.api.CountResponse;
import com.hulaki.smtp.api.GetRequest;
import com.hulaki.smtp.api.GetResponse;
import com.hulaki.smtp.api.IApiClient;
import com.hulaki.smtp.api.MailMessage;
import com.hulaki.smtp.api.RelayMode;
import com.hulaki.smtp.api.RelayRequest;
import com.hulaki.smtp.api.RelayResponse;
import com.hulaki.smtp.api.StatusResponse;
import com.hulaki.smtp.exceptions.ApiException;
import com.hulaki.smtp.exceptions.SmtpTimeoutException;
import com.hulaki.smtp.utils.EmailUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Socket;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.util.Assert;

public class ApiClient
implements IApiClient {
    private final Logger logger = Logger.getLogger(ApiClient.class);
    private final long DEFAULT_TIMEOUT_IN_MILLIS = 8000L;
    private final long MAX_NUM_OF_TIMES_TO_POLL = 8L;
    private final String apiServerHostname;
    private final int apiServerPort;

    public ApiClient(String apiServerHostname, int apiServerPort) {
        this.apiServerHostname = apiServerHostname;
        this.apiServerPort = apiServerPort;
    }

    @Override
    public void waitForNewEmailOrFail(String recipient, int oldEmailCount) throws InterruptedException {
        this.waitForNewEmailOrFail(recipient, oldEmailCount, 8000L);
    }

    @Override
    public void waitForNewEmailOrFail(String recipient, int oldEmailCount, long timeoutInMillis) throws InterruptedException {
        long sleepTime = timeoutInMillis / 8L;
        int newEmailCount = this.countMails(recipient);
        int pollCounter = 0;
        while (newEmailCount <= oldEmailCount && (long)pollCounter < 8L) {
            ++pollCounter;
            Thread.sleep(sleepTime);
            newEmailCount = this.countMails(recipient);
        }
        if (newEmailCount <= oldEmailCount) {
            throw new SmtpTimeoutException("No new mail was received for " + recipient);
        }
    }

    @Override
    public int countMails() {
        this.logger.debug((Object)"Counting ALL emails stored on the server...");
        CountRequest countRequest = new CountRequest();
        String response = this.sendRequestToApiServer(countRequest);
        CountResponse cResponse = this.unmarshalResponse(response, CountResponse.class);
        this.logger.debug((Object)("Counted " + cResponse.getCount() + " emails"));
        return cResponse.getCount();
    }

    @Override
    public int countMails(String recipient) {
        Assert.notNull((Object)recipient);
        this.logger.debug((Object)("Counting emails for recipient: " + recipient + "..."));
        CountRequest countRequest = new CountRequest();
        String normalizedEmail = EmailUtils.normalizeEmailAddress(recipient);
        countRequest.setRecipient(normalizedEmail);
        String response = this.sendRequestToApiServer(countRequest);
        CountResponse cResponse = this.unmarshalResponse(response, CountResponse.class);
        this.logger.debug((Object)("Counted " + cResponse.getCount() + " emails sent to " + recipient));
        return cResponse.getCount();
    }

    @Override
    public void clearMails(String recipient) {
        this.logger.debug((Object)("Clearing emails for recipient: " + recipient + "..."));
        String normalizedEmail = EmailUtils.normalizeEmailAddress(recipient);
        ClearRequest clearRequest = new ClearRequest().setRecipient(normalizedEmail);
        String response = this.sendRequestToApiServer(clearRequest);
        StatusResponse sResponse = this.unmarshalResponse(response, StatusResponse.class);
        assert (sResponse.getStatus() == 200);
        this.logger.debug((Object)("All emails cleared for recipient: " + recipient));
    }

    @Override
    public List<MailMessage> getMessages(String recipient) {
        this.logger.debug((Object)("Retrieving emails for recipient: " + recipient + "..."));
        String normalizedEmail = EmailUtils.normalizeEmailAddress(recipient);
        GetRequest getRequest = new GetRequest().setRecipient(normalizedEmail);
        String response = this.sendRequestToApiServer(getRequest);
        GetResponse getResponse = this.unmarshalResponse(response, GetResponse.class);
        this.logger.debug((Object)("Retrieved " + getResponse.getMessages().size() + " emails for recipient: " + recipient));
        return getResponse.getMessages();
    }

    @Override
    public boolean isRelayRecipient(String recipient) {
        this.logger.debug((Object)("Checking if " + recipient + " is a relay recipient..."));
        String normalizedEmail = EmailUtils.normalizeEmailAddress(recipient);
        RelayRequest relayRequest = new RelayRequest(RelayMode.GET);
        relayRequest.setRecipient(normalizedEmail);
        String response = this.sendRequestToApiServer(relayRequest);
        StatusResponse statusResponse = this.unmarshalResponse(response, StatusResponse.class);
        boolean isRelayRecipient = statusResponse.getStatus() == 200;
        this.logger.debug((Object)(recipient + (isRelayRecipient ? " is" : " isn't") + " a relay recipient"));
        return isRelayRecipient;
    }

    @Override
    public void addRelayRecipient(String recipient) {
        this.logger.debug((Object)("Making " + recipient + " a relay recipient..."));
        String normalizedEmail = EmailUtils.normalizeEmailAddress(recipient);
        RelayRequest relayRequest = new RelayRequest(RelayMode.ADD);
        relayRequest.setRecipient(normalizedEmail);
        String response = this.sendRequestToApiServer(relayRequest);
        StatusResponse statusResponse = this.unmarshalResponse(response, StatusResponse.class);
        assert (statusResponse.getStatus() == 200);
        this.logger.debug((Object)(recipient + " is now a relay recipient."));
    }

    @Override
    public void removeRelayRecipient(String recipient) {
        this.logger.debug((Object)("Removing " + recipient + " from list of relay recipients..."));
        String normalizedEmail = EmailUtils.normalizeEmailAddress(recipient);
        RelayRequest relayRequest = new RelayRequest(RelayMode.REMOVE);
        relayRequest.setRecipient(normalizedEmail);
        String response = this.sendRequestToApiServer(relayRequest);
        StatusResponse statusResponse = this.unmarshalResponse(response, StatusResponse.class);
        assert (statusResponse.getStatus() == 200);
        this.logger.debug((Object)(recipient + " is no more a relay recipient."));
    }

    @Override
    public void clearRelayRecipients() {
        this.logger.debug((Object)"Removing ALL relay recipients...");
        RelayRequest relayRequest = new RelayRequest(RelayMode.REMOVE);
        String response = this.sendRequestToApiServer(relayRequest);
        StatusResponse statusResponse = this.unmarshalResponse(response, StatusResponse.class);
        assert (statusResponse.getStatus() == 200);
        this.logger.debug((Object)"Relay recipient list cleared.");
    }

    @Override
    public List<String> getRelayRecipients() {
        this.logger.debug((Object)"Retrieving the list of relay recipients...");
        RelayRequest relayRequest = new RelayRequest(RelayMode.GET);
        String response = this.sendRequestToApiServer(relayRequest);
        RelayResponse relayResponse = this.unmarshalResponse(response, RelayResponse.class);
        this.logger.debug((Object)("Currently " + relayResponse.getRelayRecipients().getRecipients().size() + " relay recipieints are registered."));
        return relayResponse.getRelayRecipients().getRecipients();
    }

    private <T> T unmarshalResponse(String response, Class<T> clazz) {
        try {
            return (T)ApiResponse.unmarshalResponse(response, clazz);
        }
        catch (Exception ioe) {
            throw new ApiException(ioe);
        }
    }

    private String sendRequestToApiServer(ApiRequest request) {
        try {
            String inputLine;
            Socket clientSocket = new Socket(this.apiServerHostname, this.apiServerPort);
            DataOutputStream out = new DataOutputStream(clientSocket.getOutputStream());
            String requestString = request.toRequestString() + "\n";
            this.logger.trace((Object)requestString);
            out.writeBytes(requestString);
            StringBuilder response = new StringBuilder();
            this.logger.trace((Object)response.toString());
            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine).append("\n");
            }
            clientSocket.close();
            return response.toString();
        }
        catch (ConnectException e) {
            throw new ApiException("SMTP mock not available at " + this.apiServerHostname + ":" + this.apiServerPort);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }
}

