/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.api;

import com.hulaki.smtp.api.ApiCommand;
import com.hulaki.smtp.api.ClearRequest;
import com.hulaki.smtp.api.CountRequest;
import com.hulaki.smtp.api.GetRequest;
import com.hulaki.smtp.api.InvalidRequest;
import com.hulaki.smtp.api.RelayRequest;
import com.hulaki.smtp.api.ServerStatusRequest;
import com.hulaki.smtp.exceptions.ApiProtocolException;

public abstract class ApiRequest {
    private String requestBody;
    private ApiCommand command;

    public ApiRequest(String requestBody, ApiCommand command) throws ApiProtocolException {
        this.requestBody = requestBody;
        this.command = command;
    }

    public ApiRequest(ApiCommand command) {
        this.command = command;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public ApiCommand getCommand() {
        return this.command;
    }

    public abstract String toRequestString();

    public static ApiRequest fromRequestString(String requestBody) {
        if (requestBody == null) {
            throw new ApiProtocolException("Unrecognized command received.");
        }
        String[] tokens = requestBody.split(" ");
        String command = tokens[0];
        if (command.equalsIgnoreCase(ApiCommand.COUNT.getCommand())) {
            return new CountRequest(requestBody);
        }
        if (command.equalsIgnoreCase(ApiCommand.GET.getCommand())) {
            return new GetRequest(requestBody);
        }
        if (command.equalsIgnoreCase(ApiCommand.CLEAR.getCommand())) {
            return new ClearRequest(requestBody);
        }
        if (command.equalsIgnoreCase(ApiCommand.RELAY.getCommand())) {
            return new RelayRequest(requestBody);
        }
        if (command.equalsIgnoreCase(ApiCommand.SERVER_STATUS.getCommand())) {
            return new ServerStatusRequest(requestBody);
        }
        return new InvalidRequest(requestBody);
    }
}

