/*
 * Decompiled with CFR 0.152.
 */
package com.hulaki.smtp.api;

import com.hulaki.smtp.api.ApiCommand;
import com.hulaki.smtp.api.ApiRequest;
import com.hulaki.smtp.exceptions.ApiProtocolException;
import com.hulaki.smtp.utils.EmailUtils;

public class ClearRequest
extends ApiRequest {
    private String recipient;

    public ClearRequest(String requestBody) throws ApiProtocolException {
        super(requestBody, ApiCommand.CLEAR);
        String[] tokens = requestBody.split(" ");
        if (tokens.length != 2) {
            throw new ApiProtocolException("The count request should be in format COUNT <email-address>");
        }
        this.recipient = EmailUtils.normalizeEmailAddress(tokens[1]);
    }

    public ClearRequest() {
        super(ApiCommand.CLEAR);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public ClearRequest setRecipient(String recipient) {
        this.recipient = recipient;
        return this;
    }

    @Override
    public String toRequestString() {
        return (Object)((Object)this.getCommand()) + " " + this.getRecipient();
    }
}

